<?php
class Home extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/v2/General_model','general_obj');
		//$this->load->library('session');
	}

	function index()
 	{	
		
		
 		if ($this->session->userdata('logged_in_elbaweb')) 
 		{		

 			$getdata = $this->session->userdata('logged_in_elbaweb');
			$user_id = $getdata['user_id'];

			$api_url = base_url('admin/v2/vendor/Api/get_beach_list');

		
			$form_data = array(
				'user_id' => $user_id,
			);

		
			$client = curl_init($api_url);
			curl_setopt($client, CURLOPT_POST, true);
			curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
			curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
			$response = curl_exec($client);
			curl_close($client);

			$result = json_decode($response);
				
			$status = $result->status;
			$message = $result->message;
			$data['beach'] = $result->response;


			///////////////////   resort service list ///////////////////////////////

			$api_url1 = base_url('admin/v2/vendor/Api/get_resort_service_list');

		
			$client1 = curl_init($api_url1);
			curl_setopt($client1, CURLOPT_RETURNTRANSFER, true);
			$response1 = curl_exec($client1);
			curl_close($client1);

			$result1 = json_decode($response1);
				
			$status1 = $result1->status;
			$message1 = $result1->message;
			$data['resortservice'] = $result1->response;

			/////////////////////////////////////////////////////////////////


			///////////////////   package service list ///////////////////////////////

			$api_url2 = base_url('admin/v2/vendor/Api/get_package_service_list');

			$client2 = curl_init($api_url2);
			curl_setopt($client2, CURLOPT_RETURNTRANSFER, true);
			$response2 = curl_exec($client2);
			curl_close($client2);

			$result2 = json_decode($response2);
				
			$status2 = $result2->status;
			$message2 = $result2->message;
			$data['packageservice'] = $result2->response;

			/////////////////////////////////////////////////////////////////
			

 			$this->load->view('frontend/template/header');
 			$this->load->view('frontend/template/home',$data);
			$this->load->view('frontend/template/footer');
 		}
	 	else
	 	{
	 		redirect('Login','refresh');
	 	}
 	}



 	function explore_beach_list()
	{	

		$getdata = $this->session->userdata('logged_in_elbaweb');

		$user_id = $getdata['user_id'];

		$type = $_POST['type'];


		$api_url = base_url('admin/v2/vendor/Api/explore_beach_list');

		
		$form_data = array(
			'user_id' => $user_id,
			'type'=>$type,
		);

		
		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data = $result->response;
		

		$output = '';


		if($type=='today')
		{	
			$dates = date("Y-m-d");	
		}
		else
		{	
			$dates = date("Y-m-d", strtotime('tomorrow'));

		}	



		foreach ($data as $key => $value)
		{	

			$beach_id = $value->beach_id ;

			$output .='
				 <div class="col-md-3">   
                    <article class="geodir-category-listing fl-wraps">
                        <div class="geodir-category-img">
                            <a href="javascript:void(0)" class="resortsdata" id="'.$beach_id.'" data-date="'.$dates.'"><img style="height:340px;" src="'.$value->beach_image.'" alt=""></a>
                        </div>
                        <div class="geodir-category-content fl-wrap title-sin_item">
                            <div class="geodir-category-content-title fl-wrap">
                                <div class="geodir-category-content-title-item">
                                    <h3 class="title-sin_map"><a href="javascript:void(0)" class="resortsdata" id="'.$beach_id.'" data-date="'.$dates.'">'.$value->beach_name.'</a></h3>
                                    <div class="geodir-category-location fl-wrap"><a href="#" class="map-item">
                                    	<i class="fas fa-map-marker-alt"></i>
                                    	 '.$value->position_en.' - '.$value->type_name.'
                                    	 </a>
                                  	</div>
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            ';
		}

		if($type=='today')
		{	
			$today = date("l d M");	

			$json['title'] = 'Choose the beach and where to stay today '.$today ;
		}
		else
		{	
			$tomorrow = date("l d M", strtotime('tomorrow'));

			$json['title'] = 'Choose the beach and where to stay tomorrow '.$tomorrow ; 
		}	


		$json['response'] = $output;




		echo json_encode($json);
	}	







 	function explore_package_list()
	{	

		$getdata = $this->session->userdata('logged_in_elbaweb');

		$user_id = $getdata['user_id'];

		$type = $_POST['type'];


		$api_url = base_url('admin/v2/vendor/Api/explore_package_list');

		
		$form_data = array(
			'user_id' => $user_id,
			'type'=>$type,
		);

		
		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data = $result->response;
		

		$output = '';



		if($type=='today')
		{	
			$dates = date("Y-m-d");	
		}
		else
		{	
			$dates = date("Y-m-d", strtotime('tomorrow'));

		}	


		foreach ($data as $key => $value)
		{
			$package_id = $value->package_id ; 

			$output .='
				<div class="rooms-item fl-wrap">
                	<div class="rooms-media">
                    	<img style="height: 200px;" src="'.$value->package_image.'" alt="">
                	</div>
                	<div class="rooms-details">
                    	<div class="rooms-details-header fl-wrap">
                        	<span class="rooms-price">€ '.$value->price.' <strong> / Day</strong></span>
                        	<h3>'.$value->package_service_name_en.'</h3>
                        	<h4>'.$value->resort_name.'</h4>
                        	<p>'.$value->beach_name.'</p>
                    	</div>
                    
                    	<div class="facilities-list fl-wrap">
                        	<div class="list-single-tags tags-stylwrap">
                            	<a href="javascript:void(0);">'.$value->places_available.' / '.$value->total_places.' Available</a>
                        	</div>
                        	';

                        	if($value->places_available > 0)
                        	{
                        		$output .='	
                        			<a href="javascript:void(0)" id="'.$package_id.'" data-date="'.$dates.'" class=" packagedata btn color-bg ajax-link">Details<i class="fas fa-caret-right"></i></a>';
                        	}
                        	else
                        	{
                        		$output .='	
                        			<div style="text-align:end;">
                        			<span style="color:red;">No reservation available</span>
                        			</div>
                        			';
                        	}
                        	$output .='	
                    	</div>
                	</div>
            	</div>
            ';
		}


		if($type=='today')
		{	
			$today = date("l d M");	

			$json['title'] = 'Places availble today '.$today ;
		}
		else
		{	
			$tomorrow = date("l d M", strtotime('tomorrow'));

			$json['title'] = 'Places availble tomorrow '.$tomorrow ; 
		}	

		
		$json['response'] = $output;

		echo json_encode($json);
	}	



}

