<?php 
class Login extends CI_Controller
{
	function __construct()
 	{
 		parent::__construct();
 		$this->load->model('admin/v2/General_model','general_obj');
 		$this->load->library('form_validation');
 	}

 	function index()
 	{	
 		if ($this->session->userdata('logged_in_elbaweb')) 
 		{
 			redirect('Home','refresh');
 		}
	 	else
	 	{
	 		$this->load->view('frontend/login');
	 	}
 	}

	function check_login()
	{	
		$email = $_POST['email'];
		$pass =  $_POST['password'];		

		$this->form_validation->set_rules('email','Email','required');
		$this->form_validation->set_rules('password','Password','required|callback_check_database');

		if ($this->form_validation->run() == FALSE) 
		{
			$this->index();
		}	
		else
		{	
			redirect('Home','refresh');		
		}			
	}

	function check_database()
	{
		$email = $this->input->post('email');
		$password = $this->input->post('password');
		
		$device_id = rand(100000, 999999);
		$device_type = "web";
		$fcm_token = 'iosTest';


		$api_url = base_url('admin/v2/vendor/Api/login');

		$form_data = array(
			'email' => $email,
			'password'=>$password,
			'device_id' => $device_id,
			'device_type' => $device_type,
			'fcm_token' => $fcm_token
		);

		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data = $result->response;

		if($status==1)
		{
			$sess_array = array();
			
			$sess_array = array(
				'login_id' => $data->login_id,
				'user_id' => $data->user_id,
				'profile_image'=>$data->profile_image,
			);
			
			$this->session->set_userdata('logged_in_elbaweb', $sess_array);
			
			return TRUE;
		}
		else
		{
			$this->form_validation->set_message('check_database', '<p style="color: red;text-align: center;">'.$message.'</p>');
			return false;
		}
	}

	function logout()
	{	
		$getdata = $this->session->userdata('logged_in_elbaweb');

		$login_id = $getdata['login_id'];

		$api_url = base_url('admin/v2/vendor/Api/logout');

		$form_data = array(
			'login_id' => $login_id,
		);

		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
				
		$this->session->unset_userdata('logged_in_elbaweb');
		redirect('Login','refresh');
	}
	
	function forgotpassword()
 	{
 		$this->load->view('frontend/forgot_password');
 	}


 	function send_reset_password()
    {
        $api_url = base_url('admin/v2/vendor/Api/email_resend_otp');

        $form_data = array(
            'email'  => $_POST['email'],
        );

        $client = curl_init($api_url);
        curl_setopt($client, CURLOPT_POST, true);
        curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($client);
        curl_close($client);

        $result =  json_decode($response);

        $datas = $result->response ; 

        $data['status']= $result->status;
        $data['message']= $result->message; 
        $data['user_id']= $datas->user_id;
        $data['email']= $datas->user_id;
        $data['email_otp']= $datas->email_otp; 
    	


        echo json_encode($data);
    } 



    function password_reset()
    {
        $api_url = base_url('admin/v2/vendor/Api/reset_password');

        $form_data = array(
            'user_id'  => $_POST['dataid'],
            'new_password'  => $_POST['new_password'],
            'conf_password'  => $_POST['conf_password'],
        );

        $client = curl_init($api_url);
        curl_setopt($client, CURLOPT_POST, true);
        curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($client);
        curl_close($client);

        $result =  json_decode($response);
 

        $data['status']= $result->status;
        $data['message']= $result->message; 
    	
        echo json_encode($data);
    } 

	

}
?>