<?php
class Reservation extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/v2/General_model','general_obj');
	}


	function index()
 	{
 		if ($this->session->userdata('logged_in_elbaweb')) 
 		{		

 			$this->load->view('frontend/template/header');
 			$this->load->view('frontend/reservation');
			$this->load->view('frontend/template/footer');
 		}
	 	else
	 	{
	 		redirect('Login','refresh');
	 	}
 	}



 	function fetch_booking_list()
	{	

		$getdata = $this->session->userdata('logged_in_elbaweb');
		$user_id = $getdata['user_id'];

		$api_url = base_url('admin/v2/vendor/Api/reservation_list_by_user_id');

		
		$form_data = array(
			'user_id' => $user_id,
		);

		
		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data = $result->response;
		

		$output = '';


		foreach ($data as $key => $value)
		{	

			$booking_id = my_encrypt($value->booking_id) ;





			$output .='
				 <div class="listing-item has_one_column" style="">
                    <article class="geodir-category-listing fl-wrap">
                        <div class="geodir-category-img">
                            <a href="'.base_url('Reservation/reservation_detail/').$booking_id.'"><img style="width:100%;height:250px;" src="'.$value->resort_image.'" alt=""></a>
                            
                        </div>
                        <div class="geodir-category-content fl-wrap title-sin_item">
                            <div class="geodir-category-content-title fl-wrap">
                                <div class="geodir-category-content-title-item">
                                    <h3 class="title-sin_map"><a href="'.base_url('Reservation/reservation_detail/').$booking_id.'">'.$value->resort_name.'</a></h3>
                                    <div class="geodir-category-location fl-wrap"><a href="#" class="map-item"><i class="fas fa-map-marker-alt"></i> '.$value->beach_name.'</a></div>
                                </div>
                            </div>
                            <p style="text-align: left !important;">Booking Date: &nbsp;&nbsp;'.date('d-m-Y',strtotime($value->from_date)).'&nbsp;&nbsp;-&nbsp;&nbsp;'.date('d-m-Y',strtotime($value->to_date)).'</p>
                            <p>Booking ID: <a href="javascript:void(0);"># <span>'.$value->booking_id.'</span></a></p>

                            <div class="geodir-category-footer fl-wrap" style="text-align: right;">

                                <a href="'.base_url('Reservation/reservation_detail/').$booking_id.'"  class="btn color-bg">View Booking <i class="fas fa-caret-right"></i></a>
                                
                                <br /><br />
                                                                                    
                            </div>
                        </div>
                    </article>
                </div>
            ';
		}


		$json['response'] = $output;


		echo json_encode($json);
	}	



	function reservation_detail($booking_id)
 	{

 		$bookingid = my_decrypt($booking_id);

 		$getdata = $this->session->userdata('logged_in_elbaweb');
		$user_id = $getdata['user_id'];



		$api_url = base_url('admin/v2/vendor/Api/reservation_detail_by_id');

		$form_data = array(
			'booking_id' => $bookingid,
		);
		

		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data['bookinginfo'] = $result->response;
		
		
		$this->load->view('frontend/template/header');
 		$this->load->view('frontend/reservation_detail',$data);
		$this->load->view('frontend/template/footer');

 	}





}

