<?php
class Resorts extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/v2/General_model','general_obj');
	}


	function setsession()
	{
		$sess_array = array();
			
		$sess_array = array(
			'beach_id' => $_REQUEST['beach_id'],
			'from_date' => $_REQUEST['from_date'],
			'to_date' => $_REQUEST['to_date'],
		);

		$this->session->set_userdata('booking_data', $sess_array);
	}


	function index()
 	{
 		if ($this->session->userdata('logged_in_elbaweb')) 
 		{	
 			
 			$getdata = $this->session->userdata('logged_in_elbaweb');
			$user_id = $getdata['user_id'];

			///////////////////   beach list ///////////////////////////////

			$api_url = base_url('admin/v2/vendor/Api/get_beach_list');

			$form_data = array(
				'user_id' => $user_id,
			);
		
			$client = curl_init($api_url);
			curl_setopt($client, CURLOPT_POST, true);
			curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
			curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
			$response = curl_exec($client);
			curl_close($client);

			$result = json_decode($response);
				
			$status = $result->status;
			$message = $result->message;
			$data['beach'] = $result->response;

			/////////////////////////////////////////////////////////////////


			///////////////////   resort service list ///////////////////////////////

			$api_url1 = base_url('admin/v2/vendor/Api/get_resort_service_list');

		
			$client1 = curl_init($api_url1);
			curl_setopt($client1, CURLOPT_RETURNTRANSFER, true);
			$response1 = curl_exec($client1);
			curl_close($client1);

			$result1 = json_decode($response1);
				
			$status1 = $result1->status;
			$message1 = $result1->message;
			$data['resortservice'] = $result1->response;

			/////////////////////////////////////////////////////////////////


			///////////////////   package service list ///////////////////////////////

			$api_url2 = base_url('admin/v2/vendor/Api/get_package_service_list');

			$client2 = curl_init($api_url2);
			curl_setopt($client2, CURLOPT_RETURNTRANSFER, true);
			$response2 = curl_exec($client2);
			curl_close($client2);

			$result2 = json_decode($response2);
				
			$status2 = $result2->status;
			$message2 = $result2->message;
			$data['packageservice'] = $result2->response;

			/////////////////////////////////////////////////////////////////


 			$this->load->view('frontend/template/header');
 			$this->load->view('frontend/resort',$data);
			$this->load->view('frontend/template/footer');
 		}
	 	else
	 	{
	 		redirect('Login','refresh');
	 	}
 	}


 	function beach_resort_list()
 	{
		
		$getdata = $this->session->userdata('logged_in_elbaweb');
		$user_id = $getdata['user_id'];

		
		if($_POST['beach_id']!=null)
		{ 
			$beach_id = $_POST['beach_id']; 
 		}
 		else
 		{
 			$beach_id =  '';
 		}


 		$from_date = !empty($_POST['from_date']) ? $_POST['from_date'] : '';
 		$to_date = !empty($_POST['to_date']) ? $_POST['to_date'] : ''; 
 		$package_service = !empty($_POST['package_service']) ? $_POST['package_service'] : ''; 
 		$services = !empty($_POST['services']) ? $_POST['services'] : ''; 		



		$api_url = base_url('admin/v2/vendor/Api/get_resortlist_by_beach_id');

		$form_data = array(
			'user_id' => $user_id,
			'beach_id' => $beach_id,
			'from_date' => $from_date,
			'to_date' => $to_date,
			'package_service'=>$package_service,
			'services'=>$services
		);
		


		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data = $result->response;


		$output = '';


		$resortlist = $data->resorts_list ;


		foreach ($resortlist as $key => $value)
		{	

			$resort_id = $value->resort_id;

			if($value->min_price > 0)
			{
				$price = '<div class="listing-counter">Starting From <strong>€ '.$value->min_price.'/Day</strong></div>';
					
			}
			else
			{
				$price = '<div class="listing-counter" style="background-color:orange;"><font color="red">package not available</font></div>';
			}


			$output .='
				  <div class="listing-item">
                    <div class="hotel-card fl-wrap">
                        <div class="geodir-category-img card-post">
                            <a href="javascript:void(0)" class="resortsdata" id="'.$resort_id.'"><img  style="height:300px;" src="'.$value->resort_image.'" alt=""></a>
                            
                            	'.$price.'
                            
                            
                            <div class="geodir-category-opt">
                                
                                <h4><a href="javascript:void(0)" class="resortsdata" id="'.$resort_id.'">'.$value->resort_name.'</a></h4>
                                <div class="geodir-category-location"><a href="#0" class="map-item"><i class="fas fa-map-marker-alt"></i>
                                	 '.round($value->distance).' kms From Center</a></div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            ';
		}
		
		foreach ($resortlist as $key1 => $value1)
		{	
			if($value1->min_price > 0)
			{
				$resortlist[$key1]->prices = '<span class="map-popup-location-price"><strong>Starting From </strong>€ '.$value1->min_price.'/Day</span>';

			}
			else
			{
				$resortlist[$key1]->prices = '<span class="map-popup-location-price"><strong><font color="yellow"><b>package not available</b></font></span>';
			}	

			$resortlist[$key1]->dist = round($value1->distance) ;
		}		

		$json['beach_name'] = $data->beach_name;
		$json['response'] = $output;
		$json['mapdatas'] = $resortlist;

		echo json_encode($json);

 	}


 	function session_resort_detail()
	{
		$sess_array = array();
			
		$sess_array = array(
			'beach_id' => $_REQUEST['beach_id'],
			'resort_id' => $_REQUEST['resort_id'],
			'from_date' => $_REQUEST['from_date'],
			'to_date' => $_REQUEST['to_date'],
		);

		$this->session->set_userdata('booking_data', $sess_array);
	}




 	function resort_detail()
 	{

 		$getdata = $this->session->userdata('logged_in_elbaweb');
		$user_id = $getdata['user_id'];


		$getdata1 = $this->session->userdata('booking_data');
 		$resort_id = $getdata1['resort_id'];
 		$from_date = $getdata1['from_date'];
 		$to_date = $getdata1['to_date']; 


		$api_url = base_url('admin/v2/vendor/Api/resort_detail_by_id');

		$form_data = array(
			'user_id' => $user_id,
			'resort_id' => $resort_id,
			'from_date' => $from_date,
			'to_date' => $to_date,
			'page' => '0',
		);
		

		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data['resortinfo'] = $result->response;
		
		
		$this->load->view('frontend/template/header');
 		$this->load->view('frontend/resort_detail',$data);
		$this->load->view('frontend/template/footer');

 	}


 	function fetch_resort_detail()
 	{

 		$page = $_POST['page'];

 		$getdata = $this->session->userdata('logged_in_elbaweb');
		$user_id = $getdata['user_id'];


		$getdata1 = $this->session->userdata('booking_data');
 		$resort_id = $getdata1['resort_id'];
 		$from_date = $getdata1['from_date'];
 		$to_date = $getdata1['to_date']; 


		$api_url = base_url('admin/v2/vendor/Api/resort_detail_by_id');

		$form_data = array(
			'user_id' => $user_id,
			'resort_id' => $resort_id,
			'from_date' => $from_date,
			'to_date' => $to_date,
			'page' => $page,
		);
		

		$client = curl_init($api_url);
		curl_setopt($client, CURLOPT_POST, true);
		curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
		curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($client);
		curl_close($client);

		$result = json_decode($response);
			
		$status = $result->status;
		$message = $result->message;
		$data = $result->response;




		$package_list = $data->package_list ;


		$output = '';

		foreach ($package_list as $key => $value)
		{
			$package_id = $value->package_id ; 

			$output .='
				<div class="rooms-item fl-wrap">
                	<div class="rooms-media">
                    	<img src="'.$value->package_image.'" alt="">
                	</div>
                	<div class="rooms-details">
                    	<div class="rooms-details-header fl-wrap">
                        	<h3>'.$value->package_service_name_en.'</h3>
                        	<h5>From: <span>'.date('d M',strtotime($value->start_date)).'</span> To: <span>'.date('d M',strtotime($value->end_date)).'</span></h5>
                        	<div style="color: #5ECFB1;font-size: 19px;font-weight: 600;text-align:end;">€ '.$value->price.' <strong> / Day</strong></div>
                    	</div>
                    
                    	<div class="facilities-list fl-wrap">
                        	<div class="list-single-tags tags-stylwrap">
                            	<a href="javascript:void(0);">'.$value->places_available.' / '.$value->total_places.' Available</a>
                        	</div>
                        	';

                        	if($value->places_available > 0)
                        	{
                        		$output .='	
                        			<a href="javascript:void(0)" id="'.$package_id.'" class=" packagedata btn color-bg ajax-link">Details<i class="fas fa-caret-right"></i></a>';
                        	}
                        	else
                        	{
                        		$output .='	
                        			<div style="text-align:end;">
                        			<span style="color:red;">No reservation available</span>
                        			</div>
                        			';
                        	}
                        	$output .='	
                    	</div>
                	</div>
            	</div>
            ';
		}
		$json['count'] = count($package_list);
		$json['page'] = $result->page;
		$json['response'] = $output;

		echo json_encode($json);


 	}



}

