<?php
header('Content-Type: application/json');
class Api extends CI_Controller
{  
	function __construct()   
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
		$this->load->library('pagination');
	}


	function send_mail($email,$message,$subject)
	{	

	    $domain = "creatoro.in";
	    $api_key = "aea425ecaebbfd4c4518eff670a3b5c6-af6c0cec-146032a1";
	    $MailData = array();
	    $MailData['from'] = "Creatoro <no-reply@creatoro.in>";
	    $MailData['to'] = $email;
	    $MailData['subject'] = $subject;
	    $MailData['html'] = $message;
	  
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	    curl_setopt($ch, CURLOPT_USERPWD, 'api:'.$api_key);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	    curl_setopt($ch, CURLOPT_URL, 'https://api.mailgun.net/v3/'.$domain.'/messages');
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $MailData);
	    $result = curl_exec($ch);
	    //print_r($result);exit;
	    curl_close($ch);
	}


	function send_notification($title,$message,$fcm_token,$type)
	{	
	
		$serverKey = "AAAAuzJtrjE:APA91bH5i6Tl0zgVMg1dI0PR0ZO0JmWCrFpt1nBqLdZxPIMZOyepW4ivPv2kB9FSpbhxcllzszp67QU5OahtZp9OGjNCchPfS7Soxb5UXmTEFlyyWTTdAdH-FhIjl548hk0Ya9s8W_R3";


		$fields = array(
			
			"registration_ids" => $fcm_token, 
			
			"notification" => array(
				"body" => $message,
				"title" => $title,
				"content_available" => true,
				'type' => $type,
				"priority" => "high",
				'vibrate' => true,
				'badge' => 0,
				'sound' => "default",
			),
		
			"data" => array(
				"body" => $message,
				"title" => $title,
				"content_available" => true,
				'type' => $type,
				"priority" => "high"
			)
		);

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Authorization: key='. $serverKey;
		$ch = curl_init();
		curl_setopt( $ch,CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send' );
		curl_setopt( $ch,CURLOPT_POST, true );
		curl_setopt( $ch,CURLOPT_HTTPHEADER, $headers );
		curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );
		curl_setopt( $ch,CURLOPT_POSTFIELDS, json_encode( $fields ) );
		$response = curl_exec($ch);
		curl_close($ch);
	}


	function time_elapsed_string($datetime, $full = false) 
	{
	    $now = new DateTime;
	    $ago = new DateTime($datetime);
	    $diff = $now->diff($ago);

	    $diff->w = floor($diff->d / 7); 
	    $diff->d -= $diff->w * 7;

	    $string = array(
	        'y' => 'year',
	        'm' => 'month',
	        'w' => 'week',
	        'd' => 'day',
	        'h' => 'hour',
	        'i' => 'min',
	        's' => 'sec',
	    ); 
	    foreach ($string as $k => &$v) { 
	        if ($diff->$k) {
	            $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? '' : '');
	        } else {
	            unset($string[$k]);
	        }
	    }

	    if (!$full) $string = array_slice($string, 0, 1);
	    return $string ? implode(', ', $string) . '' : 'just now';
	}



	function user_register()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('first_name', 'first_name', 'required');
		    $this->form_validation->set_rules('surname', 'surname', 'required');
		    $this->form_validation->set_rules('email', 'email', 'required');
		    $this->form_validation->set_rules('phone', 'phone', 'required');

		    $this->form_validation->set_rules('device_id', 'device_id', 'required');
		    $this->form_validation->set_rules('device_type', 'device_type', 'required');
		    $this->form_validation->set_rules('fcm_token', 'fcm_token', 'required');

		    if(!empty($_POST['social_id']))
		    {
		    	$this->form_validation->set_rules('social_type', 'social_type', 'required');
		    }
		    else
		    {
		    	$this->form_validation->set_rules('password', 'password', 'required');
		    }	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$device_id = $_POST['device_id'];
		        $device_type = $_POST['device_type'];
		        $fcm_token = $_POST['fcm_token'];


				$social_id = $_POST['social_id'];
		        $social_type = $_POST['social_type'];
		        $social_profile_image = $_POST['social_profile_image'];


		        $email_check = $this->general_obj->get_where(array('email'=>$_POST['email'],'is_active'=>'1','is_delete'=>'0'),'elb_user');
              
				if(!empty($email_check))  
				{	
					$json =  array("status" => 0,"message"=>"Email Already Exists");
				}
				else
				{
					$phone_check = $this->general_obj->get_where(array('phone'=>$_POST['phone'],'is_active'=>'1','is_delete'=>'0'),'elb_user');	

					if(!empty($phone_check))
					{
						$json =  array("status" => 0,"message"=>"Phone Number Already Exists");
					}
					else
					{
						$data=[
							'user_type'=>'user',
							'first_name'=>$_POST['first_name'],
							'surname'=>$_POST['surname'],
							'email'=>$_POST['email'],
							'phone'=>$_POST['phone'],
							'password'=>md5($_POST['password']),
						];

						if(!empty($social_id))
						{
							$data['social_id']= $social_id;
							$data['login_type']= $social_type;

							if(!empty($social_profile_image))
			                {	
								$file_path = time().'.jpg';

								file_put_contents('uploads/user_image/'.$file_path, file_get_contents($social_profile_image));
			                    		
			                    $images = $file_path;
	                		}
	                		else
	                		{
	                			$images= NULL;
	                		}

	                		$data['profile_image']= $images;
						}	
						else 
						{
							$this->load->library('upload');

							if($_FILES['profile_image']['name']!='')
				            {
				                $configs['encrypt_name']    = TRUE;
				                $configs['upload_path']     = './uploads/user_image';
				                $configs['allowed_types']   = '*';
				                	
				                $this->upload->initialize($configs);
				                if(!$this->upload->do_upload('profile_image'))
				        		{ 
				            		$json = array("status" => 0,"message" => strip_tags($this->upload->display_errors()));
				        		}
				        		else
		            			{
		                			$profile_image = $this->upload->data('file_name');
		            			}	
			        		}
			        		else
			        		{
			        			$profile_image=NULL;
			        		}
							
							$data['profile_image']= $profile_image;
						}

						$this->general_obj->insert_data($data,'elb_user');
						$user_id = $this->db->insert_id();

						if($user_id > 0)
						{
							$usercheck = $this->general_obj->get_where(array('user_id' => $user_id,'is_active'=>'1','is_delete'=>'0'),'elb_user');
		        			array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});

		        			$user_type = $usercheck[0]['user_type'];

							$loginuser = $this->general_obj->get_where_single(array('device_id'=>$device_id),'elb_login');

							$now = date('Y-m-d H:i:s');

							if(!empty($loginuser))
							{
								$logindata = array(
									'user_id'=>$usercheck[0]['user_id'],
									'user_type'=>$user_type,
									'device_id'=>$device_id,
									'device_type'=>$device_type,
									'fcm_token'=>$fcm_token,
									'created_at'=>$now
								);

								$where = array("login_id" => $loginuser->login_id);
								$insert = $this->general_obj->update_data($logindata,$where,'elb_login');
								$loginid = $loginuser->login_id;
							}
							else
							{
								$logindata = array(
									'user_id'=>$usercheck[0]['user_id'],
									'user_type'=>$user_type,
									'device_id'=>$device_id,
									'device_type'=>$device_type,
									'fcm_token'=>$fcm_token
								);

								$insert =  $this->general_obj->insert_data($logindata,'elb_login');
								$loginid = $this->db->insert_id();
							}
							
							$login = $this->general_obj->get_where_single(array('login_id'=>$loginid),'elb_login');

							if($usercheck[0]['profile_image']!=null)
							{
								$profile_image = base_url('uploads/user_image/').$usercheck[0]['profile_image'];
							}
							else
							{
								$profile_image = base_url('uploads/user.png');
							}

							if($usercheck[0]['document_front_image']!=null)
							{
								$document_front_image = base_url('uploads/document_file/').$usercheck[0]['document_front_image'];
							}
							else
							{
								$document_front_image = '';
							}

							if($usercheck[0]['document_back_image']!=null)
							{
								$document_back_image = base_url('uploads/document_file/').$usercheck[0]['document_back_image'];
							}
							else
							{
								$document_back_image = '';
							}

						
							$logdata = array(
					    		'login_id'=>$login->login_id,
					    		'device_id'=>$login->device_id,
					    		'device_type'=>$login->device_type,
					    		'fcm_token'=>$login->fcm_token,
					    		'user_id'=>$usercheck[0]['user_id'],
					    		'login_type'=>$usercheck[0]['login_type'],
								'social_id'=>$usercheck[0]['social_id'],
					    		'user_type'=>$usercheck[0]['user_type'],
					    		'first_name'=>$usercheck[0]['first_name'],
					    		'surname'=>$usercheck[0]['surname'],
				    			'email'=>$usercheck[0]['email'],
				    			'phone'=>$usercheck[0]['phone'],
				    			'profile_image'=>$profile_image,
				    			'birth_date'=>$usercheck[0]['birth_date'],
				    			'age'=>$usercheck[0]['age'], 
				    			'upload_document'=>$usercheck[0]['upload_document'],
				    			'document_front_image'=>$document_front_image,
				    			'document_back_image'=>$document_back_image,	
				    			'email_verify'=>$usercheck[0]['email_verify'],
				    			'phone_verify'=>$usercheck[0]['phone_verify'],
				    			'latitude'=>$usercheck[0]['latitude'],
				    			'longitude'=>$usercheck[0]['longitude'],
				    			'is_active'=>$usercheck[0]['is_active'],
				    			'is_delete'=>$usercheck[0]['is_delete'],
				    			'created_at'=>$usercheck[0]['created_at']
				    		);	

				    		$data2_obj = (object)$logdata;

							$json = array("status" => 1,"message" => "User Register Successfully And Send You Mail for Email Verify","response"=>$data2_obj);
						}
						else
						{
							$json =  array("status" => 0,"message"=>"User Not Register , Somthing Wrong , Please Try Again.");
						}
					}
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function login()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('email', 'email', 'required');	
			$this->form_validation->set_rules('password', 'password', 'required');
				
			$this->form_validation->set_rules('device_id', 'device_id', 'required');
			$this->form_validation->set_rules('device_type', 'device_type', 'required');
			$this->form_validation->set_rules('fcm_token', 'fcm_token', 'required');
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $email = $_POST['email'];
		        $password = md5($_POST['password']);

		        $device_id = $_POST['device_id'];
		        $device_type = $_POST['device_type'];
		        $fcm_token = $_POST['fcm_token'];

		        $latitude = $_POST['latitude'];
		        $longitude = $_POST['longitude'];
		    	
		        $usercheck = $this->general_obj->get_where(array('email' => $email,'password'=>$password,'is_active'=>'1','is_delete'=>'0'),'elb_user');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});
              
				if(!empty($usercheck))  
				{	
					$locationupdate = array(
						'latitude'=>!empty($latitude) ? $latitude : $usercheck[0]['latitude'],
						'longitude'=>!empty($longitude) ? $longitude : $usercheck[0]['longitude'],
					);

					$this->general_obj->update_data($locationupdate,array("user_id" => $usercheck[0]['user_id']),'elb_user');


					$user_type = $usercheck[0]['user_type'];

					$email_verify = $usercheck[0]['email_verify'];

					if($email_verify=='0')
					{
						$json =  array("status" => 0,"message"=>"Your Account Is Not Verify","email_verify"=>'0');
					}
					else
					{
						$loginuser = $this->general_obj->get_where_single(array('device_id'=>$device_id),'elb_login');

						$now = date('Y-m-d H:i:s');

						if(!empty($loginuser))
						{
							$logindata = array(
								'user_id'=>$usercheck[0]['user_id'],
								'user_type'=>$user_type,
								'device_id'=>$device_id,
								'device_type'=>$device_type,
								'fcm_token'=>$fcm_token,
								'created_at'=>$now
							);

							$where = array("login_id" => $loginuser->login_id);
							$insert = $this->general_obj->update_data($logindata,$where,'elb_login');
							$loginid = $loginuser->login_id;
						}
						else
						{
							$logindata = array(
								'user_id'=>$usercheck[0]['user_id'],
								'user_type'=>$user_type,
								'device_id'=>$device_id,
								'device_type'=>$device_type,
								'fcm_token'=>$fcm_token
							);

							$insert =  $this->general_obj->insert_data($logindata,'elb_login');
							$loginid = $this->db->insert_id();
						}
				
						if($insert > 0 )
						{
							$login = $this->general_obj->get_where_single(array('login_id'=>$loginid),'elb_login');

							if($usercheck[0]['profile_image']!=null)
							{
								$profile_image = base_url('uploads/user_image/').$usercheck[0]['profile_image'];
							}
							else
							{
								$profile_image = base_url('uploads/user.png');
							}

							if($usercheck[0]['document_front_image']!=null)
							{
								$document_front_image = base_url('uploads/document_file/').$usercheck[0]['document_front_image'];
							}
							else
							{
								$document_front_image = '';
							}

							if($usercheck[0]['document_back_image']!=null)
							{
								$document_back_image = base_url('uploads/document_file/').$usercheck[0]['document_back_image'];
							}
							else
							{
								$document_back_image = '';
							}

							$logdata = array(
					    		'login_id'=>$login->login_id,
					    		'device_id'=>$login->device_id,
					    		'device_type'=>$login->device_type,
					    		'fcm_token'=>$login->fcm_token,
					    		'user_id'=>$usercheck[0]['user_id'],
					    		'login_type'=>$usercheck[0]['login_type'],
								'social_id'=>$usercheck[0]['social_id'],
					    		'user_type'=>$usercheck[0]['user_type'],
					    		'first_name'=>$usercheck[0]['first_name'],
					    		'surname'=>$usercheck[0]['surname'],
				    			'email'=>$usercheck[0]['email'],
				    			'phone'=>$usercheck[0]['phone'],
				    			'profile_image'=>$profile_image,
				    			'birth_date'=>$usercheck[0]['birth_date'],
				    			'age'=>$usercheck[0]['age'], 
				    			'upload_document'=>$usercheck[0]['upload_document'],
				    			'document_front_image'=>$document_front_image,
				    			'document_back_image'=>$document_back_image,	
				    			'email_verify'=>$usercheck[0]['email_verify'],
				    			'phone_verify'=>$usercheck[0]['phone_verify'],
				    			'latitude'=>$usercheck[0]['latitude'],
				    			'longitude'=>$usercheck[0]['longitude'],
				    			'is_active'=>$usercheck[0]['is_active'],
				    			'is_delete'=>$usercheck[0]['is_delete'],
				    			'created_at'=>$usercheck[0]['created_at']
				    		);	

				    		$data2_obj = (object)$logdata;
					
							$json = array("status" => 1,"message" => "Login Successfully","response" => $data2_obj);	
						}
						else
						{
							$json =  array("status" => 0,"message"=>"Token Detail Not Add");
						}
					}
				}
				else
				{   
					$json =  array("status" => 0,"message"=>"Invalid Email And Password");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function logout()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('login_id', 'login_id', 'required');	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $login_id = $_POST['login_id'];
		    	
		        $usercheck = $this->general_obj->get_where_single(array('login_id'=>$login_id),'elb_login');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});
              
				if(!empty($usercheck))  
				{	
					$this->db->where('login_id',$login_id);
					$this->db->delete('elb_login');

					$userdata= $this->general_obj->get_where_single(array('login_id'=>$login_id),'elb_login');

					if(empty($userdata))
					{
						$json = array("status" => 1,"message" => "Logout Successfully");	
					}
					else
					{
						$json =  array("status" => 0,"message"=>"Not Logout , Somthing Wrong , Please Try Again.");
					}
				}
				else
				{   
					$json =  array("status" => 0,"message"=>"Data Not Found");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function user_detail_by_id()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $user_id = $_POST['user_id'];
		        
		        $usercheck = $this->general_obj->get_where(array('user_id' => $user_id,'is_active'=>'1','is_delete'=>'0'),'elb_user');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});


				if(!empty($usercheck))  
				{	
					if($usercheck[0]['profile_image']!=null)
					{
						$profile_image = base_url('uploads/user_image/').$usercheck[0]['profile_image'];
					}
					else
					{
						$profile_image = base_url('uploads/user.png');
					}

					if($usercheck[0]['document_front_image']!=null)
					{
						$document_front_image = base_url('uploads/document_file/').$usercheck[0]['document_front_image'];
					}
					else
					{
						$document_front_image = '';
					}

					if($usercheck[0]['document_back_image']!=null)
					{
						$document_back_image = base_url('uploads/document_file/').$usercheck[0]['document_back_image'];
					}
					else
					{
						$document_back_image = '';
					}	
		        	
					$data = array(
			    		'user_id'=>$usercheck[0]['user_id'],
			    		'login_type'=>$usercheck[0]['login_type'],
						'social_id'=>$usercheck[0]['social_id'],
			    		'user_type'=>$usercheck[0]['user_type'],
			    		'first_name'=>$usercheck[0]['first_name'],
			    		'surname'=>$usercheck[0]['surname'],
		    			'email'=>$usercheck[0]['email'],
		    			'phone'=>$usercheck[0]['phone'],
		    			'profile_image'=>$profile_image,
		    			'birth_date'=>$usercheck[0]['birth_date'],
		    			'age'=>$usercheck[0]['age'], 
		    			'upload_document'=>$usercheck[0]['upload_document'],
		    			'document_front_image'=>$document_front_image,
		    			'document_back_image'=>$document_back_image,	
		    			'email_verify'=>$usercheck[0]['email_verify'],
		    			'phone_verify'=>$usercheck[0]['phone_verify'],
		    			'latitude'=>$usercheck[0]['latitude'],
		    			'longitude'=>$usercheck[0]['longitude'],
		    			'is_active'=>$usercheck[0]['is_active'],
		    			'is_delete'=>$usercheck[0]['is_delete'],
		    			'created_at'=>$usercheck[0]['created_at']
				    );	
	
					$data2_obj = (object)$data;
						
					$json = array("status" => 1,"message" => "User Detail","response" => $data2_obj);	
				}
				else
				{	
					$data2_obj = (object)[];
					$json =  array("status" => 0,"message"=>"User Detail","response" => $data2_obj);
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function upload_document_by_user_id()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');

		    if (empty($_FILES['document_front_image']['name']))
			{
    			$this->form_validation->set_rules('document_front_image', 'document_front_image', 'required');
			}

			if (empty($_FILES['document_back_image']['name']))
			{
    			$this->form_validation->set_rules('document_back_image', 'document_back_image', 'required');
			}

			$this->form_validation->set_rules('birth_date', 'birth_date', 'required');	
		    

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	

				$user_id=$_POST['user_id'];
		    	
		    	$userinfo = $this->general_obj->get_where_single(array('user_id'=>$user_id),'elb_user');
		        $image1 = $userinfo->document_front_image;
		        $image2 = $userinfo->document_back_image;
				
				$this->load->library('upload');

				
        		if($_FILES['document_front_image']['name']!='')
            	{
                	$config['encrypt_name']    = TRUE;
                	$config['upload_path']     = './uploads/document_file';
                	$config['allowed_types']   = '*';
                	
                	$this->load->library('upload', $config ,'coverupload');
	                if(!$this->coverupload->do_upload('document_front_image'))
	        		{ 
	            		$json = array("status" => 0,"message" => strip_tags($this->coverupload->display_errors()));
	            		exit;
	        		}
	        		else
        			{
            			$document_front_image = $this->coverupload->data('file_name');
            			unlink("./uploads/document_file/$image1");
        			}	
    			}
    			else if($image1!=null)
            	{
            		$document_front_image = $image1;
            	}
        		else
        		{
        			$document_front_image=NULL;
        		}


        		if($_FILES['document_back_image']['name']!='')
            	{
                	$configs['encrypt_name']    = TRUE;
                	$configs['upload_path']     = './uploads/document_file';
                	$configs['allowed_types']   = '*';
                	
                	$this->load->library('upload', $configs ,'catupload');
	                if(!$this->catupload->do_upload('document_back_image'))
	        		{ 
	            		$json = array("status" => 0,"message" => strip_tags($this->catupload->display_errors()));
	            		exit;
	        		}
	        		else
        			{
            			$document_back_image = $this->catupload->data('file_name');
            			unlink("./uploads/document_file/$image2");
        			}	
    			}
    			else if($image2!=null)
            	{
            		$document_back_image = $image2;
            	}
        		else
        		{
        			$document_back_image=NULL;
        		}
				

        		$birthday = $_POST['birth_date'];
        		$birth = date('Y-m-d',strtotime($birthday));
        		$dateOfBirth = $birth;
				$today = date("Y-m-d");
				$diff = date_diff(date_create($dateOfBirth), date_create($today));
        		$age = $diff->format('%y');


        		$data=array(
        			'birth_date'=>$dateOfBirth,
        			'age'=>$age,
        			'upload_document'=>'1',
            		'document_front_image'=>$document_front_image,
            		'document_back_image'=>$document_back_image,
            	); 


        		$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_user');

				if($upd > 0)
				{	
					$json = array("status" => 1,"message" => "Dcoument Uploaded Successfully");
				}
				else
				{
					$json = array("status" => 0,"message" => "Dcoument Not Uploaded");
				}			
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }
    

    function change_profile_image()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	

				$user_id=$_POST['user_id'];
		    	
		    	$userinfo = $this->general_obj->get_where_single(array('user_id'=>$user_id),'elb_user');
		        $image1 = $userinfo->profile_image;
				
				$this->load->library('upload');

				if($_FILES['profile_image']['name']!='')
	            {
	                $configs['encrypt_name']    = TRUE;
	                $configs['upload_path']     = './uploads/user_image';
	                $configs['allowed_types']   = '*';
	                	
	                $this->upload->initialize($configs);
	                if(!$this->upload->do_upload('profile_image'))
	        		{ 
	            		$json = array("status" => 0,"message" => strip_tags($this->upload->display_errors()));
	        		}
	        		else
        			{
            			$profile_image = $this->upload->data('file_name');
            			unlink("./uploads/user_image/$image1");
        			}	
        		}
        		else if($image1!=null)
            	{
            		$profile_image = $image1;
            	}
        		else
        		{
        			$profile_image=NULL;
        		}

        		$data=array(
            		'profile_image'=>$profile_image,
            	); 

        		$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_user');

				if($upd > 0)
				{	
					if($profile_image!=null)
					{
						$images = base_url('uploads/user_image/').$profile_image;
					}
					else
					{
						$images = base_url('uploads/user.png');
					}

					$json = array("status" => 1,"message" => "Profile Image Changed Successfully","response"=>$images);
				}
				else
				{
					$json = array("status" => 0,"message" => "Profile Image Not Changed");
				}			
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }

    
    function user_edit_profile()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');

		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $user_id = $_POST['user_id'];
		       
		        $userinfo = $this->general_obj->get_where_single(array('user_id'=>$user_id),'elb_user');

		       	 	
		       	$email_check = $this->general_obj->get_where(array('user_id!='=>$user_id,'is_active'=>'1','is_delete'=>'0','email'=>$_POST['email'],'email!='=>NULL,'email!='=>''),'elb_user');

				if(!empty($email_check))
				{
					$json =  array("status" => 0,"message"=>"Email Already Exists");
				}
				else
				{	
					$phone_check = $this->general_obj->get_where(array('user_id!='=>$user_id,'is_active'=>'1','is_delete'=>'0','phone'=>$_POST['phone'],'phone!='=>NULL,'phone!='=>''),'elb_user');	
			       	
	       			if(!empty($phone_check))
					{	
						$json = array("status" => 0,"message" => "Phone Number Already Exists");
					}
	       			else
	       			{
	       				if(!empty($_POST['birth_date']))
	       				{
	       					$birth = date('Y-m-d',strtotime($_POST['birth_date']));
	       					$dateOfBirth = $birth;
	       					$today = date("Y-m-d");

	       					$diff = date_diff(date_create($dateOfBirth), date_create($today));
	       					$age = $diff->format('%y');
	       				}
	       				else
	       				{
	       					$dateOfBirth = $userinfo->birth_date;
	       					$age = $userinfo->age;
	       				}

						$data=array(
				       		'first_name'=>!empty($_POST['first_name']) ? $_POST['first_name'] : $userinfo->first_name,
				       		'surname'=>!empty($_POST['surname']) ? $_POST['surname'] : $userinfo->surname,
				       		'email'=>!empty($_POST['email']) ? $_POST['email'] : $userinfo->email,
				       		'phone'=>!empty($_POST['phone']) ? $_POST['phone'] : $userinfo->phone,
				       		'birth_date'=>$dateOfBirth,
				       		'age'=>$age,
       					);		 	

				       	$upd = $this->general_obj->update_data($data,array("user_id" => $user_id),"elb_user");

						if ($upd > 0) 
						{
							$json = array("status" => 1,"message" => "Profile Updated Successfully");
						}
						else
						{
							$json = array("status" => 0,"message" => "Profile Not Updated , Please Try Again");
						}		
					}
				}
			}	
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function change_password()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			$this->form_validation->set_rules('old_password', 'old_password', 'required');
			$this->form_validation->set_rules('new_password', 'new_password', 'required');
			$this->form_validation->set_rules('conf_password', 'conf_password', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$user_id = $_POST['user_id'];

				$result = $this->general_obj->get_where_single(array('user_id'=>$user_id),'elb_user');

				if(md5($_POST['old_password'])==$result->password)
				{
					if($_POST['new_password']==$_POST['conf_password'])
					{				
	    				$data=array(
	    					'password'=>md5($_POST['new_password']),	
	    				);

	    				$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_user');

						if($upd > 0)
						{
							$json = array("status" => 1,"message" => "Password Changed Successfully");
						}
						else
						{
							$json = array("status" => 0,"message" => "Password Not Changed");
						}		
					}
					else
					{
						$json = array("status" => 0,"message" => "New Password & Confirm Password Not Match.");
					}
				}
				else
				{
					$json = array("status" => 0,"message" => "Old Password Is not Correct.");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    } 

    
    function social_login()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('social_id', 'social_id', 'required');	
			$this->form_validation->set_rules('social_type', 'social_type', 'required');
				
			$this->form_validation->set_rules('device_id', 'device_id', 'required');
			$this->form_validation->set_rules('device_type', 'device_type', 'required');
			$this->form_validation->set_rules('fcm_token', 'fcm_token', 'required');
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $social_id = $_POST['social_id'];
		        $social_type = $_POST['social_type'];

		        $device_id = $_POST['device_id'];
		        $device_type = $_POST['device_type'];
		        $fcm_token = $_POST['fcm_token'];

		        $social_profile_image = $_POST['social_profile_image'];
		        
		        $first_name = $_POST['first_name'];
		        $surname = $_POST['surname'];
		        $email = $_POST['email'];
		        $phone = $_POST['phone'];   

		    	
		        $usercheck = $this->general_obj->get_where(array('login_type' => $social_type,'social_id'=>$social_id,'is_active'=>'1','is_delete'=>'0'),'elb_user');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});
              
				if(!empty($usercheck))  
				{	
					$user_type = $usercheck[0]['user_type'];
					$image1 =  $usercheck[0]['profile_image'];

					
					$email_verify = $usercheck[0]['email_verify'];

					if($email_verify=='0')
					{	

						$json =  array("status" => 0,"message"=>"Your Account Is Not Verify","email_verify"=>"0");
					}
					else
					{		
						$emailcheck = $this->general_obj->get_where(array('user_id!='=>$usercheck[0]['user_id'],'is_active'=>'1','is_delete'=>'0','email'=>$email,'email!='=>NULL,'email!='=>''),'elb_user');

						if(!empty($emailcheck))
						{
							$json =  array("status" => 0,"message"=>"Email Already Exists");
						}
						else
						{
							$phonecheck = $this->general_obj->get_where(array('user_id!='=>$usercheck[0]['user_id'],'is_active'=>'1','is_delete'=>'0','phone'=>$phone,'phone!='=>NULL,'phone!='=>''),'elb_user');

							if(!empty($phonecheck))
							{
								$json =  array("status" => 0,"message"=>"Phone Number Already Exists");
							}
							else
							{
								$updatedata = [
        							'first_name'=>!empty($first_name) ? $first_name : $usercheck[0]['first_name'],
        							'surname'=>!empty($surname) ? $surname : $usercheck[0]['surname'],
                					'email'=>!empty($email) ? $email : $usercheck[0]['email'],
             						'phone'=>!empty($phone) ? $phone : $usercheck[0]['phone']
                				];

                				if(!empty($social_profile_image))
		                		{	
		                			$file_path = time().'.jpg';

									file_put_contents('uploads/user_image/'.$file_path, file_get_contents($social_profile_image));
		                    		
		                    		unlink("./uploads/user_image/$image1");
		                			$images = $file_path;
		                		}
		                		else
		                		{
		                			$images= $image1;
		                		}

		                		$updatedata['profile_image']= !empty($images) ? $images : NULL;

		                		$upd = $this->general_obj->update_data($updatedata,array('user_id'=>$usercheck[0]['user_id']),'elb_user');

		                		if($upd > 0)
		                		{ 
		                			$loginuser = $this->general_obj->get_where_single(array('device_id'=>$device_id),'elb_login');

									$now = date('Y-m-d H:i:s');

									if(!empty($loginuser))
									{
										$logindata = array(
											'user_id'=>$usercheck[0]['user_id'],
											'user_type'=>$user_type,
											'device_id'=>$device_id,
											'device_type'=>$device_type,
											'fcm_token'=>$fcm_token,
											'created_at'=>$now
										);

										$where = array("login_id" => $loginuser->login_id);
										$insert = $this->general_obj->update_data($logindata,$where,'elb_login');
										$loginid = $loginuser->login_id;
									}
									else
									{
										$logindata = array(
											'user_id'=>$usercheck[0]['user_id'],
											'user_type'=>$user_type,
											'device_id'=>$device_id,
											'device_type'=>$device_type,
											'fcm_token'=>$fcm_token
										);

										$insert =  $this->general_obj->insert_data($logindata,'elb_login');
										$loginid = $this->db->insert_id();
									}

									if($insert > 0 )
									{	
										$login = $this->general_obj->get_where_single(array('login_id'=>$loginid),'elb_login');

										$userinfo = $this->general_obj->get_where(array('user_id'=>$usercheck[0]['user_id']),'elb_user');
											array_walk_recursive($userinfo,function(&$userinfo){$userinfo=strval($userinfo);});

										if($userinfo[0]['profile_image']!=null)
										{
											$profile_image = base_url('uploads/user_image/').$userinfo[0]['profile_image'];
										}
										else
										{
											$profile_image = base_url('uploads/user.png');
										}

										if($userinfo[0]['document_front_image']!=null)
										{
											$document_front_image = base_url('uploads/document_file/').$userinfo[0]['document_front_image'];
										}
										else
										{
											$document_front_image = '';
										}

										if($userinfo[0]['document_back_image']!=null)
										{
											$document_back_image = base_url('uploads/document_file/').$userinfo[0]['document_back_image'];
										}
										else
										{
											$document_back_image = '';
										}

					
										$data = array(
								    		'login_id'=>$login->login_id,
								    		'device_id'=>$login->device_id,
								    		'device_type'=>$login->device_type,
								    		'fcm_token'=>$login->fcm_token,
								    		'user_id'=>$userinfo[0]['user_id'],
								    		'login_type'=>$userinfo[0]['login_type'],
											'social_id'=>$userinfo[0]['social_id'],
								    		'user_type'=>$userinfo[0]['user_type'],
								    		'first_name'=>$userinfo[0]['first_name'],
								    		'surname'=>$userinfo[0]['surname'],
							    			'email'=>$userinfo[0]['email'],
							    			'phone'=>$userinfo[0]['phone'],
							    			'profile_image'=>$profile_image,
							    			'birth_date'=>$userinfo[0]['birth_date'],
							    			'age'=>$userinfo[0]['age'], 
							    			'upload_document'=>$userinfo[0]['upload_document'],
							    			'document_front_image'=>$document_front_image,
							    			'document_back_image'=>$document_back_image,	
							    			'email_verify'=>$userinfo[0]['email_verify'],
							    			'phone_verify'=>$userinfo[0]['phone_verify'],
							    			'latitude'=>$userinfo[0]['latitude'],
							    			'longitude'=>$userinfo[0]['longitude'],
							    			'is_active'=>$userinfo[0]['is_active'],
							    			'is_delete'=>$userinfo[0]['is_delete'],
							    			'created_at'=>$userinfo[0]['created_at']
							    		);
			
							    		$data2_obj = (object)$data;
								
										$json = array("status" => 1,"message" => "Social Login Successfully","response" => $data2_obj);	
									}
									else
									{
										$json =  array("status" => 0,"message"=>"Token Detail Not Add");
									}
								}
								else
								{
									$json =  array("status" => 0,"message"=>"User Data Not Updated");
								}
							}
						}
					}
				}
				else
				{   
					$json =  array("status" => 0,"message"=>"Not Found This Social Login");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    } 


}