<?php
class Beaches extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
			$data['featuresbeach'] = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features'=>'y'),'features_order','ASC','elb_beach');
			$data['featuresbeach_web'] = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features_web'=>'y'),'features_web_order','ASC','elb_beach');
 			$this->load->view('admin/beach/list_beach',$data);
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_beach_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$beach = $this->general_obj->get_where(array('is_delete'=>'0'),'elb_beach');

			$data = array();
        	$i=1;
        	foreach($beach as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$beach_id = $this->encrypt->encode($row['beach_id']);

        		if($row['beach_image']!=null)
				{
					$beach_image = base_url('uploads/beach_image/').$row['beach_image'];
				}
				else
				{
					$beach_image = '';
				}


				if($row['features']=='n')
				{
 					$feature = '<a href="javascript:void(0);" class="btn btn-sm btn-info changestatus" id="'.$beach_id.'">Set App Explore</a>';
				}
				else
				{
					$feature = "<span class='badge outline-badge-success'>Set App Explore List</span>";
				}


				if($row['features_web']=='n')
				{
 					$feature_web = '<a href="javascript:void(0);" class="btn btn-sm btn-warning changestatus_web" id="'.$beach_id.'">Set Web Explore</a>';
				}
				else
				{
					$feature_web = "<span class='badge outline-badge-success'>Set Web Explore List</span>";
				}


        		$sub_array = array();
 				$sub_array[] = $i;
 				/*$sub_array[] = '<span><img style="width:50px;height:50px;;" src="'.$beach_image.'" class="rounded-circle profile-img" alt="avatar"></span>';*/
 				$sub_array[] = $row['beach_code'];
 				$sub_array[] = $row['beach_name'];
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="'.base_url('admin/Beaches/edit_beach/').$beach_id.'"><i class="far fa-edit"></i></a>
 				&nbsp;&nbsp;
 				<a href="javascript:void(0);"  class="delete" id="'.$beach_id.'"><i class="far fa-trash-alt"></i></a>
 				<br><br>
 				'.$feature.'
 				<br><br>
				'.$feature_web.'
				<br><br>
				<a href="'.base_url('admin/Beaches/webcam/').$beach_id.'" class="btn btn-sm btn-danger">Webcam List</a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function delete_beach()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$beach_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'is_delete'=>'1',
 				'is_active' => '0'
 			);

	 		$this->db->where('beach_id',$beach_id);
	 		$this->db->update('elb_beach',$data);

	 		echo 'Beach Deleted Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_beach()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['beachtype'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_beach_type');
	 		$this->load->view('admin/beach/add_beach',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_save_beaches()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$postions = explode('-',$this->input->post('position'));

			$position_in = $postions[0];
			$position_it = $postions[1];

			$data=[
				"beach_code" => $this->input->post('beach_code'),
				"beach_name" => $this->input->post('beach_name'),
				"area" => $this->input->post('area'),
				"position" => $position_it,
				"position_en" => $position_in,
				"latitude" => $this->input->post('latitude'),
				"longitude" => $this->input->post('longitude'),
				"beach_type" => $this->input->post('beach_type'),
				"is_active" =>$status,
			];


			$this->load->library('upload');

			if($_FILES['beach_image']['name']!='')
            {
                $configs['encrypt_name']    = TRUE;
                $configs['upload_path']     = './uploads/beach_image';
                $configs['allowed_types']   = '*';
                	
                $this->upload->initialize($configs);
                if(!$this->upload->do_upload('beach_image'))
        		{ 	
        			$json['status']='error';
					$json['message']= strip_tags($this->upload->display_errors()) ;
					echo json_encode($json);
        		}
        		else
    			{
        			$beachimage = $this->upload->data('file_name');
    			}	
    		}
    		else
    		{
    			$beachimage=NULL;
    		}
			
			$data['beach_image']= $beachimage;


			$this->general_obj->insert_data($data,'elb_beach');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}


	function edit_beach($beach_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['beach_id'] = $beach_id;
	 		
	 		$beachid = $this->encrypt->decode($beach_id);
	 		$data['beachs'] = $this->general_obj->get_where_single(array('beach_id'=>$beachid),'elb_beach');

	 		$data['beachtype'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_beach_type');
	 		$this->load->view('admin/beach/edit_beach',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function edit_save_beaches()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{	
			$beach_id = $this->encrypt->decode($_POST['dataid']);

			$image1 = $this->input->post('image1');
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$postions = explode('-',$this->input->post('position'));

			$position_in = $postions[0];
			$position_it = $postions[1];

			$data=[
				"beach_code" => $this->input->post('beach_code'),
				"beach_name" => $this->input->post('beach_name'),
				"area" => $this->input->post('area'),
				"position" => $position_it,
				"position_en" => $position_in,
				"latitude" => $this->input->post('latitude'),
				"longitude" => $this->input->post('longitude'),
				"beach_type" => $this->input->post('beach_type'),
				"is_active" =>$status,
			];


			$this->load->library('upload');

			if($_FILES['beach_image']['name']!='')
            {
                $configs['encrypt_name']    = TRUE;
                $configs['upload_path']     = './uploads/beach_image';
                $configs['allowed_types']   = '*';
                	
                $this->upload->initialize($configs);
                if(!$this->upload->do_upload('beach_image'))
        		{ 	
        			$json['status']='error';
					$json['message']= strip_tags($this->upload->display_errors()) ;
					echo json_encode($json);
        		}
        		else
    			{
        			$beachimage = $this->upload->data('file_name');
        			unlink("./uploads/beach_image/$image1");
    			}	
    		}
    		else if($image1!=null)
    		{
    			$beachimage=$image1;
    		}
    		else
    		{
    			$beachimage=NULL;
    		}
			
			$data['beach_image']= $beachimage;


			$where = array("beach_id" => $beach_id);
			$this->general_obj->update_data($data,$where,'elb_beach');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}



	///       beach type  module ////////////////

	function beach_type()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/beach/list_beach_type');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function fetch_beachtype_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$beachtype = $this->general_obj->get_where(array('is_delete'=>'0'),'elb_beach_type');

			$data = array();
        	$i=1;
        	foreach($beachtype as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$type_id = $this->encrypt->encode($row['type_id']);



        		$sub_array = array();
 				$sub_array[] = $i;
 				$sub_array[] = $row['type_name'];
 				$sub_array[] = $row['type_name_it'];
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="'.base_url('admin/Beaches/edit_beachtype/').$type_id.'"><i class="far fa-edit"></i></a>
 				&nbsp;&nbsp;
 				<a href="javascript:void(0);"  class="delete" id="'.$type_id.'"><i class="far fa-trash-alt"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function delete_beachtype()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$type_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'is_delete'=>'1',
 				'is_active' => '0'
 			);

	 		$this->db->where('type_id',$type_id);
	 		$this->db->update('elb_beach_type',$data);

	 		echo 'Beach Type Deleted Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_beachtype()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/beach/add_beach_type');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_save_beachetype()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$data=[
				"type_name" => $this->input->post('type_name'),
				"type_name_it" => $this->input->post('type_name_it'),
				"is_active" =>$status,
			];


			$this->general_obj->insert_data($data,'elb_beach_type');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}


	function edit_beachtype($type_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['type_id'] = $type_id;
	 		
	 		$typeid = $this->encrypt->decode($type_id);
	 		$data['type'] = $this->general_obj->get_where_single(array('type_id'=>$typeid),'elb_beach_type');

	 		$this->load->view('admin/beach/edit_beach_type',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function edit_save_beachetype()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{	
			$type_id = $this->encrypt->decode($_POST['dataid']);
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}


			$data=[
				"type_name" => $this->input->post('type_name'),
				"type_name_it" => $this->input->post('type_name_it'),
				"is_active" =>$status,
			];

			$where = array("type_id" => $type_id);
			$this->general_obj->update_data($data,$where,'elb_beach_type');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}



	////////////////////////   Explore beach ///////////////////////////////


	function explore_beach()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/beach/list_explore_beach');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function fetch_explorebeach_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$beach = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features'=>'y'),'features_order','ASC','elb_beach');

			$data = array();
        	$i=1;
        	foreach($beach as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$beach_id = $this->encrypt->encode($row['beach_id']);

        		if($row['beach_image']!=null)
				{
					$beach_image = base_url('uploads/beach_image/').$row['beach_image'];
				}
				else
				{
					$beach_image = '';
				}

        		$sub_array = array();
 				$sub_array[] = $i;
 				/*$sub_array[] = '<span><img style="width:50px;height:50px;;" src="'.$beach_image.'" class="rounded-circle profile-img" alt="avatar"></span>';*/
 				$sub_array[] = $row['beach_code'];
 				$sub_array[] = $row['beach_name'];
 				$sub_array[] = $row['features_order'];
 				$sub_array[] = ucwords($row['features_type']);
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="javascript:void(0);"  class="delete" id="'.$beach_id.'"><i class="far fa-trash-alt"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function delete_explorebeach()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$beach_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'features'=>'n',
 				'features_order' => NULL,
 				'features_type' => 'today'
 			);

	 		$this->db->where('beach_id',$beach_id);
	 		$this->db->update('elb_beach',$data);

	 		echo 'Beach Is Explore List Remove Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function update_explore_beach()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$beach_id = $this->encrypt->decode($_POST['beach_id']);

 			$data=array(
 				'features'=>'y',
 				'features_order' => $_POST['features_order'],
 				'features_type' => $_POST['features_type']
 			);

	 		$this->db->where('beach_id',$beach_id);
	 		$upd = $this->db->update('elb_beach',$data);

	 		if($upd > 0)
	 		{
	 			$json['status']='success';
				echo json_encode($json);
 			}
 			else
 			{
 				$json['status']='error';
 				$json['message']='Beach Not Set ,Please Try Again';
				echo json_encode($json);
 			}
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	////////////////////////   web Explore beach ///////////////////////////////


	function web_explore_beach()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/beach/list_explore_beach_web');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function fetch_web_explorebeach_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$beach = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features_web'=>'y'),'features_web_order','ASC','elb_beach');

			$data = array();
        	$i=1;
        	foreach($beach as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$beach_id = $this->encrypt->encode($row['beach_id']);

        		if($row['beach_image']!=null)
				{
					$beach_image = base_url('uploads/beach_image/').$row['beach_image'];
				}
				else
				{
					$beach_image = '';
				}

        		$sub_array = array();
 				$sub_array[] = $i;
 				/*$sub_array[] = '<span><img style="width:50px;height:50px;;" src="'.$beach_image.'" class="rounded-circle profile-img" alt="avatar"></span>';*/
 				$sub_array[] = $row['beach_code'];
 				$sub_array[] = $row['beach_name'];
 				$sub_array[] = $row['features_web_order'];
				$sub_array[] = ucwords($row['features_web_type']);
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="javascript:void(0);"  class="delete" id="'.$beach_id.'"><i class="far fa-trash-alt"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function delete_web_explorebeach()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$beach_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'features_web'=>'n',
 				'features_web_order' => NULL,
				'features_web_type' => 'today'
 			);

	 		$this->db->where('beach_id',$beach_id);
	 		$this->db->update('elb_beach',$data);

	 		echo 'Beach Is Explore List Remove Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function update_web_explore_beach()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$beach_id = $this->encrypt->decode($_POST['beach_id']);

 			$data=array(
 				'features_web'=>'y',
 				'features_web_order' => $_POST['features_web_order'],
				'features_web_type' => $_POST['features_web_type']
 			);

	 		$this->db->where('beach_id',$beach_id);
	 		$upd = $this->db->update('elb_beach',$data);

	 		if($upd > 0)
	 		{
	 			$json['status']='success';
				echo json_encode($json);
 			}
 			else
 			{
 				$json['status']='error';
 				$json['message']='Beach Not Set ,Please Try Again';
				echo json_encode($json);
 			}
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}



	///////////////////////////////////////////////////////////////////
	
	function webcam($beach_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['beach_id'] = $beach_id;
	 		
	 		$beachid = $this->encrypt->decode($beach_id);
	 		$data['beachs'] = $this->general_obj->get_where_single(array('beach_id'=>$beachid),'elb_beach');
	 		$this->load->view('admin/beach/webcam/list_webcam',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
	
	
	function fetch_webcam_data($beach_id)
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
			$beachid = $this->encrypt->decode($beach_id);
			
			$webcam = $this->general_obj->get_where(array('is_delete'=>'0','beach_id'=>$beachid),'elb_beach_webcam');

			$data = array();
        	$i=1;
        	foreach($webcam as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$webcam_id = $this->encrypt->encode($row['webcam_id']);


        		$sub_array = array();
 				$sub_array[] = $i;
 				$sub_array[] = $row['webcam_name'];
 				$sub_array[] = $row['webcam_link'];
				$sub_array[] = $row['latitude'];
				$sub_array[] = $row['longitude'];
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="'.base_url('admin/Beaches//edit_webcam/').$webcam_id.'"><i class="far fa-edit"></i></a>
 				&nbsp;&nbsp;
 				<a href="javascript:void(0);"  class="delete" id="'.$webcam_id.'"><i class="far fa-trash-alt"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}
	
	
	function delete_webcam()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$webcam_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'is_delete'=>'1',
 				'is_active' => '0'
 			);

	 		$this->db->where('webcam_id',$webcam_id);
	 		$this->db->update('elb_beach_webcam',$data);

	 		echo 'Beach webcam Deleted Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
	
	function add_webcam($beach_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$data['beach_id'] = $beach_id;
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/beach/webcam/add_webcam',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
	
	function add_save_webcam()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			$beach_id = $this->encrypt->decode($_POST['beach_id']);
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$data=[
				"beach_id" => $beach_id,
				"webcam_name" => $this->input->post('webcam_name'),
				"webcam_link" => $this->input->post('webcam_link'),
				"latitude" => $this->input->post('latitude'),
				"longitude" => $this->input->post('longitude'),
				"is_active" =>$status,
			];

			$this->general_obj->insert_data($data,'elb_beach_webcam');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}

	
	function edit_webcam($webcam_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$data['webcam_id'] = $webcam_id;
			$webcamid = $this->encrypt->decode($webcam_id);
			$data['webcam'] = $webs = $this->general_obj->get_where_single(array('webcam_id'=>$webcamid),'elb_beach_webcam');
			$data['beach_id'] = $this->encrypt->encode($webs->beach_id);
			
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/beach/webcam/edit_webcam',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
	
	function edit_save_webcam()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			$webcam_id = $this->encrypt->decode($_POST['webcam_id']);
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$data=[
				"webcam_name" => $this->input->post('webcam_name'),
				"webcam_link" => $this->input->post('webcam_link'),
				"latitude" => $this->input->post('latitude'),
				"longitude" => $this->input->post('longitude'),
				"is_active" =>$status,
			];

			$this->general_obj->update_data($data,array('webcam_id'=>$webcam_id),'elb_beach_webcam');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}



}


