<?php
class Booking extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
 			$this->load->view('admin/booking/list_booking');
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_book_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
			$year = $_POST['year'];
			
			$booking = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','YEAR(created_at)'=>$year),'booking_id','DESC','elb_booking');

			$data = array();
        	$i=1;
        	foreach($booking as $row)
        	{	
                $booking_id = $this->encrypt->encode($row['booking_id']);

        		if($row['status'] == "booked")
        		{
        			$status = "<span class='badge outline-badge-success'>Booked</span>"; 
        		}
        		else if($row['status'] == "arrived")
        		{
        			$status = "<span class='badge outline-badge-secondary'>Arrived</span>";
        		}
        		else if($row['status'] == "notshow")
        		{
        			$status = "<span class='badge outline-badge-warning'>Not Show</span>";
        		}
        		else if($row['status'] == "reject")
        		{
        			$status = "<span class='badge outline-badge-danger'>Reject</span>";
        		}
        		else if($row['status'] == "user_cancel")
        		{
        			$status = "<span class='badge outline-badge-danger'>User Cancel</span>";
        		}	
        		else
        		{
        			$status = "<span class='badge outline-badge-dark'>Pending</span>";
        		} 

        		

        		$userinfo = $this->general_obj->get_where_single(array('user_id'=>$row['user_id']),'elb_user');
        		$userdata =  '<b>'.$userinfo->first_name.' '.$userinfo->surname.'</b><br>
        					  '.$userinfo->email.'<br>'.$userinfo->phone ;


        		$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$row['resort_id']),'elb_resort');				  

        		$sub_array = array();
 				$sub_array[] = $i;
 				$sub_array[] = $row['booking_id'];
 				$sub_array[] = $userdata;
 				$sub_array[] = $resortinfo->resort_name;
 				
 				if(empty($row['to_date']))
 				{
 					$sub_array[] = date('d-M-Y',strtotime($row['from_date']));
 				}
 				else
 				{
 					$sub_array[] = '<b>From</b>:<br>'.date('d-M-Y',strtotime($row['from_date'])).' <br><b>To</b>:<br> '.date('d-M-Y',strtotime($row['to_date'])) ;
 				}


 				$sub_array[] = '&euro; '.$row['total_amount'];
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));


 				if($row['status']=='user_cancel' || $row['status']=='reject')
 				{
 					$sub_array[] = '
	 				<a href="'.base_url('admin/Booking/booking_detail/').$booking_id.'"><i class="far fa-eye"></i></a>
	                <br><br>
	               
	 				';
 				}
 				else
 				{
 					$sub_array[] = '
	 				<a href="'.base_url('admin/Booking/booking_detail/').$booking_id.'"><i class="far fa-eye"></i></a>
	                <br><br>
	               <a href="javascript:void(0);" class="btn btn-sm btn-warning bookingcancel" id="'.$booking_id.'">Booking Cancel</a>
	 				';
 				}



 				
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	

	function booking_detail($booking_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		
	 		$bookingid = $this->encrypt->decode($booking_id);

	 		$data['booking'] = $this->general_obj->get_where_single(array('booking_id'=>$bookingid),'elb_booking');
	 		$this->load->view('admin/booking/booking_detail',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function exportcsv() 
	{
        $now = date('d-m-Y_H-i-s'); 
	    $filename = 'bookinglist_'.$now.'.csv'; 
        header("Content-Description: File Transfer"); 
        header("Content-Disposition: attachment; filename=$filename"); 
        header("Content-Type: application/csv; ");
	    
	    // get data 
	   
		$year = $_POST['yr'];
		
	   	$data = $this->general_obj->get_where(array('is_delete'=>'0','YEAR(created_at)'=>$year),'elb_booking');
	   
	    // file creation 
	    $files = fopen('php://output', 'w');
	    $header = array("NO","BOOKING ID","USER NAME","USER EMAIL","USER PHONE NUMBER","BEACH NAME","RESORT NAME","BOOKING DATE","BASIC AMOUNT","PROMO CODE","PROMO DISCOUNT","TAX CHARGE","TOTAL AMOUNT","STATUS","ADDED ON","TRANSACTION ID");
	    fputcsv($files, $header);
            
        $i=1;
        foreach ($data as $row) 
        {
            $booking_id=$row['booking_id'];
            $status=$row['status'];
            $created_at=$row['created_at'];
            
            $total_amount=$row['total_amount'];	

            $userinfo = $this->general_obj->get_where_single(array('user_id'=>$row['user_id']),'elb_user');
        	$username = $userinfo->first_name.' '.$userinfo->surname;
        	$useremail = $userinfo->email;
        	$userphone = $userinfo->phone;

       		$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$row['resort_id']),'elb_resort');
       		$resortname = $resortinfo->resort_name;


       		$beachinfo = $this->general_obj->get_where_single(array('beach_id'=>$row['beach_id']),'elb_beach');
       		$beachname = $beachinfo->beach_name;


       		if(empty($row['to_date']))
			{
				$booking_date = date('d-M-Y',strtotime($row['from_date']));
			}
			else
			{
				$booking_date = 'From : '.date('d-M-Y',strtotime($row['from_date'])).'  -  To : '.date('d-M-Y',strtotime($row['to_date'])) ;
			}

            if ($status == 'booked') 
            {
                 $statuss = "Booked";
            }   
            else
            {
                 $statuss = "Pending";
            }
            
			$promoinfo = $this->general_obj->get_where_single(array('promo_id'=>$row['promo_id']),'elb_promo');
				
			if(!empty($promoinfo))
			{
				$promoname = $promoinfo->promo_name;
				$promo = $row['promo_discount'];
			}
			else
			{
				$promoname = '--';
				$promo = 0.00;

			}

			if($row['basic_amount']==null)
			{
				$bamount = $row['total_amount'] - $row['tax_amount'];
			}
			else
			{
				$bamount = $row['basic_amount'];
			}
			
			$taxamount = $row['tax_amount'];
			$transaction_id = $row['transaction_id'];

            $csv = array($i,$booking_id,$username,$useremail,$userphone,$beachname,$resortname,$booking_date,$bamount,$promoname,$promo,$taxamount,$total_amount,$statuss,$created_at,$transaction_id);
            fputcsv($files, $csv);
        

        	$i++;    
        }
        fclose($file,$files);
        exit;
	}

	
	function add_return_moneydata($booking_id)
    {   
        if ($this->session->userdata('logged_in_elba'))
        {
            $description = $_POST['description'];

            $bookingid = $this->encrypt->decode($booking_id);
             
            $booking = $this->general_obj->get_where_single(array('booking_id'=>$bookingid),'elb_booking');
            $total_refund = $booking->total_amount - $booking->tax_amount ;

            $trns_id = $booking->transaction_id;

            $total_amount = sprintf('%0.2f', $total_refund);

            
            $charges_url = 'https://api.stripe.com/v1/refunds';
            $charges_headers = array('Authorization: Bearer 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'); 
        
            $charges_fields = array(
                'amount'=> $total_amount * 100,
                'charge' => $trns_id,
            );

            $charges_ch = curl_init();
            curl_setopt($charges_ch, CURLOPT_HTTPHEADER, $charges_headers);
            curl_setopt($charges_ch, CURLOPT_URL, $charges_url);
            curl_setopt($charges_ch, CURLOPT_POST, true);
            curl_setopt($charges_ch, CURLOPT_POSTFIELDS, http_build_query($charges_fields));
            curl_setopt($charges_ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($charges_ch, CURLOPT_SSL_VERIFYPEER, false);
            $charges_output = curl_exec($charges_ch);
            $charges_response = json_decode($charges_output);
            curl_close($charges_ch);

            
            if((array_key_exists("error",$charges_response)))
            {   
                $json['status']='error';
                $json['message']= 'Payment Not Refund , Somthing Wrong , Please Try Again' ;
                echo json_encode($json);
            }
            else
            {
                $data=array(
                    'ref_transaction_id'=>$charges_response->id,
                    'booking_id'=>$bookingid,
                    'description'=>$description,
                    'amount'=>$total_amount 
                );

                $add = $this->general_obj->insert_data($data,'elb_booking_refund');

                if($add > 0)
                {
                    $refunds = $this->general_obj->get_where(array('booking_id' => $booking->booking_id),'elb_booking_refund');

                    $output ='';
                    if(!empty($refunds))
                    {
                        $output .='<a class="btn btn-warning" id="click-button1" onclick="full_money();" href="javascript:void(0);">Refund</a>';
                    }
                    else
                    {
                        $output .='<a class="btn btn-warning" id="click-button2" onclick="return_money();" href="javascript:void(0);">Refund</a>';
                    }   

                    $json['status']='success';
                    $json['response'] = $output;
                    echo json_encode($json);
                }
                else
                {   
                    $json['status']='error';
                    $json['message']= 'Payment Refund , But Refund Detail Not Add.' ;
                    echo json_encode($json);
                }
            }
        }
        else
        {
            redirect('admin/Login','refresh');
        }
    }


    function booking_cancel()
    {   
        if ($this->session->userdata('logged_in_elba'))
        {
            $booking_id = $_POST['id'];

            $bookingid = $this->encrypt->decode($booking_id);
            
            $api_url = base_url('admin/v2/resort/Api/update_status_booking_id');

        
            $form_data = array(
                'booking_id' => $bookingid,
                'status'=>'reject'
            );
        
            $client = curl_init($api_url);
            curl_setopt($client, CURLOPT_POST, true);
            curl_setopt($client, CURLOPT_POSTFIELDS, $form_data);
            curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($client);
            curl_close($client);
            
            $result = json_decode($response);
                
            $status = $result->status;
            
            if($status=='0')
            {   
                $json['status']='error';
                $json['message']= 'Booking Not Cancel , Please Try Agian' ;
                echo json_encode($json);

            }
            else
            {   
                $data=array(
                    'reject_by'=>'admin',
                );

                $this->general_obj->update_data($data,array('booking_id'=> $bookingid),'elb_booking');

                $json['status']='success';
                $json['message']= 'Booking Cancel Successfully' ;
                echo json_encode($json);

            }

        }
        else
        {
            redirect('admin/Login','refresh');
        }
    }


    
}


