<?php
class Contactus extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
 			$this->load->view('admin/contactus/list_contactus');
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_contact_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$contactus = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0'),'contact_id','desc','elb_contactus');

			$data = array();
        	$i=1;
        	foreach($contactus as $row)
        	{	

        		$contact_id = $this->encrypt->encode($row['contact_id']);

        		$sub_array = array();
 				$sub_array[] = $i;
 				$sub_array[] = $row['user_type'];
 				$sub_array[] = $row['contact_name'];
 				$sub_array[] = $row['email'];
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="'.base_url('admin/Contactus/contactus_detail/').$contact_id.'"><i class="far fa-eye"></i></a>

 				';
 				
 				
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function contactus_detail($contact_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['contact_id'] = $contact_id;
	 		
	 		$contactid = $this->encrypt->decode($contact_id);
	 		$data['contact'] = $this->general_obj->get_where_single(array('contact_id'=>$contactid),'elb_contactus');
	 		$this->load->view('admin/contactus/contactus_detail',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}



	

}


