<?php 
class Login extends CI_Controller
{
	function __construct()
 	{
 		parent::__construct();
 		$this->load->model('admin/General_model','general_obj');
 		$this->load->library('form_validation');
 	}

 	function index()
 	{
 		if ($this->session->userdata('logged_in_elba')) 
 		{
 			redirect('admin/Dashboard','refresh');
 		}
	 	else
	 	{
	 		$this->load->view('admin/login');
	 	}
 	}

	function check_login()
	{
		$email = $_POST['email'];
		$pass =  $_POST['password'];		

		$this->form_validation->set_rules('email','Email','required');
		$this->form_validation->set_rules('password','Password','required|callback_check_database');

		if ($this->form_validation->run() == FALSE) 
		{
			$this->index();
		}	
		else
		{	
			redirect('admin/Dashboard','refresh');		
		}			
	}

	function check_database()
	{
		$email = $this->input->post('email');
		$password = md5($this->input->post('password'));

		$result = $this->general_obj->get_where(array('email'=>$email,'password'=>$password),'elb_admin');

		if(!empty($result))
		{
			$sess_array = array();
			foreach($result as $row)
			{
				$sess_array = array(
					'admin_id' => $row['admin_id'],
				);
				$this->session->set_userdata('logged_in_elba', $sess_array);
			}

			return TRUE;
		}
		else
		{
			$this->form_validation->set_message('check_database', '<p style="color: red;text-align: center;">Invalid Email or Password</p>');
			return false;
		}
	}

	function logout(){

		$this->session->unset_userdata('logged_in_elba');
		redirect('admin/Login','refresh');
	}


	function profile()
	{
		if ($this->session->userdata('logged_in_prl')) 
 		{
 			$this->load->view('admin/template/header');
 			$this->load->view('admin/profile');
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		$this->load->view('admin/login');
	 	}		
	}

	function profile_data()
	{
		$admin_id = $this->encrypt->decode($_POST['dataid']);
		$result = $this->general_obj->get_where_single(array('admin_id'=>$admin_id),'prl_admin');
 		
 		if($result->image)
 		{
 			$result->imageid = base_url('uploads/admin_image/').$result->image;
 		}
 		else
 		{
 			$result->imageid = base_url('uploads/user.png');
 		}	
 		echo json_encode(['data'=>$result]);
	}

	function edit_save_profile()
	{
		if ($this->session->userdata('logged_in_prl')) 
		{
			$user_id = $this->encrypt->decode($_POST['dataid']);
			$admin_name = $_POST['admin_name'];
			$email = $_POST['email'];
			$phone = $_POST['phone'];
			
			$userdata = $this->general_obj->get_where_single(array('admin_id'=>$user_id),'prl_admin');	
			$image1 = $userdata->image;


			$emailcheck = $this->general_obj->get_where(array('email'=>$email,'admin_id!='=>$user_id),'prl_admin');

			if($emailcheck!=null)
			{
				echo 'emailexist';
			}	
			else
			{
				$phonecheck = $this->general_obj->get_where(array('phone'=>$phone,'admin_id!='=>$user_id),'prl_admin');

				if($phonecheck!=null)
				{
					echo 'phoneexist';
				}	
				else
				{
					$this->load->library('upload');
            		$data = [
            			'admin_name'=>$admin_name,
                    	'email'=>$email,
                 		'phone'=>$phone
                    ];
            		
            		if($_FILES['profileimage']['name']!='')
            		{
                		$configs['encrypt_name']    = TRUE;
                		$configs['upload_path']     = './uploads/admin_image';
                		$configs['allowed_types']   = '*';
                	
                		$this->upload->initialize($configs);
                		if($this->upload->do_upload('profileimage'))
                		{
                    		$data1 = $this->upload->data();
                    		$images=$data1["file_name"];
                    		unlink("./uploads/admin_image/$image1");
                		}
                		else if($image1!=null)
                		{
                    		$images=$image1;
                		}
                		else
                		{
                			$images='';
                		}	
            		}
            		else
            		{
            			$images=$image1;
            		}

            		$data['image']=$images;

				
					$this->db->where('admin_id',$user_id);
					$usid = $this->db->update('prl_admin',$data);

					if($usid!=0)
					{	
            			echo 'success';
            		}
            		else
            		{
            			echo 'notadd';
            		}
				}
			}
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}

	function change_password()
	{
	    if ($this->session->userdata('logged_in_prl')) 
		{
			$pwd = strip_tags($_POST['old_password']);
 		    $password=md5($pwd);
            
            $newpwd = strip_tags($_POST['new_password']);
            $newpassword=md5($newpwd);
                    
            $confpwd = strip_tags($_POST['con_newpassword']);
		    $confirmnewpassword=md5($confpwd);
         	
         	$user_id = $this->encrypt->decode($_POST['dataid']);

         	$result = $this->general_obj->get_where(array('admin_id'=>$user_id),'prl_admin');
         	$hash =$result[0]['password'];

         	if ($password == $hash)
            { 
                if($newpassword == $confirmnewpassword)
                { 
                    $data=array( 
                        'password'=>$newpassword,
                    );
                    
                    $this->db->where('admin_id', $user_id);
                    $uid = $this->db->update('prl_admin', $data);
                    if($uid > 0)
                    {
                    	echo "success";
                    }
                    else
                    {
                    	echo 'passwordnotadd';
                    }
                }
                else
                {
                    echo "samepassword";
                }
            }
            else
            {
                echo "currentpassword";
            }
		}
		else
		{
			redirect('admin/Login','refresh');
		}	
	}
}
?>