<?php
class Packages extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
			$data['featurespackage'] = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features'=>'y'),'features_order','ASC','elb_package');
			$data['featurespackage_web'] = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features_web'=>'y'),'features_web_order','ASC','elb_package');
 			$this->load->view('admin/package/list_package',$data);
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_package_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$resort = $this->general_obj->get_where(array('is_delete'=>'0'),'elb_package');

			$data = array();
        	$i=1;
        	foreach($resort as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>";

        		$confirm = ($row['book_confirm'] == "y") ? "<span class='badge outline-badge-success'>Yes</span>" : "<span class='badge outline-badge-danger'>No</span>"; 


        		$package_id = $this->encrypt->encode($row['package_id']);

        		if($row['package_image']!=null)
				{
					$package_image = base_url('uploads/package_image/').$row['package_image'];
				}
				else
				{
					$package_image = '';
				}


				$servicetype = $this->general_obj->get_where_single(array('service_id'=>$row['service_type']),'elb_package_service');
				$type_name = $servicetype->service_name_en;


				if($row['features']=='n')
				{
 					$feature = '<a href="javascript:void(0);" class="btn btn-sm btn-info changestatus" id="'.$package_id.'">Set App Awesome</a>';
				}
				else
				{
					$feature = "<span class='badge outline-badge-success'>Set App Awesome List</span>";
				}


				if($row['features_web']=='n')
				{
 					$feature_web = '<a href="javascript:void(0);" class="btn btn-sm btn-warning changestatus_web" id="'.$package_id.'">Set Web Awesome</a>';
				}
				else
				{
					$feature_web = "<span class='badge outline-badge-success'>Set Web Awesome List</span>";
				}



				$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$row['resort_id']),'elb_resort');

				$package_date = '<b>From</b><p>'.date('d-m-Y',strtotime($row['start_date'])).'</p><b>To</b><p>'.date('d-m-Y',strtotime($row['end_date'])).'</p>';

        		$sub_array = array();
 				$sub_array[] = $i;
 				/*$sub_array[] = '<span><img style="width:50px;height:50px;;" src="'.$package_image.'" class="rounded-circle profile-img" alt="avatar"></span>';*/
 				$sub_array[] = $resortinfo->resort_name;
 				$sub_array[] = $type_name;
 				$sub_array[] = $row['package_service_code'];
 				$sub_array[] = $row['package_service_name_en'];
 				$sub_array[] = $package_date;
 				$sub_array[] = $confirm;
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="'.base_url('admin/Packages/edit_package/').$package_id.'"><i class="far fa-edit"></i></a>
 				&nbsp;&nbsp;
 				<a href="javascript:void(0);"  class="delete" id="'.$package_id.'"><i class="far fa-trash-alt"></i></a>
 				<br><br>
 				'.$feature.'
 				<br><br>
				'.$feature_web.'

 				';
 				
 				
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function delete_package()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$package_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'is_delete'=>'1',
 				'is_active' => '0'
 			);

	 		$this->db->where('package_id',$package_id);
	 		$this->db->update('elb_package',$data);

	 		echo 'Package Deleted Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_package()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['package_service'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_package_service');
	 		$data['resorts'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_resort');
	 		$this->load->view('admin/package/add_package',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_save_packages()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}


			if($this->input->post('rent_type') == 'middle_or_daily')
			{
				$middle_price = $this->input->post('middle_price');
			}
			else
			{
				$middle_price = NULL ;
			}

			$start_date = date('Y-m-d',strtotime($this->input->post('start_date')));
			$end_date = date('Y-m-d',strtotime($this->input->post('end_date')));

			if($end_date < $start_date)
			{		
					$json['status']='error';
					$json['message']= 'End Date is not less then to Start Date';
					echo json_encode($json);	
			}
			else
			{	
				
				$data=[
					"rent_type" => $this->input->post('rent_type'),
					"service_type" => $this->input->post('service_type'),
					"resort_id" => $this->input->post('resort_id'),
					"package_service_code" => $this->input->post('package_service_code'),
					"package_service_name_en" => $this->input->post('package_service_name_en'),
					"package_service_name_it" => $this->input->post('package_service_name_it'),
					"description_en" => $this->input->post('description_en'),
					"description_it" => $this->input->post('description_it'),
					"start_date" => $start_date,
					"end_date" => $end_date,
					"price" => $this->input->post('price'),
					"middle_price" => $middle_price,
					"total_places" => $this->input->post('total_places'),
					"places_available" => $this->input->post('places_available'),
					"reservation_same_day" => $this->input->post('reservation_same_day'),
					"terms_service_en" => $this->input->post('terms_service_en'),
					"terms_service_it" => $this->input->post('terms_service_it'),
					"is_active" =>$status,
					"book_confirm" => $this->input->post('book_confirm'),

				];


				$this->load->library('upload');

				if($_FILES['package_image']['name']!='')
	            {
	                $configs['encrypt_name']    = TRUE;
	                $configs['upload_path']     = './uploads/package_image';
	                $configs['allowed_types']   = '*';
	                	
	                $this->upload->initialize($configs);
	                if(!$this->upload->do_upload('package_image'))
	        		{ 	
	        			$json['status']='error';
						$json['message']= strip_tags($this->upload->display_errors()) ;
						echo json_encode($json);
	        		}
	        		else
	    			{
	        			$packageimage = $this->upload->data('file_name');
	    			}	
	    		}
	    		else
	    		{
	    			$packageimage=NULL;
	    		}
				
				$data['package_image']= $packageimage;


				$this->general_obj->insert_data($data,'elb_package');


				$this->db->select('service_type');
				$this->db->where('resort_id',$_POST['resort_id']);
				$this->db->group_by('service_type');
				$querys1 = $this->db->get('elb_package');
				$packagelist = $querys1->result_array();

				$packagedatas  =  array_column($packagelist, 'service_type');

				$package_service = implode(',',$packagedatas);
				
				$updatedata =array(
					'package_service'=>$package_service,
				);

				$where = array("resort_id" =>$_POST['resort_id']);
				$this->general_obj->update_data($updatedata,$where,'elb_resort');
			
				$json['status']='success';
				echo json_encode($json);
			}

		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}




	function edit_package($package_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['package_id'] = $package_id;
	 		
	 		$packageid = $this->encrypt->decode($package_id);
	 		$data['package'] = $this->general_obj->get_where_single(array('package_id'=>$packageid),'elb_package');

	 		$data['package_service'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_package_service');
	 		$data['resorts'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_resort');
	 		$this->load->view('admin/package/edit_package',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function edit_save_packages()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			$package_id = $this->encrypt->decode($_POST['dataid']);

			$image1 = $this->input->post('image1');
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}


			if($this->input->post('rent_type') == 'middle_or_daily')
			{
				$middle_price = $this->input->post('middle_price');
			}
			else
			{
				$middle_price = NULL ;
			}

			$start_date = date('Y-m-d',strtotime($this->input->post('start_date')));
			$end_date = date('Y-m-d',strtotime($this->input->post('end_date')));

			if($end_date < $start_date)
			{		
					$json['status']='error';
					$json['message']= 'End Date is not less then to Start Date';
					echo json_encode($json);	
			}
			else
			{
				$data=[
					"rent_type" => $this->input->post('rent_type'),
					"service_type" => $this->input->post('service_type'),
					"resort_id" => $this->input->post('resort_id'),
					"package_service_code" => $this->input->post('package_service_code'),
					"package_service_name_en" => $this->input->post('package_service_name_en'),
					"package_service_name_it" => $this->input->post('package_service_name_it'),
					"description_en" => $this->input->post('description_en'),
					"description_it" => $this->input->post('description_it'),
					"start_date" => $start_date,
					"end_date" => $end_date,
					"price" => $this->input->post('price'),
					"middle_price" => $middle_price,
					"total_places" => $this->input->post('total_places'),
					"places_available" => $this->input->post('places_available'),
					"reservation_same_day" => $this->input->post('reservation_same_day'),
					"terms_service_en" => $this->input->post('terms_service_en'),
					"terms_service_it" => $this->input->post('terms_service_it'),
					"is_active" =>$status,
					"book_confirm" => $this->input->post('book_confirm'),
				];


				$this->load->library('upload');

				if($_FILES['package_image']['name']!='')
	            {
	                $configs['encrypt_name']    = TRUE;
	                $configs['upload_path']     = './uploads/package_image';
	                $configs['allowed_types']   = '*';
	                	
	                $this->upload->initialize($configs);
	                if(!$this->upload->do_upload('package_image'))
	        		{ 	
	        			$json['status']='error';
						$json['message']= strip_tags($this->upload->display_errors()) ;
						echo json_encode($json);
	        		}
	        		else
	    			{
	        			$packageimage = $this->upload->data('file_name');
	        			//unlink("./uploads/package_image/$image1");
	    			}	
	    		}
	    		else if($image1!=null)
	    		{
	    			$packageimage=$image1;
	    		}
	    		else
	    		{
	    			$packageimage=NULL;
	    		}
				
				$data['package_image']= $packageimage;


				$where = array("package_id" => $package_id);
				$this->general_obj->update_data($data,$where,'elb_package');


				$this->db->select('service_type');
				$this->db->where('resort_id',$_POST['resort_id']);
				$this->db->group_by('service_type');
				$querys1 = $this->db->get('elb_package');
				$packagelist = $querys1->result_array();

				$packagedatas  =  array_column($packagelist, 'service_type');

				$package_service = implode(',',$packagedatas);
				
				$updatedata =array(
					'package_service'=>$package_service,
				);

				$where2 = array("resort_id" =>$_POST['resort_id']);
				$this->general_obj->update_data($updatedata,$where2,'elb_resort');


				$json['status']='success';
				echo json_encode($json);
			}

		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}



	////////////////////////   awesome package ///////////////////////////////


	function awesome_package()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/package/list_awesome_package');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function fetch_awesomepackage_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$resort = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features'=>'y'),'features_order','ASC','elb_package');

			$data = array();
        	$i=1;
        	foreach($resort as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$package_id = $this->encrypt->encode($row['package_id']);

        		if($row['package_image']!=null)
				{
					$package_image = base_url('uploads/package_image/').$row['package_image'];
				}
				else
				{
					$package_image = '';
				}


				$servicetype = $this->general_obj->get_where_single(array('service_id'=>$row['service_type']),'elb_package_service');
				$type_name = $servicetype->service_name_en;

				$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$row['resort_id']),'elb_resort');

        		$sub_array = array();
 				$sub_array[] = $i;
 				/*$sub_array[] = '<span><img style="width:50px;height:50px;;" src="'.$package_image.'" class="rounded-circle profile-img" alt="avatar"></span>';*/
 				$sub_array[] = $resortinfo->resort_name;
 				$sub_array[] = $type_name;
 				$sub_array[] = $row['package_service_code'];
 				$sub_array[] = $row['package_service_name_en'];
 				$sub_array[] = $row['features_order'];
 				$sub_array[] = ucwords($row['features_type']);
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="javascript:void(0);"  class="delete" id="'.$package_id.'"><i class="far fa-trash-alt"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function delete_awesomepackage()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$package_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'features'=>'n',
 				'features_order' => NULL,
 				'features_type' => 'today'
 			);

	 		$this->db->where('package_id',$package_id);
	 		$this->db->update('elb_package',$data);

	 		echo 'Package Is Awesome List Remove Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function update_awesome_package()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$package_id = $this->encrypt->decode($_POST['package_id']);

 			$data=array(
 				'features'=>'y',
 				'features_order' => $_POST['features_order'],
 				'features_type' => $_POST['features_type']
 			);

	 		$this->db->where('package_id',$package_id);
	 		$upd = $this->db->update('elb_package',$data);

	 		if($upd > 0)
	 		{
	 			$json['status']='success';
				echo json_encode($json);
 			}
 			else
 			{
 				$json['status']='error';
 				$json['message']='Package Not Set ,Please Try Again';
				echo json_encode($json);
 			}
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	////////////////////////   Web awesome package ///////////////////////////////


	function web_awesome_package()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/package/list_awesome_package_web');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
	
	function fetch_web_awesomepackage_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$resort = $this->general_obj->get_where_with_order_by(array('is_delete'=>'0','is_active'=>'1','features_web'=>'y'),'features_web_order','ASC','elb_package');

			$data = array();
        	$i=1;
        	foreach($resort as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$package_id = $this->encrypt->encode($row['package_id']);

        		if($row['package_image']!=null)
				{
					$package_image = base_url('uploads/package_image/').$row['package_image'];
				}
				else
				{
					$package_image = '';
				}


				$servicetype = $this->general_obj->get_where_single(array('service_id'=>$row['service_type']),'elb_package_service');
				$type_name = $servicetype->service_name_en;

				$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$row['resort_id']),'elb_resort');

        		$sub_array = array();
 				$sub_array[] = $i;
 				/*$sub_array[] = '<span><img style="width:50px;height:50px;;" src="'.$package_image.'" class="rounded-circle profile-img" alt="avatar"></span>';*/
 				$sub_array[] = $resortinfo->resort_name;
 				$sub_array[] = $type_name;
 				$sub_array[] = $row['package_service_code'];
 				$sub_array[] = $row['package_service_name_en'];
 				$sub_array[] = $row['features_web_order'];
				$sub_array[] = ucwords($row['features_web_type']);
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="javascript:void(0);"  class="delete" id="'.$package_id.'"><i class="far fa-trash-alt"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}
	
	function delete_web_awesomepackage()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$package_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'features_web'=>'n',
 				'features_web_order' => NULL,
				'features_web_type' => 'today'
 			);

	 		$this->db->where('package_id',$package_id);
	 		$this->db->update('elb_package',$data);

	 		echo 'Package Is Awesome List Remove Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
	
	function update_web_awesome_package()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$package_id = $this->encrypt->decode($_POST['package_id']);

 			$data=array(
 				'features_web'=>'y',
 				'features_web_order' => $_POST['features_web_order'],
				'features_web_type' => $_POST['features_web_type']
 			);

	 		$this->db->where('package_id',$package_id);
	 		$upd = $this->db->update('elb_package',$data);

	 		if($upd > 0)
	 		{
	 			$json['status']='success';
				echo json_encode($json);
 			}
 			else
 			{
 				$json['status']='error';
 				$json['message']='Package Not Set ,Please Try Again';
				echo json_encode($json);
 			}
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
	
	
	



}


