<?php
class Promotions extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
 			$this->load->view('admin/promotions/list_promotions');
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_promo_data()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$promo = $this->general_obj->get_where(array('is_delete'=>'0','is_active'=>'1'),'elb_promo');

			$data = array();
        	$i=1;
        	foreach($promo as $row)
        	{	


        		$promo_id = $this->encrypt->encode($row['promo_id']);

        		$resort = $this->general_obj->get_where_single(array('resort_id' => $row['resort_id']),'elb_resort');
        		$package = $this->general_obj->get_where_single(array('package_id' => $row['package_id']),'elb_package');


        		if($row['start_date'])
				{
					$start_date = date('d-M-Y',strtotime($row['start_date']));
				}
				else
				{
					$start_date = '';
				}


				if($row['end_date'])
				{
					$end_date = date('d-M-Y',strtotime($row['end_date']));
				}
				else
				{
					$end_date = '';
				}

				if($row['promo_usage'])
				{
					$promo_usage = ucwords($row['promo_usage']).'('.$row['usage_number'].')';
				}
				else
				{
					$promo_usage = '';
				}

				if($row['discount_type']=='percentage')
				{	
					$maxamount = !empty($row['max_discount_amount']) ? $row['max_discount_amount'] : 0 ;
					
				}
				else
				{
					$maxamount = '--';
				}
				
        		$sub_array = array();
 				$sub_array[] = $i;
 		
 				$sub_array[] = $row['promo_name'];
 				$sub_array[] = $promo_usage;
 				$sub_array[] = ucwords($row['promo_type']);
 				$sub_array[] = ucwords($row['discount_type']);
 				$sub_array[] = $row['discount_amount'];
				$sub_array[] = $maxamount;
 				$sub_array[] = $resort->resort_name;
 				$sub_array[] = $package->package_service_name_en;
 				$sub_array[] = $start_date;
 				$sub_array[] = $end_date;
 				$sub_array[] = '<a href="javascript:void(0);"  class="delete" id="'.$promo_id.'"><i class="far fa-trash-alt"></i></a>';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function add_promo()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
			$data['resorts'] = $this->general_obj->get_where(array('is_delete'=>'0','is_active'=>'1'),'elb_resort');
			
 			$this->load->view('admin/promotions/add_promo',$data);
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function get_package()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$resort_id = $_POST['resort_id'];
			$packages = $this->general_obj->get_where(array('is_delete'=>'0','is_active'=>'1','resort_id' => $resort_id),'elb_package');


			echo json_encode($packages);
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function add_save_promo()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$promo_type = $_POST['promo_type'];
			$promo_name = $_POST['promo_name'];
			$resort_id = $_POST['resort_id'];
			$package_id = $_POST['package_id'];
			$promo_generate = $_POST['promo_generate'];
			$discount_type = $_POST['discount_type'];
			$discount_amount = $_POST['discount_amount'];
			$max_discount_amount = !empty($_POST['max_discount_amount']) ? $_POST['max_discount_amount'] : 0;			
			$description_en = $_POST['description_en'];
			$description_it = $_POST['description_it'];
			$promo_usage = $_POST['promo_usage'];
			$usage_number = $_POST['usage_number'];


			if($_POST['start_date'])
			{
				$start_date = date('Y-m-d',strtotime($this->input->post('start_date')));
			}
			else
			{
				$start_date = null;
			}


			if($_POST['end_date'])
			{
				$end_date =  date('Y-m-d',strtotime($this->input->post('end_date')));
			}
			else
			{
				$end_date = null;
			}


			
			if ($promo_type == 'predefined') 
			{
						$insertdata = array(
						'promo_type' => $promo_type,
						'promo_name' => $promo_name,
						'resort_id' => $resort_id,
						'package_id' => $package_id,
						'promo_generate' => $promo_generate,
						'discount_type' => $discount_type,
						'discount_amount' => $discount_amount,
						'max_discount_amount' => $max_discount_amount,
						'start_date' => $start_date,
						'end_date' => $end_date,
						'description_en' => $description_en,
						'description_it' => $description_it,
						'promo_usage'=> $promo_usage,
						'usage_number'=> $usage_number
					);

					$this->general_obj->insert_data($insertdata,'elb_promo');
					
					$promo_id = $this->db->insert_id();

					if($promo_id > 0)
					{
						$json['status']='success';
						$json['message']= 'Promo Added Successfully.' ;
						echo json_encode($json);
					}
					else
					{
						$json['status']='error';
						$json['message']= 'Promo Not Added. Somthing As Worng!' ;
						echo json_encode($json);
					}
			}
			else
			{

				if ($promo_generate == 'manual') 
				{
					
						$insertdata = array(
						'promo_type' => $promo_type,
						'promo_name' => $promo_name,
						'resort_id' => $resort_id,
						'package_id' => $package_id,
						'promo_generate' => $promo_generate,
						'discount_type' => $discount_type,
						'discount_amount' => $discount_amount,
						'max_discount_amount' => $max_discount_amount,
						'start_date' => $start_date,
						'end_date' => $end_date,
						'description_en' => $description_en,
						'description_it' => $description_it,
						'promo_usage'=> $promo_usage,
						'usage_number'=> $usage_number
					);

					$this->general_obj->insert_data($insertdata,'elb_promo');
					$promo_id = $this->db->insert_id();

					if($promo_id > 0)
					{
						$json['status']='success';
						$json['message']= 'Promo Added Successfully.' ;
						echo json_encode($json);
					}
					else
					{
						$json['status']='error';
						$json['message']= 'Promo Not Added. Somthing As Worng!' ;
						echo json_encode($json);
					}
				}
				else
				{	

					$number_promo = $_POST['number_promo'];

					 $promo_codes = $this->generate_unique_promo_codes($number_promo, 6);
                
	                foreach ($promo_codes as $code) 
	                {	

	                	$code_data = array(
							'promo_type' => $promo_type,
							'promo_name' => $code,
							'resort_id' => $resort_id,
							'package_id' => $package_id,
							'promo_generate' => $promo_generate,
							'discount_type' => $discount_type,
							'discount_amount' => $discount_amount,
							'max_discount_amount' => $max_discount_amount,
							'start_date' => $start_date,
							'end_date' => $end_date,
							'description_en' => $description_en,
							'description_it' => $description_it,
							'promo_usage'=> $promo_usage,
							'usage_number'=> $usage_number
						);
	                    $this->general_obj->insert_data($code_data, 'elb_promo');
	                }

	                $json['status'] = 'success';
	                $json['message'] = 'Promo Added Successfully with Unique Codes.';
	                echo json_encode($json);
				}	
			}
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}

	}

	function generate_unique_promo_codes($count, $length)
	{
	    $codes = [];
	    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	    $charactersLength = strlen($characters);

	    while (count($codes) < $count) 
	    {
	        $code = '';
	        for ($i = 0; $i < $length; $i++) 
	        {
	            $code .= $characters[rand(0, $charactersLength - 1)];
	        }

	        if (!in_array($code, $codes)) 
	        {
	            $codes[] = $code;
	        }
	    }

	    return $codes;
	}

	function delete_promotion()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$promo_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'is_delete'=>'1',
 				'is_active' => '0'
 			);

	 		$this->db->where('promo_id',$promo_id);
	 		$this->db->update('elb_promo',$data);

	 		echo 'Promo Deleted Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}
}
?>	