<?php
class Report extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
            $data['resorts'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_resort');
 			$this->load->view('admin/report/list_report',$data);
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_book_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{    
            if($_POST['from_date'])
            {
                $from_date = date('Y-m-d',strtotime($_POST['from_date']));
            }
            else
            {
                $from_date = '';
            }

            if($_POST['to_date'])
            {
                $to_date = date('Y-m-d',strtotime($_POST['to_date']));
            }
            else
            {
                $to_date = '';
            }


            if($from_date!=null || $to_date!=null )
            {
                if($to_date!=null)
                {   
                    $this->db->where('from_date <=',$to_date);
                    $this->db->where('to_date >=',$from_date);             
                }   
                else
                {
                    $this->db->where('from_date <=',$from_date);
                    $this->db->where('to_date >=',$from_date);
                }

                if($_POST['resort_id']!=null || $_POST['resort_id']!='')
                {
                    $this->db->where('resort_id',$_POST['resort_id']);   
                }

                if($_POST['status']!=null || $_POST['status']!='')
                {
                    $this->db->where('status',$_POST['status']);   
                }

                //$this->db->where_in("status",array('booked','arrived','notshow'));
                $this->db->order_by('booking_id','DESC');
                $query = $this->db->get('elb_booking');
                $earninglist = $query->result_array();
            }
            else
            {       
                if($_POST['resort_id']!=null || $_POST['resort_id']!='')
                {
                    $this->db->where('resort_id',$_POST['resort_id']);   
                }

                if($_POST['status']!=null || $_POST['status']!='')
                {
                    $this->db->where('status',$_POST['status']);   
                }

                //$this->db->where_in("status",array('booked','arrived','notshow'));
                $this->db->order_by('booking_id','DESC');
                $query = $this->db->get('elb_booking');
                $earninglist = $query->result_array();
            }



			$data = array();
        	$i=1;
        	foreach($earninglist as $row)
        	{	
                if($row['status'] == "booked")
                {
                    $status = "<span class='badge outline-badge-success'>Booked</span>"; 
                }
                else if($row['status'] == "arrived")
                {
                    $status = "<span class='badge outline-badge-secondary'>Arrived</span>";
                }
                else if($row['status'] == "notshow")
                {
                    $status = "<span class='badge outline-badge-warning'>Not Show</span>";
                }
                else if($row['status'] == "reject")
                {
                    $status = "<span class='badge outline-badge-danger'>Reject</span>";
                }
                else if($row['status'] == "user_cancel")
                {
                    $status = "<span class='badge outline-badge-danger'>User Cancel</span>";
                }   
                else
                {
                    $status = "<span class='badge outline-badge-dark'>Pending</span>";
                }


        		$booking_id = $this->encrypt->encode($row['booking_id']);

                $resort_earning_amount = $row['total_amount'] - $row['tax_amount'];


        	    $beachinfo = $this->general_obj->get_where_single(array('beach_id  '=>$row['beach_id']),'elb_beach');   

                $resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$row['resort_id']),'elb_resort');


                $bookdata = $this->general_obj->get_where(array('booking_id'=>$row['booking_id']),'elb_booking_detail');
                array_walk_recursive($bookdata,function(&$bookdata){$bookdata=strval($bookdata);}); 
                $package_qty = $bookdata[0]['package_qty'];

                if($row['package_id']=='0')
                {
                    $packageinfo = $this->general_obj->get_where_single(array('booking_detail_id'=>$bookdata[0]['booking_detail_id']),'elb_booking_package');
                    
                    if($row['from_date']==$row['to_date'] || $row['to_date']=='')
                    {
                        $package_type = 'single';
                    }
                    else
                    {
                        $package_type = 'combo';
                    }
                }
                else
                {
                    $packageinfo = $this->general_obj->get_where_single(array('book_package_id'=>$bookdata[0]['book_package_id']),'elb_booking_package');
                    

                    if($row['from_date']==$row['to_date'] || $row['to_date']=='' )
                    {
                        $package_type = 'single';
                    }
                    else
                    {
                        $package_type = 'combo';
                    }
                }

                $servicetypeinfo = $this->general_obj->get_where_single(array('service_id'=>$packageinfo->service_type),'elb_package_service');

                $packageinfodata =  '<b>'.$packageinfo->package_service_name_en.'</b><br> Type : '.$servicetypeinfo->service_name_en;


                $userinfo = $this->general_obj->get_where_single(array('user_id'=>$row['user_id']),'elb_user');
                $userdata =  '<b>'.$userinfo->first_name.' '.$userinfo->surname.'</b><br>
                              '.$userinfo->email.'<br>'.$userinfo->phone ;




        		$sub_array = array();
 				$sub_array[] = $i;
 				if(empty($row['to_date']))
 				{
 					$sub_array[] = date('d-M-Y',strtotime($row['from_date']));
 				}
 				else
 				{
 					$sub_array[] = '<b>From</b>:<br>'.date('d-M-Y',strtotime($row['from_date'])).' <br><b>To</b>:<br> '.date('d-M-Y',strtotime($row['to_date'])) ;
 				}
                $sub_array[] = $userdata;
                $sub_array[] = $packageinfodata;
                $sub_array[] = $beachinfo->beach_name;
                $sub_array[] = $resortinfo->resort_name;
 				$sub_array[] = '&euro; '.$row['total_amount'];
 			    $sub_array[] = '&euro; '.strval($resort_earning_amount);
                $sub_array[] = $status;
 				$sub_array[] = '
 				<a href="'.base_url('admin/Booking/booking_detail/').$booking_id.'"><i class="far fa-eye"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


    function exportcsv() 
    {
        $now = date('d-m-Y_H-i-s'); 
        $filename = 'bookinglist_'.$now.'.csv'; 
        header("Content-Description: File Transfer"); 
        header("Content-Disposition: attachment; filename=$filename"); 
        header("Content-Type: application/csv; ");
        
        // get data 
       
        if($_POST['from_date'])
        {
            $from_date = date('Y-m-d',strtotime($_POST['from_date']));
        }
        else
        {
            $from_date = '';
        }

        if($_POST['to_date'])
        {
            $to_date = date('Y-m-d',strtotime($_POST['to_date']));
        }
        else
        {
            $to_date = '';
        }


        if($from_date!=null || $to_date!=null )
        {
            if($to_date!=null)
            {   
                $this->db->where('from_date <=',$to_date);
                $this->db->where('to_date >=',$from_date);             
            }   
            else
            {
                $this->db->where('from_date <=',$from_date);
                $this->db->where('to_date >=',$from_date);
            }

            if($_POST['resort_id']!=null || $_POST['resort_id']!='')
            {
                $this->db->where('resort_id',$_POST['resort_id']);   
            }

            if($_POST['status']!=null || $_POST['status']!='')
            {
                $this->db->where('status',$_POST['status']);   
            }

            //$this->db->where_in("status",array('booked','arrived','notshow'));
            $this->db->order_by('booking_id','DESC');
            $query = $this->db->get('elb_booking');
            $earninglist = $query->result_array();
        }
        else
        {       
            if($_POST['resort_id']!=null || $_POST['resort_id']!='')
            {
                $this->db->where('resort_id',$_POST['resort_id']);   
            }

            if($_POST['status']!=null || $_POST['status']!='')
            {
                $this->db->where('status',$_POST['status']);   
            }

            //$this->db->where_in("status",array('booked','arrived','notshow'));
            $this->db->order_by('booking_id','DESC');
            $query = $this->db->get('elb_booking');
            $earninglist = $query->result_array();
        }
       



        // file creation 
        $files = fopen('php://output', 'w');
        $header = array("NO","BOOKING ID","BOOKING DATE","USER NAME","USER EMAIL","USER PHONE NUMBER","PACKAGE NAME","PACKAGE TYPE","BEACH NAME","RESORT NAME","TOTAL AMOUNT","RESORT EARNING","STATUS","ADDED ON");
        fputcsv($files, $header);
            
        $i=1;
        foreach ($earninglist as $row) 
        {
            if($row['status'] == "booked")
            {
                $status = "Booked"; 
            }
            else if($row['status'] == "arrived")
            {
                $status = "Arrived";
            }
            else if($row['status'] == "notshow")
            {
                $status = "Not Show";
            }
            else if($row['status'] == "reject")
            {
                $status = "Reject";
            }
            else if($row['status'] == "user_cancel")
            {
                $status = "User Cancel";
            }   
            else
            {
                $status = "Pending";
            }


            $booking_id = $row['booking_id'];

            $total_amount=$row['total_amount'];
            $resort_earning_amount = $row['total_amount'] - $row['tax_amount'];

            $created_at=$row['created_at'];


            $beachinfo = $this->general_obj->get_where_single(array('beach_id  '=>$row['beach_id']),'elb_beach');
            $beachname = $beachinfo->beach_name;   

            $resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$row['resort_id']),'elb_resort');
            $resortname = $resortinfo->resort_name;


            $bookdata = $this->general_obj->get_where(array('booking_id'=>$row['booking_id']),'elb_booking_detail');
            array_walk_recursive($bookdata,function(&$bookdata){$bookdata=strval($bookdata);}); 
            $package_qty = $bookdata[0]['package_qty'];

            if($row['package_id']=='0')
            {
                $packageinfo = $this->general_obj->get_where_single(array('booking_detail_id'=>$bookdata[0]['booking_detail_id']),'elb_booking_package');
                
                if($row['from_date']==$row['to_date'] || $row['to_date']=='')
                {
                    $package_type = 'single';
                }
                else
                {
                    $package_type = 'combo';
                }
            }
            else
            {
                $packageinfo = $this->general_obj->get_where_single(array('book_package_id'=>$bookdata[0]['book_package_id']),'elb_booking_package');
                

                if($row['from_date']==$row['to_date'] || $row['to_date']=='' )
                {
                    $package_type = 'single';
                }
                else
                {
                    $package_type = 'combo';
                }
            }

            $servicetypeinfo = $this->general_obj->get_where_single(array('service_id'=>$packageinfo->service_type),'elb_package_service');

            $packageinfodata =  $packageinfo->package_service_name_en;
            $type = $servicetypeinfo->service_name_en;


            $userinfo = $this->general_obj->get_where_single(array('user_id'=>$row['user_id']),'elb_user');
            $username = $userinfo->first_name.' '.$userinfo->surname;
            $useremail = $userinfo->email;
            $userphone = $userinfo->phone;

            
            if(empty($row['to_date']))
            {
                $booking_date = date('d-M-Y',strtotime($row['from_date']));
            }
            else
            {
                $booking_date = 'From : '.date('d-M-Y',strtotime($row['from_date'])).'  -  To : '.date('d-M-Y',strtotime($row['to_date'])) ;
            }

            

            $csv = array($i,$booking_id,$booking_date,$username,$useremail,$userphone,$packageinfodata,$type,$beachname,$resortname,$total_amount,$resort_earning_amount,$status,$created_at);
            fputcsv($files, $csv);
        

            $i++;    
        }
        fclose($file,$files);
        exit;
    }

}


