<?php
class Resorts extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
 			$this->load->view('admin/resort/list_resort');
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_resort_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$resort = $this->general_obj->get_where(array('is_delete'=>'0'),'elb_resort');

			$data = array();
        	$i=1;
        	foreach($resort as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>";  


        		$resort_id = $this->encrypt->encode($row['resort_id']);

        		if($row['resort_image']!=null)
				{
					$resort_image = base_url('uploads/resort_image/').$row['resort_image'];
				}
				else
				{
					$resort_image = '';
				}


				$payment_mode = '<p><b>App</b> :-&nbsp;&nbsp;'.ucfirst($row['app_payment_mode']).'</p><p><b>Web</b> :-&nbsp;&nbsp;'.ucfirst($row['web_payment_mode']).'</p>';	



        		$sub_array = array();
 				$sub_array[] = $i;
 				/*$sub_array[] = '<span><img style="width:50px;height:50px;;" src="'.$resort_image.'" class="rounded-circle profile-img" alt="avatar"></span>';*/
 				$sub_array[] = $row['resort_code'];
 				$sub_array[] = $row['resort_name'];
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = $payment_mode;
 				$sub_array[] = '
 				<a href="'.base_url('admin/Resorts/edit_resort/').$resort_id.'"><i class="far fa-edit"></i></a>
 				&nbsp;&nbsp;
 				<a href="javascript:void(0);"  class="delete" id="'.$resort_id.'"><i class="far fa-trash-alt"></i></a>
 				<br><br>
 				<a  class="btn btn-sm btn-info" href="'.base_url('admin/Resorts/edit_resort_image/').$resort_id.'">Resort Images</a>
 				<br><br>
 				<a href="javascript:void(0);" class="btn btn-sm btn-warning changestatus" id="'.$resort_id.'">Change Payment Mode</a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function delete_resort()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$resort_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'is_delete'=>'1',
 				'is_active' => '0'
 			);

	 		$this->db->where('resort_id',$resort_id);
	 		$this->db->update('elb_resort',$data);

	 		echo 'Resort Deleted Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_resort()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['beachs'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_beach');
	 		$data['resortservice'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_resort_services');
	 		$this->load->view('admin/resort/add_resort',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_save_resort()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$services = implode(',', $_POST['services']);


			if(empty($this->input->post('resort_open_date')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Open Date' ;
				echo json_encode($json);
			}
			else if(empty($this->input->post('resort_close_date')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Close Date' ;
				echo json_encode($json);
			}
			else if(empty($this->input->post('open_time')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Open Time' ;
				echo json_encode($json);
			}
			else if(empty($this->input->post('close_time')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Close Time' ;
				echo json_encode($json);
			}
			else if($_POST['password']!=$_POST['conf_password'])
			{
				$json['status']='error';
				$json['message']= 'Password and Confirm Password Does not Match' ;
				echo json_encode($json);
			}
			else
			{	
				$email_check = $this->general_obj->get_where(array('email'=>$_POST['email'],'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');
              
				if(!empty($email_check))  
				{	
					$json['status']='error';
					$json['message']= 'Email Already Exists' ;
					echo json_encode($json);
				}
				else
				{
					$phone_check = $this->general_obj->get_where(array('phone'=>$_POST['phone'],'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');

					if(!empty($phone_check))
					{
						$json['status']='error';
						$json['message']= 'Phone Number Already Exists' ;
						echo json_encode($json);
					}
					else
					{
						$userdata=[
							'user_type'=>'resort',
							'first_name'=>$_POST['owner_name'],
							'surname'=>$_POST['owner_surname'],
							'email'=>$_POST['email'],
							'phone'=>$_POST['phone'],
							'password'=>md5($_POST['password']),
							'email_verify' => '1', 
							'email_otp' => '123456',
						];


						$this->general_obj->insert_data($userdata,'elb_user');
						$user_id = $this->db->insert_id();	

						$data=[
							"user_id" => $user_id,
							"beach_id" => $this->input->post('beach_id'),
							"resort_code" => $this->input->post('resort_code'),
							"resort_name" => $this->input->post('resort_name'),
							"address" => $this->input->post('address'),
							"city" => $this->input->post('city'),
							"zipcode" => $this->input->post('zipcode'),
							"description" => $this->input->post('description'),
							"description_en" => $this->input->post('description_en'),
							"resort_open_date" => $this->input->post('resort_open_date'),
							"resort_close_date" => $this->input->post('resort_close_date'),
							"email" => $this->input->post('email'),
							"phone" => $this->input->post('phone'),
							"company_name" => $this->input->post('company_name'),
							"services" => $services,
							"owner_name" => $this->input->post('owner_name'),
							"owner_surname" => $this->input->post('owner_surname'),
							"website" => $this->input->post('website'),
							"latitude" => $this->input->post('latitude'),
							"longitude" => $this->input->post('longitude'),
							"booking_cancel_hour"=>$this->input->post('booking_cancel_hour'),
							"is_active" =>$status,
						];


						$this->load->library('upload');

						if($_FILES['resort_image']['name']!='')
			            {
			                $configs['encrypt_name']    = TRUE;
			                $configs['upload_path']     = './uploads/resort_image';
			                $configs['allowed_types']   = '*';
			                	
			                $this->upload->initialize($configs);
			                if(!$this->upload->do_upload('resort_image'))
			        		{ 	
			        			$json['status']='error';
								$json['message']= strip_tags($this->upload->display_errors()) ;
								echo json_encode($json);
			        		}
			        		else
			    			{
			        			$resortimage = $this->upload->data('file_name');
			    			}	
			    		}
			    		else
			    		{
			    			$resortimage=NULL;
			    		}
						
						$data['resort_image']= $resortimage;


						$this->general_obj->insert_data($data,'elb_resort');
						$resort_id = $this->db->insert_id();

						if($resort_id > 0)
						{
							$timestamp = strtotime('next Monday');
			                $days = array();
			                for ($i = 0; $i < 7; $i++) {
			                    $days[] = strftime('%A', $timestamp);
			                    $timestamp = strtotime('+1 day', $timestamp);
			                }

			                foreach ($days as $key => $value)
			                {
			                	$timedata[]=array(
			                		'resort_id'=>$resort_id,
			                		'day'=>$value,
			                		'open_time'=>$this->input->post('open_time'),
			                		'close_time'=>$this->input->post('close_time'),
			                	);			
			                }

			                $this->general_obj->insert_all_data($timedata,'elb_resort_time');
						}

						$json['status']='success';
						echo json_encode($json);
					}
				}
			}
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}

	function edit_resort($resort_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['resort_id'] = $resort_id;
	 		
	 		$resortid = $this->encrypt->decode($resort_id);
	 		$data['resort'] = $this->general_obj->get_where_single(array('resort_id'=>$resortid),'elb_resort');

	 		$data['beachs'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_beach');
	 		$data['resortservice'] = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_resort_services');
	 		$this->load->view('admin/resort/edit_resort',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}



	function edit_save_resort()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{	

			$resort_id = $this->encrypt->decode($_POST['dataid']);

			$image1 = $this->input->post('image1');

			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$services = implode(',', $_POST['services']);


			if(empty($this->input->post('resort_open_date')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Open Date' ;
				echo json_encode($json);
			}
			else if(empty($this->input->post('resort_close_date')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Close Date' ;
				echo json_encode($json);
			}
			else if(empty($this->input->post('open_time')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Open Time' ;
				echo json_encode($json);
			}
			else if(empty($this->input->post('close_time')))
			{
				$json['status']='error';
				$json['message']= 'Please Select Resort Close Time' ;
				echo json_encode($json);
			}
			else
			{	

				$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$resort_id),'elb_resort');
				$resort_user_id = $resortinfo->user_id;

				$email_check = $this->general_obj->get_where(array('user_id!='=>$resort_user_id,'email'=>$_POST['email'],'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');
              
				if(!empty($email_check))  
				{	
					$json['status']='error';
					$json['message']= 'Email Already Exists' ;
					echo json_encode($json);
				}
				else
				{
					$phone_check = $this->general_obj->get_where(array('user_id!='=>$resort_user_id,'phone'=>$_POST['phone'],'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');

					if(!empty($phone_check))
					{
						$json['status']='error';
						$json['message']= 'Phone Number Already Exists' ;
						echo json_encode($json);
					}
					else
					{	

						$userdata=[
							'first_name'=>$_POST['owner_name'],
							'surname'=>$_POST['owner_surname'],
						];

						$this->general_obj->update_data($userdata,array('user_id'=>$resort_user_id),'elb_user');


						$data=[
							"beach_id" => $this->input->post('beach_id'),
							"resort_code" => $this->input->post('resort_code'),
							"resort_name" => $this->input->post('resort_name'),
							"address" => $this->input->post('address'),
							"city" => $this->input->post('city'),
							"zipcode" => $this->input->post('zipcode'),
							"description" => $this->input->post('description'),
							"description_en" => $this->input->post('description_en'),
							"resort_open_date" => $this->input->post('resort_open_date'),
							"resort_close_date" => $this->input->post('resort_close_date'),
							//"email" => $this->input->post('email'),
							//"phone" => $this->input->post('phone'),
							"company_name" => $this->input->post('company_name'),
							"services" => $services,
							"owner_name" => $this->input->post('owner_name'),
							"owner_surname" => $this->input->post('owner_surname'),
							"website" => $this->input->post('website'),
							"latitude" => $this->input->post('latitude'),
							"longitude" => $this->input->post('longitude'),
							"booking_cancel_hour"=>$this->input->post('booking_cancel_hour'),
							"is_active" =>$status,
						];


						$this->load->library('upload');

						if($_FILES['resort_image']['name']!='')
			            {
			                $configs['encrypt_name']    = TRUE;
			                $configs['upload_path']     = './uploads/resort_image';
			                $configs['allowed_types']   = '*';
			                	
			                $this->upload->initialize($configs);
			                if(!$this->upload->do_upload('resort_image'))
			        		{ 	
			        			$json['status']='error';
								$json['message']= strip_tags($this->upload->display_errors()) ;
								echo json_encode($json);
			        		}
			        		else
			    			{
			        			$resortimage = $this->upload->data('file_name');
			        			unlink("./uploads/resort_image/$image1");
			    			}	
			    		}
			    		else if($image1!=null)
			    		{
			    			$resortimage=$image1;
			    		}
			    		else
			    		{
			    			$resortimage=NULL;
			    		}
						
						$data['resort_image']= $resortimage;


						$where = array("resort_id" => $resort_id);
						$upd = $this->general_obj->update_data($data,$where,'elb_resort');

						if($upd > 0)
						{
		                	$timedata=array(
		                		'open_time'=>$this->input->post('open_time'),
		                		'close_time'=>$this->input->post('close_time'),
		                	);			
			               
		                	$where1 = array("resort_id" => $resort_id);
			                $this->general_obj->update_data($timedata,$where1,'elb_resort_time');
						}

						$json['status']='success';
						echo json_encode($json);
					}
				}
			}	
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}


	///////////////    resort images  //////////////////////////

	function edit_resort_image($resort_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['resort_id'] = $resort_id;
	 		$this->load->view('admin/resort/edit_resort_image',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function view_resort_image()
 	{
 		$resort_id = $this->encrypt->decode($_POST['resort_id']);

 		$resort_image = $this->general_obj->get_where(array('resort_id' => $resort_id),'elb_resort_image');
 		
 		foreach($resort_image as $img)
        { 
            $imagess = $img['image_name']; 

 		$output[]=' 

 			<li class="col-md-4">
                <div class="card">
                    <div class="card-header p-2">
                        <a href="javascript:void(0);" class="img-wrap">
                        	<span id="'.$img['image_id'].'" class="close" >&times;</span>
                            <img style="width:380px;height: 300px;" src="'.base_url('uploads/resort_image/').$imagess.'" alt=""> 
                        </a>
                    </div>
                </div>
            </li>';
         }
         
         echo json_encode($output);
    }


    function remove_image()
	{
  		$image_id = $_POST["row_id"];

  		$images = $this->general_obj->get_where_single(array('image_id' => $image_id),'elb_resort_image');
  		$image1 = $images->image;
  		unlink("./uploads/resort_image/$image1");

  		$this->db->where('image_id',$image_id);
		$this->db->delete('elb_resort_image');

		$resort_id = $this->encrypt->decode($_POST['resort_id']);

 		$resort_image = $this->general_obj->get_where(array('resort_id' => $resort_id),'elb_resort_image');

  		foreach($resort_image as $img)
        { 
            $imagess = $img['image_name']; 

 		$output[]=' 

 			<li class="col-md-4">
                <div class="card">
                    <div class="card-header p-2">
                        <a href="javascript:void(0);" class="img-wrap">
                        	<span id="'.$img['image_id'].'" class="close" >&times;</span>
                            <img style="width:380px;height: 300px;" src="'.base_url('uploads/resort_image/').$imagess.'" alt=""> 
                        </a>
                    </div>
                </div>
            </li>';
         }
         
         echo json_encode($output);
 	}


 	function add_save_resort_images()
 	{
 		$resort_id = $this->encrypt->decode($_POST['dataid']);

		$files = $_FILES;
        $images = array();
       	$cpt = count($_FILES['resort_images']['name']);
        
        if($cpt > 0)
        {
	        $config['encrypt_name']		= TRUE;
			$config['upload_path']		= './uploads/resort_image/';
			$config['allowed_types']	= 'jpg|jpeg|png';


			$this->load->library('upload', $config);
		    $this->upload->initialize($config);
	                
	        for($i=0; $i<$cpt; $i++)
			{           
			    $_FILES['image']['name']= $_FILES['resort_images']['name'][$i];
			    $_FILES['image']['type']= $_FILES['resort_images']['type'][$i];
			    $_FILES['image']['tmp_name']= $_FILES['resort_images']['tmp_name'][$i];
			    $_FILES['image']['error']= $_FILES['resort_images']['error'][$i];
			    $_FILES['image']['size']= $_FILES['resort_images']['size'][$i];    

			    if($this->upload->do_upload('image'))
	            {
	                $data = $this->upload->data();
	                $images=$data["file_name"];
	            }
	            else
	            {
	                $images='';
	            }
	         
            	$resort_imagedata[] = array(
					'resort_id' => $resort_id,
					'image_name' => $images
				);
			}

	        $uids = $this->general_obj->insert_all_data($resort_imagedata,'elb_resort_image');

	        if($uids > 0)
			{
				$json['status']='success';
				$json['message']= 'Images Added Successfully.' ;
				echo json_encode($json);
			}
			else
			{
				$json['status']='error';
				$json['message']= 'Images Not Added. Somthing As Worng!' ;
				echo json_encode($json);
			}
		}
		else
		{
			$json['status']='error';
			$json['message']= 'Please Select Images' ;
			echo json_encode($json);
		}
 	}



 	/////////////////     resort servicesss module //////////////////////////////////


 	function resort_service()
 	{
 		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/resort/service/list_resort_service');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
 	}


 	function fetch_resortservice_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$service = $this->general_obj->get_where(array('is_delete'=>'0'),'elb_resort_services');

			$data = array();
        	$i=1;
        	foreach($service as $row)
        	{	
        		$status = ($row['is_active'] == "1") ? "<span class='badge outline-badge-success'>Enable</span>" : "<span class='badge outline-badge-danger'>Disable</span>"; 


        		$service_id = $this->encrypt->encode($row['service_id']);



        		$sub_array = array();
 				$sub_array[] = $i;
 				$sub_array[] = $row['service_name_en'];
 				$sub_array[] = $row['service_name_it'];
 				$sub_array[] = $status;
 				$sub_array[] = date('d-M-Y H:i A',strtotime($row['created_at']));
 				$sub_array[] = '
 				<a href="'.base_url('admin/Resorts/edit_resortservice/').$service_id.'"><i class="far fa-edit"></i></a>
 				&nbsp;&nbsp;
 				<a href="javascript:void(0);"  class="delete" id="'.$service_id.'"><i class="far fa-trash-alt"></i></a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function delete_resortservice()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$service_id = $this->encrypt->decode($_POST['id']);

 			$data=array(
 				'is_delete'=>'1',
 				'is_active' => '0'
 			);

	 		$this->db->where('service_id',$service_id);
	 		$this->db->update('elb_resort_services',$data);

	 		echo 'Service Deleted Successfully.';
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_resortservice()
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$this->load->view('admin/resort/service/add_resort_service');
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function add_save_resortservice()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			
			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$data=[
				"service_name_en" => $this->input->post('service_name_en'),
				"service_name_it" => $this->input->post('service_name_it'),
				"is_active" =>$status,
			];


			$this->load->library('upload');

			if($_FILES['service_image']['name']!='')
            {
                $configs['encrypt_name']    = TRUE;
                $configs['upload_path']     = './uploads/service_image';
                $configs['allowed_types']   = '*';
                	
                $this->upload->initialize($configs);
                if(!$this->upload->do_upload('service_image'))
        		{ 	
        			$json['status']='error';
					$json['message']= strip_tags($this->upload->display_errors()) ;
					echo json_encode($json);
        		}
        		else
    			{
        			$serviceimage = $this->upload->data('file_name');
    			}	
    		}
    		else
    		{
    			$serviceimage=NULL;
    		}
				
			$data['service_image']= $serviceimage;


			$this->general_obj->insert_data($data,'elb_resort_services');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}


	function edit_resortservice($service_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['service_id'] = $service_id;
	 		
	 		$serviceid = $this->encrypt->decode($service_id);
	 		$data['service'] = $this->general_obj->get_where_single(array('service_id'=>$serviceid),'elb_resort_services');

	 		$this->load->view('admin/resort/service/edit_resort_service',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}


	function edit_save_resortservice()
	{	
		if ($this->session->userdata('logged_in_elba'))
		{
			$service_id = $this->encrypt->decode($_POST['dataid']);

			$image1 = $this->input->post('image1');	


			if(!empty($this->input->post('is_active')))
			{
				$status = $this->input->post('is_active');
			}
			else
			{
				$status = '0';
			}

			$data=[
				"service_name_en" => $this->input->post('service_name_en'),
				"service_name_it" => $this->input->post('service_name_it'),
				"is_active" =>$status,
			];


			$this->load->library('upload');

			if($_FILES['service_image']['name']!='')
            {
                $configs['encrypt_name']    = TRUE;
                $configs['upload_path']     = './uploads/service_image';
                $configs['allowed_types']   = '*';
                	
                $this->upload->initialize($configs);
                if(!$this->upload->do_upload('service_image'))
        		{ 	
        			$json['status']='error';
					$json['message']= strip_tags($this->upload->display_errors()) ;
					echo json_encode($json);
        		}
        		else
    			{
        			$serviceimage = $this->upload->data('file_name');
        			unlink("./uploads/service_image/$image1");
    			}	
    		}
    		else if($image1!=null)
    		{
    			$serviceimage=$image1;
    		}
    		else
    		{
    			$serviceimage=NULL;
    		}
				
			$data['service_image']= $serviceimage;


			$where = array("service_id" => $service_id);
			$this->general_obj->update_data($data,$where,'elb_resort_services');
			$json['status']='success';
			echo json_encode($json);
		}
		else
		{
			redirect('admin/Login','refresh');
		}
	}


	function update_payment_mode()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$resort_id = $this->encrypt->decode($_POST['resort_id']);

 			$data=array(
 				'app_payment_mode' => $_POST['app_payment_mode'],
				'web_payment_mode' => $_POST['web_payment_mode']
 			);

	 		$this->db->where('resort_id',$resort_id);
	 		$upd = $this->db->update('elb_resort',$data);

	 		if($upd > 0)
	 		{
	 			$json['status']='success';
				echo json_encode($json);
 			}
 			else
 			{
 				$json['status']='error';
 				$json['message']='Payment mode Not Change ,Please Try Again';
				echo json_encode($json);
 			}
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}



	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	function resort_owner()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
 			$this->load->view('admin/resort/list_resort_owner');
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function fetch_resort_owner_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{
			$resort = $this->general_obj->get_where(array('is_delete'=>'0'),'elb_resort');

			$data = array();
        	$i=1;
        	foreach($resort as $row)
        	{	
        		$userinfo  = $this->general_obj->get_where_single(array('user_id'=>$row['user_id']),'elb_user');
        		
        		$resort_id = $this->encrypt->encode($row['resort_id']);


        		$ownerinfo = '<b>'.$userinfo->first_name.' '.$userinfo->surname.'</b></br>
                              <p>'.$userinfo->email.'</p>
                              <p>'.$userinfo->phone.'</p>
        					 ';


        		$sub_array = array();
 				$sub_array[] = $i;
 				$sub_array[] = $row['resort_code'];
 				$sub_array[] = $row['resort_name'];
 				$sub_array[] = $ownerinfo;
 				$sub_array[] = '
 				<a href="javascript:void(0);"  data-id="'.$row['resort_name'].'" class="changepassword  btn btn-sm btn-info" id="'.$resort_id.'">Change Password</a>
 				';
 				$data[] = $sub_array;

        		$i++; 
        	}
        	$output = array(
 				"data"=> $data
			);

         	echo json_encode($output);
		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}


	function change_password()
 	{
 		$resort_id = $this->encrypt->decode($_POST['resort_id']);

 		$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$resort_id),'elb_resort');


 		if($_POST['password']==$_POST['conf_password'])
 		{
 			$upddata = array(
 				'password'=>md5($_POST['password']),
 			);

 			$this->general_obj->update_data($upddata,array('user_id'=>$resortinfo->user_id),'elb_user');

 			$json['status']='success';
 			echo json_encode($json);
 		}
 		else
 		{
 			$json['status']='error';
			$json['message']= 'Password And Confirm Password Does Not Match' ;
			echo json_encode($json);
 		}
    }

	
}


