<?php
class User extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/General_model','general_obj');
	}

	function index()
	{
		
		if ($this->session->userdata('logged_in_elba')) 
 		{
			
			$this->load->view('admin/template/header');
 			$this->load->view('admin/user/list_user');
			$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function fetch_user_data()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	

 			$page = $_POST['page'];

 			$start = 10 * $page;
			$first_name = $_POST['first_name'];

			// $user = $this->general_obj->get_where(array('user_type'=>'user','is_delete'=>'0'),'elb_user');

 			if ($first_name != '') 
 			{	
 				
 				$user = $this->general_obj->get_where_with_order_by_like_limit(array('user_type'=>'user','is_delete'=>'0'),array('first_name'=>$first_name),'user_id','desc','10',$start,'elb_user');

 			}
 			else
 			{	
 				$user = $this->general_obj->get_where_with_order_by_limt(array('user_type'=>'user','is_delete'=>'0'),'user_id','desc','10',$start,'elb_user');	
 			}	

			//print_r($user); exit();

			$output = '';

        	$i=$start+1;
        	
        	if (!empty($user)) {

	        	foreach($user as $row)
	        	{	

	        		

	        		$status = ($row['email_verify'] == "1") ? "<div id='st_".$row['user_id']."' data-id='".$row['user_id']."'><span class='badge outline-badge-success'>Verify</span></div>" : "<div id='st_".$row['user_id']."' data-id='".$row['user_id']."'><span class='badge outline-badge-danger'>UnVerify</span></div>"; 


	        		$user_id = my_encrypt($row['user_id']);

	        		if($row['profile_image']!=null)
					{
						$profile_image = base_url('uploads/user_image/').$row['profile_image'];
					}
					else
					{
						$profile_image = base_url('uploads/user.png');
					}


					if($row['email_verify']=='0')
					{
						$btn = '<div id="sts_'.$row['user_id'].'"><a href="javascript:void(0);" class="useractive btn btn-sm btn-success" data-id="'.$row['user_id'].'" id="'.$user_id.'">Verify User</a></div>';
					}
					else
					{
						$btn = '';
					}


					$btns = '<div id="stss_'.$row['user_id'].'" style="display:none;"><span style="color:red;">User Not Verifed Plase Try Again.</span></div>';


					$output .='<tr>
						<td>'.$i.'</td>
						<td><span><img style="width:50px;height:50px;;" src="'.$profile_image.'" class="rounded-circle profile-img" alt="avatar"></span></td>
						<td>'.$row['first_name'].' '.$row['surname'].'</td>
						<td>'.$row['email'].'</td>
						<td>'.$row['phone'].'</td>
						<td>'.$status.'</td>
						<td>'.date('d-M-Y H:i A',strtotime($row['created_at'])).'</td>
						<td><a href="'.base_url('admin/User/user_detail/').$user_id.'"><i class="far fa-eye"></i></a>
	 				<br><br>
	 				'.$btn.'<br>'.$btns.'</td>
					</tr>';


	        		$i++; 
	        	}
	        	
	        }
	        else
			{
				$output .= '';
			}

			$data['page'] = $page +1 ;
			$data['response'] = $output;
			echo json_encode($data);

		}
	 	else
	 	{
	 		redirect('admin/Login','refresh');
	 	}
	}

	function user_detail($user_id)
	{
		if ($this->session->userdata('logged_in_elba')) 
 		{
	 		$this->load->view('admin/template/header');
	 		$data['user_id'] = $user_id;
	 		
	 		$userid = my_decrypt($user_id);
	 		$data['user'] = $this->general_obj->get_where_single(array('user_id'=>$userid),'elb_user');
	 		$this->load->view('admin/user/user_detail',$data);
	 		$this->load->view('admin/template/footer');
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}



	function exportcsv() 
	{
        $now = date('d-m-Y_H-i-s'); 
	    $filename = 'userlist_'.$now.'.csv'; 
        header("Content-Description: File Transfer"); 
        header("Content-Disposition: attachment; filename=$filename"); 
        header("Content-Type: application/csv; ");
	    
	    // get data 
	   
	   	$data = $this->general_obj->get_where(array('user_type'=>'user','is_delete'=>'0'),'elb_user');
	   
	    // file creation 
	    $files = fopen('php://output', 'w');
	    $header = array("NO","USER ID","FIRST NAME","SURNAME","EMAIL","PHONE","BIRTH DATE","AGE","DOCUMENT UPLOAD","EMAIL VERIFY","STATUS","ADDED ON");
	    fputcsv($files, $header);
            
        $i=1;
        foreach ($data as $row) 
        {
            $user_id=$row['user_id'];
            $first_name=$row['first_name'];
            $surname=$row['surname'];
            $email=$row['email'];
            $phone=$row['phone'];
            $birth_date=$row['birth_date'];
            $age=$row['age'];
            $upload_document=$row['upload_document'];
            $email_verify=$row['email_verify'];
            $is_active=$row['is_active'];
            $created_at=$row['created_at'];

            if ($upload_document == '1') 
            {
                $upload_documents = "Upload";
            }   
            else
            {
                $upload_documents = "Not Upload";
            }


            if ($email_verify == '1') 
            {
                $email_verifys = "Verify";
            }   
            else
            {
                $email_verifys = "UnVerify";
            }


            if ($is_active == '1') 
            {
                $is_actives = "Active";
            }   
            else
            {
                $is_actives = "In Active";
            }
            

            $csv = array($i,$user_id,$first_name,$surname,$email,$phone,$birth_date,$age,$upload_documents,$email_verifys,$is_actives,$created_at);
            fputcsv($files, $csv);
        

        	$i++;    
        }
        fclose($file,$files);
        exit;
	}
	


	function active_user()
	{	
		if ($this->session->userdata('logged_in_elba')) 
 		{	
 			$user_id = my_decrypt($_POST['id']);

 			$data=array(
 				'email_verify'=>'1',
 				'phone_verify' => '1'
 			);

	 		$this->db->where('user_id',$user_id);
	 		$upd = $this->db->update('elb_user',$data);

	 		if($upd > 0)
	 		{
	 			echo '1';
	 		}
	 		else
	 		{
	 			echo '0';
	 		}
	 		
 		}
	 	else
	 	{
 			redirect('admin/Login','refresh');
	 	}
	}




}


