<?php
header('Content-Type: application/json');
class Api extends CI_Controller
{  
	function __construct()   
	{
		parent::__construct();
		$this->load->model('admin/v2/General_model','general_obj');
		$this->load->library('pagination');
		
		$CI =&get_instance();
        				
       	$maintenance = $this->db->where('status','y')->where('setting_type','resort_maintenance')->get('elb_settings')->result_array();
		        
		
       	if(!empty($maintenance))
		{	
			$data = array(
				'message_en'=> "App is under Maintenance.", 
				'message_it'=>  "L'app è in manutenzione."
			);	

			$json =  array("status" => 2,"message"=>'Maintenance',"response"=>$data);
			echo json_encode($json);
			exit;
		}
		
	}


	function send_mail($email,$message,$subject)
	{	
		$mailjetApiKey = '6d15b1a801e0d06f31a74d0539a17d30';
		$mailjetApiSecret = '6d87c96aa36df0128afb69aa9d594a42';
		$messageData = [
		    'Messages' => [
		        [
		            'From' => [
		                'Email' => 'info@elbabeaches.com',
		                'Name' => 'Elba Beaches'
		            ],
		            'To' => [
		                [
		                    'Email' => $email,
		                    /*'Name' => 'to name'*/
		                ]
		            ],
		            'Subject' => $subject,
		            /*'TextPart' => 'Mailjet test body email message',*/
		            'HTMLPart' => $message
		        ]
		    ]
		]; 
		$jsonData = json_encode($messageData);
		$ch = curl_init('https://api.mailjet.com/v3.1/send');
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
		curl_setopt($ch, CURLOPT_USERPWD, "{$mailjetApiKey}:{$mailjetApiSecret}");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
		    'Content-Type: application/json',
		    'Content-Length: ' . strlen($jsonData)
		]);
		$response = json_decode(curl_exec($ch));
		/*var_dump($response);*/
	    //print_r($result);exit;
	    curl_close($ch);
	}


	function send_notification($title,$message,$fcm_token,$type,$count,$booking_id)
	{	
	
		$serverKey = "AAAA_tDpYbM:APA91bHdKIShSVrDb-T4wWCQKKXMhhrQkEz4Xk9XVOMOzJTrZPWuiAex81EUKiOyfGul1mZKNuMlKh2oGp1c1crh6yIKfLC3iUjaK_vK3-uU58B8qn4irkROKzexI-JvacP8hTR6T2RO";


		$fields = array(
			
			"registration_ids" => $fcm_token, 
			
			"notification" => array(
				"body" => $message,
				"title" => $title,
				"content_available" => true,
				'type' => $type,
				"priority" => "high",
				'vibrate' => true,
				'badge' => $count,
				'sound' => "default",
				'booking_id' => $booking_id
			),
		
			"data" => array(
				"body" => $message,
				"title" => $title,
				"content_available" => true,
				'type' => $type,
				"priority" => "high",
				'badge' => $count,
				'booking_id' => $booking_id
			)
		);

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Authorization: key='. $serverKey;
		$ch = curl_init();
		curl_setopt( $ch,CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send' );
		curl_setopt( $ch,CURLOPT_POST, true );
		curl_setopt( $ch,CURLOPT_HTTPHEADER, $headers );
		curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );
		curl_setopt( $ch,CURLOPT_POSTFIELDS, json_encode( $fields ) );
		$response = curl_exec($ch);
		curl_close($ch);
	}




	function check_maintenance()
	{ 
		$maintenance = $this->db->where('status','y')->where('setting_type','resort_maintenance')->get('elb_settings')->result_array();
		        
		if(!empty($maintenance))  
		{	
			$data = array(
				'message_en'=> "App is under Maintenance.", 
				'message_it'=>  "L'app è in manutenzione."
			);	

			$json =  array("status" => 2,"message"=>'Maintenance',"response"=>$data);
		}
		else
		{   
			$json =  array("status" => 1,"message"=>"App IS Successfully Run");
		}

	    echo json_encode($json);
    }


	function resort_register()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('first_name', 'first_name', 'required');
		    $this->form_validation->set_rules('surname', 'surname', 'required');
		    $this->form_validation->set_rules('email', 'email', 'required');
		    $this->form_validation->set_rules('phone', 'phone', 'required');
		    $this->form_validation->set_rules('password', 'password', 'required');

		    $this->form_validation->set_rules('device_id', 'device_id', 'required');
		    $this->form_validation->set_rules('device_type', 'device_type', 'required');
		    $this->form_validation->set_rules('fcm_token', 'fcm_token', 'required');

		 	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$device_id = $_POST['device_id'];
		        $device_type = $_POST['device_type'];
		        //$fcm_token = $_POST['fcm_token'];

		        
		        if($_POST['fcm_token']=='iosTest')
	        	{
	        		$fcm_token = NULL;
	        	}
	        	else
	        	{
	        		$fcm_token = $_POST['fcm_token'];
	        	}



		        $email_check = $this->general_obj->get_where(array('email'=>$_POST['email'],'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');
              
				if(!empty($email_check))  
				{	
					$json =  array("status" => 0,"message"=>"Email Already Exists");
				}
				else
				{
					$phone_check = $this->general_obj->get_where(array('phone'=>$_POST['phone'],'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');	

					if(!empty($phone_check))
					{
						$json =  array("status" => 0,"message"=>"Phone Number Already Exists");
					}
					else
					{	
						//$email_otp =  rand(100000, 999999);  	
						$email_otp =  "123456";  	
						
						$data=[
							'user_type'=>'resort',
							'first_name'=>$_POST['first_name'],
							'surname'=>$_POST['surname'],
							'email'=>$_POST['email'],
							'phone'=>$_POST['phone'],
							'password'=>md5($_POST['password']),
							'email_otp'=>$email_otp,
							'email_verify'=> '1'
						];

						
						$this->general_obj->insert_data($data,'elb_user');
						$user_id = $this->db->insert_id();

						if($user_id > 0)
						{	
							$email = $_POST['email'];
							$subject    = "ElbaBeaches";
							//$message = "OTP Is  = ' ".$email_otp." '";

							$maildata['full_name'] = $_POST['first_name'].' '.$_POST['surname'];
							$maildata['otp'] = $email_otp;

							$message = $this->load->view('otp_verify_mail',$maildata,true);

							//$this->send_mail($email,$message,$subject);


							$usercheck = $this->general_obj->get_where(array('user_id' => $user_id,'is_active'=>'1','is_delete'=>'0'),'elb_user');
		        			array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});

		        			$user_type = $usercheck[0]['user_type'];

							$loginuser = $this->general_obj->get_where_single(array('device_id'=>$device_id),'elb_login');

							$now = date('Y-m-d H:i:s');

							if(!empty($loginuser))
							{
								$logindata = array(
									'user_id'=>$usercheck[0]['user_id'],
									'user_type'=>$user_type,
									'device_id'=>$device_id,
									'device_type'=>$device_type,
									'fcm_token'=>$fcm_token,
									'created_at'=>$now
								);

								$where = array("login_id" => $loginuser->login_id);
								$insert = $this->general_obj->update_data($logindata,$where,'elb_login');
								$loginid = $loginuser->login_id;
							}
							else
							{
								$logindata = array(
									'user_id'=>$usercheck[0]['user_id'],
									'user_type'=>$user_type,
									'device_id'=>$device_id,
									'device_type'=>$device_type,
									'fcm_token'=>$fcm_token
								);

								$insert =  $this->general_obj->insert_data($logindata,'elb_login');
								$loginid = $this->db->insert_id();
							}
							
							$login = $this->general_obj->get_where_single(array('login_id'=>$loginid),'elb_login');

							$checkresort_add = $this->general_obj->get_where(array('user_id'=>$usercheck[0]['user_id']),'elb_resort');

							if(!empty($checkresort_add))
							{
								$resortadd = '1';
								$resort_id = $checkresort_add[0]['resort_id'];

								$checkpackage_add = $this->general_obj->get_where(array('resort_id'=>$checkresort_add[0]['resort_id'],'is_active'=>'1','is_delete'=>'0'),'elb_package');
								
								if(!empty($checkpackage_add))
								{	
									$packageadd = '1';	
								}
								else
								{
									$packageadd = '0';
								}
							}
							else
							{
								$resortadd = '0';
								$resort_id ='';
								$packageadd = '0';
							}

																			
							$logdata = array(
					    		'login_id'=>$login->login_id,
					    		'device_id'=>$login->device_id,
					    		'device_type'=>$login->device_type,
					    		'fcm_token'=>$login->fcm_token,
					    		'user_id'=>$usercheck[0]['user_id'],
					    		'resort_id'=>$resort_id,
					    		'login_type'=>$usercheck[0]['login_type'],
					    		'user_type'=>$usercheck[0]['user_type'],
					    		'first_name'=>$usercheck[0]['first_name'],
					    		'surname'=>$usercheck[0]['surname'],
				    			'email'=>$usercheck[0]['email'],
				    			'phone'=>$usercheck[0]['phone'],
				    			'email_otp'=>$usercheck[0]['email_otp'],
				    			'email_verify'=>$usercheck[0]['email_verify'],
				    			'phone_verify'=>$usercheck[0]['phone_verify'],
				    			'is_active'=>$usercheck[0]['is_active'],
				    			'is_delete'=>$usercheck[0]['is_delete'],
				    			'created_at'=>$usercheck[0]['created_at'],
				    			'resort_add'=>$resortadd,
				    			'package_add'=>$packageadd
				    		);	

				    		$data2_obj = (object)$logdata;

							$json = array("status" => 1,"message" => "Resort Register Successfully","response"=>$data2_obj);
						}
						else
						{
							$json =  array("status" => 0,"message"=>"User Not Register , Somthing Wrong , Please Try Again.");
						}
					}
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function login()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('email', 'email', 'required');	
			$this->form_validation->set_rules('password', 'password', 'required');
				
			$this->form_validation->set_rules('device_id', 'device_id', 'required');
			$this->form_validation->set_rules('device_type', 'device_type', 'required');
			$this->form_validation->set_rules('fcm_token', 'fcm_token', 'required');
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $email = $_POST['email'];
		        $password = md5($_POST['password']);

		        $device_id = $_POST['device_id'];
		        $device_type = $_POST['device_type'];
		        //$fcm_token = $_POST['fcm_token'];


		        if($_POST['fcm_token']=='iosTest')
	        	{
	        		$fcm_token = NULL;
	        	}
	        	else
	        	{
	        		$fcm_token = $_POST['fcm_token'];
	        	}



		        $userchecks = $this->general_obj->get_where(array('email' => $email,'password'=>$password,'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');
		        array_walk_recursive($userchecks,function(&$userchecks){$userchecks=strval($userchecks);});

		        if(!empty($userchecks))
		        {
			        $email_verify = $userchecks[0]['email_verify'];

					if($email_verify=='0')
					{	
						#$email_otp =  rand(100000, 999999);
						$email_otp =  "123456";

						$email = $userchecks[0]['email'];
						$subject    = "ElbaBeaches";
						//$message = "OTP Is  = ' ".$email_otp." '";

						$maildata['full_name'] = $usercheck[0]['first_name'].' '.$usercheck[0]['surname'];
						$maildata['otp'] = $email_otp;

						$message = $this->load->view('otp_verify_mail',$maildata,true);

						$this->send_mail($email,$message,$subject);

						$emaildata =array(
							'email_otp'=>$email_otp,
						);

						$this->general_obj->update_data($emaildata,array('user_id'=>$userchecks[0]['user_id']),'elb_user');
					}
				}


		        $usercheck = $this->general_obj->get_where(array('email' => $email,'password'=>$password,'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});
              
				if(!empty($usercheck))  
				{	
					$user_type = $usercheck[0]['user_type'];


					$loginuser = $this->general_obj->get_where_single(array('device_id'=>$device_id),'elb_login');

					$now = date('Y-m-d H:i:s');

					if(!empty($loginuser))
					{
						$logindata = array(
							'user_id'=>$usercheck[0]['user_id'],
							'user_type'=>$user_type,
							'device_id'=>$device_id,
							'device_type'=>$device_type,
							'fcm_token'=>$fcm_token,
							'created_at'=>$now
						);

						$where = array("login_id" => $loginuser->login_id);
						$insert = $this->general_obj->update_data($logindata,$where,'elb_login');
						$loginid = $loginuser->login_id;
					}
					else
					{	
						$logindata = array(
							'user_id'=>$usercheck[0]['user_id'],
							'user_type'=>$user_type,
							'device_id'=>$device_id,
							'device_type'=>$device_type,
							'fcm_token'=>$fcm_token
						);

						$insert =  $this->general_obj->insert_data($logindata,'elb_login');
						$loginid = $this->db->insert_id();
					}
			
					if($insert > 0 )
					{
						$login = $this->general_obj->get_where_single(array('login_id'=>$loginid),'elb_login');

						$checkresort_add = $this->general_obj->get_where(array('user_id'=>$usercheck[0]['user_id']),'elb_resort');

						if(!empty($checkresort_add))
						{
							$resortadd = '1';
							$resort_id = $checkresort_add[0]['resort_id'];

							$checkpackage_add = $this->general_obj->get_where(array('resort_id'=>$checkresort_add[0]['resort_id'],'is_active'=>'1','is_delete'=>'0'),'elb_package');
								
							if(!empty($checkpackage_add))
							{	
								$packageadd = '1';	
							}
							else
							{
								$packageadd = '0';
							}

						}
						else
						{
							$resortadd = '0';
							$resort_id ='';
							$packageadd = '0';
						}

						$logdata = array(
				    		'login_id'=>$login->login_id,
				    		'device_id'=>$login->device_id,
				    		'device_type'=>$login->device_type,
				    		'fcm_token'=>$login->fcm_token,
				    		'user_id'=>$usercheck[0]['user_id'],
				    		'resort_id'=>$resort_id,
				    		'login_type'=>$usercheck[0]['login_type'],
				    		'user_type'=>$usercheck[0]['user_type'],
				    		'first_name'=>$usercheck[0]['first_name'],
				    		'surname'=>$usercheck[0]['surname'],
			    			'email'=>$usercheck[0]['email'],
			    			'phone'=>$usercheck[0]['phone'],
			    			'email_otp'=>$usercheck[0]['email_otp'],	
			    			'email_verify'=>$usercheck[0]['email_verify'],
			    			'phone_verify'=>$usercheck[0]['phone_verify'],
			    			'is_active'=>$usercheck[0]['is_active'],
			    			'is_delete'=>$usercheck[0]['is_delete'],
			    			'created_at'=>$usercheck[0]['created_at'],
			    			'resort_add'=>$resortadd,
			    			'package_add'=>$packageadd

			    		);	

			    		$data2_obj = (object)$logdata;
				
						$json = array("status" => 1,"message" => "Login Successfully","response" => $data2_obj);	
					}
					else
					{
						$json =  array("status" => 0,"message"=>"Token Detail Not Add");
					}
					
				}
				else
				{   
					$json =  array("status" => 0,"message"=>"Invalid Email And Password");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function logout()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('login_id', 'login_id', 'required');	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $login_id = $_POST['login_id'];
		    	
		        $usercheck = $this->general_obj->get_where_single(array('login_id'=>$login_id),'elb_login');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});
              
				/*if(!empty($usercheck))  
				{*/	
					$this->db->where('login_id',$login_id);
					$this->db->delete('elb_login');

					/*$userdata= $this->general_obj->get_where_single(array('login_id'=>$login_id),'elb_login');

					if(empty($userdata))
					{*/
						$json = array("status" => 1,"message" => "Logout Successfully");	
					/*}
					else
					{
						$json =  array("status" => 0,"message"=>"Not Logout , Somthing Wrong , Please Try Again.");
					}
				}
				else
				{   
					$json =  array("status" => 0,"message"=>"Data Not Found");
				}*/
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function resort_detail_by_id()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $user_id = $_POST['user_id'];
		        
		        $usercheck = $this->general_obj->get_where(array('user_id' => $user_id,'is_active'=>'1','is_delete'=>'0'),'elb_user');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});


				if(!empty($usercheck))  
				{	
					$resortinfo = $this->general_obj->get_where(array('user_id'=>$usercheck[0]['user_id']),'elb_resort');
					array_walk_recursive($resortinfo,function(&$resortinfo){$resortinfo=strval($resortinfo);});

					if(empty($resortinfo))
					{
						$data2_obj = (object)[];
						$json =  array("status" => 0,"message"=>"Resort Detail","response" => $data2_obj);
					}
					else
					{
						if($resortinfo[0]['resort_image']!=null)
						{
							$resort_image = base_url('uploads/resort_image/').$resortinfo[0]['resort_image'];
						}
						else
						{
							$resort_image = '';
						}

						$beachinfo = $this->general_obj->get_where_single(array('beach_id'=>$resortinfo[0]['beach_id']),'elb_beach');

						$todaydate = date('Y-m-d');														
						$day = date('l',strtotime($from_date));
						
						$resorttimeget = $this->general_obj->get_where_single(array('resort_id'=>$resortinfo[0]['resort_id'],'day'=>$day),'elb_resort_time'); 
						$open_time = $resorttimeget->open_time;
						$close_time = $resorttimeget->close_time;


						$otherimages = $this->general_obj->get_where(array('resort_id'=>$resortinfo[0]['resort_id']),'elb_resort_image');

						foreach ($otherimages as $key1 => $value1)
						{	
							if($value1['image_name']!=null)
							{
								$otherimages[$key1]['image_name'] = base_url('uploads/resort_image/').$value1['image_name'];
							}
							else
							{
								$otherimages[$key1]['image_name'] = '';
							}						
						}

						$service_ids = explode(',', $resortinfo[0]['services']);

						$services = $this->general_obj->get_where_in('service_id',$service_ids,'elb_resort_services');

						foreach ($services as $key2 => $value2)
						{
							if($value2['service_image']!=null)
							{
								$services[$key2]['service_image'] = base_url('uploads/service_image/').$value2['service_image'];
							}
							else
							{
								$services[$key2]['service_image'] = '';
							}
						}


						$data = array(
							'resort_id'=>$resortinfo[0]['resort_id'],
				    		'user_id'=>$resortinfo[0]['user_id'],
				    		'beach_id'=>$resortinfo[0]['beach_id'],
							'beach_name'=>$beachinfo->beach_name,
							'resort_code'=>$resortinfo[0]['resort_code'],
				    		'resort_name'=>$resortinfo[0]['resort_name'],
				    		'resort_image'=>$resort_image,
				    		'address'=>$resortinfo[0]['address'],
			    			'city'=>$resortinfo[0]['city'],
			    			'zipcode'=>$resortinfo[0]['zipcode'],
			    			'description'=>$resortinfo[0]['description'],
			    			'description_en'=>$resortinfo[0]['description_en'],
			    			'resort_open_date'=>$resortinfo[0]['resort_open_date'],
			    			'resort_close_date'=>$resortinfo[0]['resort_close_date'],
			    			'resort_open_time'=>$open_time,
							'resort_close_time'=>$close_time,
			    			'email'=>$resortinfo[0]['email'],
			    			'phone'=>$resortinfo[0]['phone'],
			    			'company_name'=>$resortinfo[0]['company_name'],
			    			'services'=>$resortinfo[0]['services'],
			    			'package_service'=>$resortinfo[0]['package_service'],
			    			'owner_name'=>$resortinfo[0]['owner_name'],
			    			'owner_surname'=>$resortinfo[0]['owner_surname'],
			    			'bank_name'=>$resortinfo[0]['bank_name'],
			    			'iban'=>$resortinfo[0]['iban'],
			    			'vat_number'=>$resortinfo[0]['vat_number'],
			    			'sdi_code'=>$resortinfo[0]['sdi_code'],
			    			'website'=>$resortinfo[0]['website'],
			    			'latitude'=>$resortinfo[0]['latitude'],
			    			'longitude'=>$resortinfo[0]['longitude'],
			    			'is_active'=>$resortinfo[0]['is_active'],
			    			'is_delete'=>$resortinfo[0]['is_delete'],
			    			'created_at'=>$resortinfo[0]['created_at'],
			    			'otherimages'=>$otherimages,
							'services_list'=>$services,
					    );	
		
						$data2_obj = (object)$data;
							
						$json = array("status" => 1,"message" => "Resort Detail","response" => $data2_obj);	
					}
				}
				else
				{	
					$data2_obj = (object)[];
					$json =  array("status" => 0,"message"=>"Resort Detail","response" => $data2_obj);
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function change_resort_profile_image()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');	
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	

				$user_id=$_POST['user_id'];
		    	
		    	$resortinfo = $this->general_obj->get_where_single(array('user_id'=>$user_id),'elb_resort');
		        $image1 = $resortinfo->resort_image;
				
				$this->load->library('upload');

				if($_FILES['resort_image']['name']!='')
	            {
	                $configs['encrypt_name']    = TRUE;
	                $configs['upload_path']     = './uploads/resort_image';
	                $configs['allowed_types']   = '*';
	                	
	                $this->upload->initialize($configs);
	                if(!$this->upload->do_upload('resort_image'))
	        		{ 
	            		$json = array("status" => 0,"message" => strip_tags($this->upload->display_errors()));
	        		}
	        		else
        			{
            			$resort_image = $this->upload->data('file_name');
            			unlink("./uploads/resort_image/$image1");
        			}	
        		}
        		else if($image1!=null)
            	{
            		$resort_image = $image1;
            	}
        		else
        		{
        			$resort_image=NULL;
        		}

        		$data=array(
            		'resort_image'=>$resort_image,
            	); 

        		$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_resort');

				if($upd > 0)
				{	
					if($resort_image!=null)
					{
						$images = base_url('uploads/resort_image/').$resort_image;
					}
					else
					{
						$images = '';
					}

					$json = array("status" => 1,"message" => "Resort Image Changed Successfully","response"=>$images);
				}
				else
				{
					$json = array("status" => 0,"message" => "Resort Image Not Changed");
				}			
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }

    
    function change_password()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			$this->form_validation->set_rules('old_password', 'old_password', 'required');
			$this->form_validation->set_rules('new_password', 'new_password', 'required');
			$this->form_validation->set_rules('conf_password', 'conf_password', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$user_id = $_POST['user_id'];

				$result = $this->general_obj->get_where_single(array('user_id'=>$user_id),'elb_user');

				if(md5($_POST['old_password'])==$result->password)
				{
					if($_POST['new_password']==$_POST['conf_password'])
					{				
	    				$data=array(
	    					'password'=>md5($_POST['new_password']),	
	    				);

	    				$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_user');

						if($upd > 0)
						{
							$json = array("status" => 1,"message" => "Password Changed Successfully");
						}
						else
						{
							$json = array("status" => 0,"message" => "Password Not Changed");
						}		
					}
					else
					{
						$json = array("status" => 0,"message" => "New Password & Confirm Password Not Match.");
					}
				}
				else
				{
					$json = array("status" => 0,"message" => "Old Password Is not Correct.");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    } 

    
    function email_resend_otp()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('email', 'email', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$email_otp =  rand(100000, 999999);

				$email = $_POST['email'];

				$userinfo = $this->general_obj->get_where_single(array('email'=>$email,'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');

				if(!empty($userinfo))
				{
					$subject    = "ElbaBeaches";
					//$message = "OTP Is  = ' ".$email_otp." '";

					$maildata['full_name'] = $userinfo->first_name.' '.$userinfo->surname;
					$maildata['otp'] = $email_otp;

					$message = $this->load->view('otp_verify_mail',$maildata,true);


					$this->send_mail($email,$message,$subject);

					$data =array(
						'email_otp'=>$email_otp,
					);

					$this->general_obj->update_data($data,array('email'=>$email),'elb_user');

					$result = array(
						'user_id'=>$userinfo->user_id,
						'email'=>$email,
						'email_otp'=>strval($email_otp),
					);

					$json = array("status" => 1,"message" => "OTP Send Your Email Successfully","response"=>$result);
				}
				else
				{
					$json = array("status" => 0,"message" => "Email Not Found");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function email_phone_verify_by_user()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			$this->form_validation->set_rules('verify_type', 'verify_type', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$user_id = $_POST['user_id'];
				$verify_type = $_POST['verify_type'];

				if($verify_type=='email')
				{
					$data =array(
						'email_verify'=>'1',
					);

					$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_user');

					if($upd > 0)
					{
						$json = array("status" => 1,"message" => "Email Verifed Successfully");
					}
					else
					{
						$json = array("status" => 1,"message" => "Email Not Verifed , Please Try Again");
					}
				}
				else if($verify_type=='phone')
				{
					$data =array(
						'phone_verify'=>'1',
					);

					$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_user');

					if($upd > 0)
					{
						$json = array("status" => 1,"message" => "Phone Number Verifed Successfully");
					}
					else
					{
						$json = array("status" => 0,"message" => "Phone Number Not Verifed , Please Try Again");
					}
				}
				else
				{
					$json = array("status" => 0,"message" => "Verify Type Not Valid");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function reset_password()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			$this->form_validation->set_rules('new_password', 'new_password', 'required');
			$this->form_validation->set_rules('conf_password', 'conf_password', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$user_id = $_POST['user_id'];
				$new_password = $_POST['new_password'];
				$conf_password = $_POST['conf_password'];

				if($new_password==$conf_password)
				{
					$data =array(
						'password'=>md5($new_password),
					);

					$upd = $this->general_obj->update_data($data,array('user_id'=>$user_id),'elb_user');

					if($upd > 0)
					{
						$json = array("status" => 1,"message" => "Password Reset Successfully");
					}
					else
					{
						$json = array("status" => 0,"message" => "Password Not Reset , Please Try Again");
					}
				}
				else
				{
					$json = array("status" => 0,"message" => "New Password & Confirm Password Does Not Match");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function get_resort_service_list()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'GET')
		{
			$services = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_resort_services');

			if(!empty($services))
			{	
				foreach ($services as $key => $value)
				{
					if($value['service_image']!=null)
					{
						$services[$key]['service_image'] = base_url('uploads/service_image/').$value['service_image'];
					}
					else
					{
						$services[$key]['service_image'] = '';
					}
				}	

				$json = array("status" => 1,"message" => "Resort Services List","response"=>$services);
			}
			else
			{
				$json = array("status" => 1,"message" => "Resort Services List","response"=>$services);
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function get_beach_list()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'GET')
		{
			$beaches = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_beach');
			array_walk_recursive($beaches,function(&$beaches){$beaches=strval($beaches);});

			if(!empty($beaches))
			{	
				foreach ($beaches as $key => $value)
				{	
					$beachtype = $this->general_obj->get_where_single(array('type_id'=>$value['beach_type']),'elb_beach_type');

					if($value['beach_image']!=null)
					{
						$beach_image = base_url('uploads/beach_image/').$value['beach_image'];
					}
					else
					{
						$beach_image = '';
					}

					$data[]=array(
						'beach_id'=>$value['beach_id'],
						'beach_code'=>$value['beach_code'],
						'beach_name'=>$value['beach_name'],
						'beach_image'=>$beach_image,
						'area'=>$value['area'],
						'position'=>$value['position'],
						'position_en'=>$value['position_en'],
						'latitude'=>$value['latitude'],
						'longitude'=>$value['longitude'],
						'beach_type'=>$value['beach_type'],
						'type_name'=>$beachtype->type_name,
						'type_name_it'=>$beachtype->type_name_it,
						'features'=>$value['features'],
						'is_active'=>$value['is_active'],
						'is_delete'=>$value['is_delete'],
						'created_at'=>$value['created_at'],
					);

				}	

				$json = array("status" => 1,"message" => "Beach List","response"=>$data);
			}
			else
			{
				$json = array("status" => 1,"message" => "Beach List","response"=>$beaches);
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function add_resort_information()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');
		    $this->form_validation->set_rules('beach_id', 'beach_id', 'required');
		    $this->form_validation->set_rules('resort_code', 'resort_code', 'required');
		    $this->form_validation->set_rules('resort_name', 'resort_name', 'required');
		    
		    if($_FILES['resort_image']['name']=='')
		    {
		    	$this->form_validation->set_rules('resort_image', 'resort_image', 'required');
		    }

		    $this->form_validation->set_rules('address', 'address', 'required');
		    $this->form_validation->set_rules('city', 'city', 'required');
		    $this->form_validation->set_rules('zipcode', 'zipcode', 'required');
		    $this->form_validation->set_rules('description', 'description', 'required');
		    $this->form_validation->set_rules('description_en', 'description_en', 'required');
		    $this->form_validation->set_rules('resort_open_date', 'resort_open_date', 'required');
		    $this->form_validation->set_rules('resort_close_date', 'resort_close_date', 'required');
		    $this->form_validation->set_rules('resort_open_time', 'resort_open_time', 'required');
		    $this->form_validation->set_rules('resort_close_time', 'resort_close_time', 'required');
		    $this->form_validation->set_rules('services', 'services', 'required');
		    $this->form_validation->set_rules('website', 'website', 'required');
		    $this->form_validation->set_rules('latitude', 'latitude', 'required');
		    $this->form_validation->set_rules('longitude', 'longitude', 'required');
		    
		    if($_FILES['other_images']['name']=='')
		    {
		    	$this->form_validation->set_rules('other_images', 'other_images', 'required');
		    }
		 	
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$cpt1 = count($_FILES['other_images']['name']);

				if($cpt1 > 0)
				{
					$userinfo = $this->general_obj->get_where_single(array('user_id'=>$_POST['user_id']),'elb_user');
				
					$data=[
						"user_id" => $this->input->post('user_id'),
						"beach_id" => $this->input->post('beach_id'),
						"resort_code" => $this->input->post('resort_code'),
						"resort_name" => $this->input->post('resort_name'),
						"address" => $this->input->post('address'),
						"city" => $this->input->post('city'),
						"zipcode" => $this->input->post('zipcode'),
						"description" => $this->input->post('description'),
						"description_en" => $this->input->post('description_en'),
						"resort_open_date" => $this->input->post('resort_open_date'),
						"resort_close_date" => $this->input->post('resort_close_date'),
						"email" => $userinfo->email,
						"phone" => $userinfo->phone,
						"services" => $this->input->post('services'),
						"owner_name" => $userinfo->first_name,
						"owner_surname" => $userinfo->surname,
						"website" => $this->input->post('website'),
						"latitude" => $this->input->post('latitude'),
						"longitude" => $this->input->post('longitude'),
						"company_name" => $this->input->post('company_name'),
						"vat_number" => $this->input->post('vat_number'),
						"bank_name" => $this->input->post('bank_name'),
						"iban" => $this->input->post('iban'),
						"sdi_code" => $this->input->post('sdi_code'),
					];


					$this->load->library('upload');

					if($_FILES['resort_image']['name']!='')
		            {
		                $configs['encrypt_name']    = TRUE;
		                $configs['upload_path']     = './uploads/resort_image';
		                $configs['allowed_types']   = '*';
		                	
		                $this->upload->initialize($configs);
		                if(!$this->upload->do_upload('resort_image'))
		        		{ 	
		        			$json = array("status" => 0,"message" => strip_tags($this->upload->display_errors()));
		        		}
		        		else
		    			{
		        			$resortimage = $this->upload->data('file_name');
		    			}	
		    		}
		    		else
		    		{
		    			$resortimage=NULL;
		    		}
				
					$data['resort_image']= $resortimage;

				
					$this->general_obj->insert_data($data,'elb_resort');
					$resort_id = $this->db->insert_id();


					if($resort_id > 0)
					{	
						$this->db->trans_start(); # Starting Transaction


						$timestamp = strtotime('next Monday');
		                $days = array();
		                for ($i = 0; $i < 7; $i++) {
		                    $days[] = strftime('%A', $timestamp);
		                    $timestamp = strtotime('+1 day', $timestamp);
		                }

		                foreach ($days as $key => $value)
		                {
		                	$timedata[]=array(
		                		'resort_id'=>$resort_id,
		                		'day'=>$value,
		                		'open_time'=>$this->input->post('resort_open_time'),
		                		'close_time'=>$this->input->post('resort_close_time'),
		                	);			
		                }

		                $this->general_obj->insert_all_data($timedata,'elb_resort_time');

		                $files = $_FILES;
	        			$images = array();
	       				$cpt = count($_FILES['other_images']['name']);

	       				$config['encrypt_name']		= TRUE;
						$config['upload_path']		= './uploads/resort_image/';
						$config['allowed_types']	= 'jpg|jpeg|png';

						$this->load->library('upload', $config);
			    		$this->upload->initialize($config);

			    		for($i=0; $i<$cpt; $i++)
						{           
						    $_FILES['image']['name']= $_FILES['other_images']['name'][$i];
						    $_FILES['image']['type']= $_FILES['other_images']['type'][$i];
						    $_FILES['image']['tmp_name']= $_FILES['other_images']['tmp_name'][$i];
						    $_FILES['image']['error']= $_FILES['other_images']['error'][$i];
						    $_FILES['image']['size']= $_FILES['other_images']['size'][$i];    

						    if($this->upload->do_upload('image'))
				            {
				                $data = $this->upload->data();
				                $images=$data["file_name"];
				            }
				            else
				            {
				                $images='';
				            }
		         
			            	$resort_imagedata[] = array(
								'resort_id' => $resort_id,
								'image_name' => $images
							);
						}

		        		$this->general_obj->insert_all_data($resort_imagedata,'elb_resort_image');

		        		$this->db->trans_complete(); # Completing transaction

		        		if ($this->db->trans_status() === FALSE)  
		                {
		                    # Something went wrong.
		                    $this->db->trans_rollback();
		                    $json =  array("status" => 0,"message"=>"Resort Added , But Resort Other Data Not Added");	       
		                } 
		                else 
		                {
		                	# Everything is Perfect. 
		                    # Committing data to the database.
		                    $this->db->trans_commit();

		                    $json =  array("status" => 1,"message"=>"Resort Added Successfully");
		                }
					}
					else
					{
						$json = array("status" => 0,"message" => "Resort Not Add , Please Try Again");
					}
				}
				else
				{
					$json = array("status" => 0,"message" => "Please Select Other Images");
				}			
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function add_resort_other_images()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('resort_id', 'resort_id', 'required');

		    if($_FILES['other_images']['name']=='')
		    {
		    	$this->form_validation->set_rules('other_images', 'other_images', 'required');
		    }
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$resort_id = $_POST['resort_id'];

				$this->load->library('upload');

				$files = $_FILES;
	        	$images = array();
	       		$cpt = count($_FILES['other_images']['name']);

            	if($cpt > 0)
            	{	
            		$this->db->trans_start(); # Starting Transaction

           			$config['encrypt_name']		= TRUE;
					$config['upload_path']		= './uploads/resort_image/';
					$config['allowed_types']	= 'jpg|jpeg|png';    
				    
					$this->load->library('upload', $config);
			    	$this->upload->initialize($config);
                
	            	for($i=0; $i<$cpt; $i++)
					{           
					    $_FILES['image']['name']= $_FILES['other_images']['name'][$i];
					    $_FILES['image']['type']= $_FILES['other_images']['type'][$i];
					    $_FILES['image']['tmp_name']= $_FILES['other_images']['tmp_name'][$i];
					    $_FILES['image']['error']= $_FILES['other_images']['error'][$i];
					    $_FILES['image']['size']= $_FILES['other_images']['size'][$i];    

					    if($this->upload->do_upload('image'))
			            {
			                $data = $this->upload->data();
			                $images=$data["file_name"];
			            }
			            else
			            {
			                $images='';
			            }
		         
		            	$resort_imagedata[] = array(
							'resort_id' => $resort_id,
							'image_name' => $images
						);
					}

		        	$this->general_obj->insert_all_data($resort_imagedata,'elb_resort_image');
						
					$this->db->trans_complete(); # Completing transaction

	        		if ($this->db->trans_status() === FALSE)  
	                {
	                    # Something went wrong.
	                    $this->db->trans_rollback();
	                    $json =  array("status" => 0,"message"=>"Image Not Uploaded , Please Try Again");
	                } 
	                else 
	                {
	                	# Everything is Perfect. 
	                    # Committing data to the database.
	                    $this->db->trans_commit();

	                    $otherimages = $this->general_obj->get_where(array('resort_id'=>$resort_id),'elb_resort_image');

						foreach ($otherimages as $key1 => $value1)
						{	
							if($value1['image_name']!=null)
							{
								$otherimages[$key1]['image_name'] = base_url('uploads/resort_image/').$value1['image_name'];
							}
							else
							{
								$otherimages[$key1]['image_name'] = '';
							}						
						}

	                    $json =  array("status" => 1,"message"=>"Images Uploaded Successfully","response"=>$otherimages);
	                }
				}
				else
				{
					$json = array("status" => 0,"message" => "Please Select Other Images");
				}	
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    } 


    function delete_other_image_by_id()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('image_id', 'image_id', 'required');

		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$image_id = $_POST['image_id'];

				$imageinfo = $this->general_obj->get_where_single(array('image_id'=>$image_id),'elb_resort_image');

				$image1 = $imageinfo->image_name;

            	unlink("./uploads/resort_image/$image1");	
            	
            	$this->db->where('image_id',$image_id);
            	$this->db->delete('elb_resort_image');	
				    
				$json = array("status" => 1,"message" => "Image Deleted Successfully");		
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }



    function get_package_service_list()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'GET')
		{
			$pkcservices = $this->general_obj->get_where(array('is_active'=>'1','is_delete'=>'0'),'elb_package_service');

			if(!empty($services))
			{
				$json = array("status" => 1,"message" => "Package Services List","response"=>$pkcservices);
			}
			else
			{
				$json = array("status" => 1,"message" => "Package Services List","response"=>$pkcservices);
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function add_package()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('resort_id', 'resort_id', 'required');
		    $this->form_validation->set_rules('rent_type', 'rent_type', 'required');
		    $this->form_validation->set_rules('service_type', 'service_type', 'required');
		   	$this->form_validation->set_rules('package_service_code', 'package_service_code', 'required');
		    $this->form_validation->set_rules('package_service_name_en', 'package_service_name_en', 'required');
		    $this->form_validation->set_rules('package_service_name_it', 'package_service_name_it', 'required');
		    $this->form_validation->set_rules('description_en', 'description_en', 'required');
		    $this->form_validation->set_rules('description_it', 'description_it', 'required');
		    $this->form_validation->set_rules('start_date', 'start_date', 'required');
		    $this->form_validation->set_rules('end_date', 'end_date', 'required');
		    $this->form_validation->set_rules('price', 'price', 'required');
		    
		    if($this->input->post('rent_type') == 'middle_or_daily')
			{
		    	$this->form_validation->set_rules('middle_price', 'middle_price', 'required');
		    }

		    $this->form_validation->set_rules('total_places', 'total_places', 'required');
		    $this->form_validation->set_rules('places_available', 'places_available', 'required');
		    $this->form_validation->set_rules('reservation_same_day', 'reservation_same_day', 'required');
		    $this->form_validation->set_rules('terms_service_it', 'terms_service_it', 'required');
		    $this->form_validation->set_rules('terms_service_en', 'terms_service_en', 'required');

		    if($_FILES['package_image']['name']=='')
		    {
		    	$this->form_validation->set_rules('package_image', 'package_image', 'required');
		    }

			$this->form_validation->set_rules('book_confirm', 'book_confirm', 'required');


		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				if($this->input->post('rent_type') == 'middle_or_daily')
				{
					$middle_price = $this->input->post('middle_price');
				}
				else
				{
					$middle_price = NULL ;
				}

				$start_date = date('Y-m-d',strtotime($this->input->post('start_date')));
				$end_date = date('Y-m-d',strtotime($this->input->post('end_date')));

				if($end_date < $start_date)
				{	
					$json =  array("status" => 0,"message"=>"End Date is not less then to Start Date");
				}
				else
				{
					
					$data=[
						"rent_type" => $this->input->post('rent_type'),
						"service_type" => $this->input->post('service_type'),
						"resort_id" => $this->input->post('resort_id'),
						"package_service_code" => $this->input->post('package_service_code'),
						"package_service_name_en" => $this->input->post('package_service_name_en'),
						"package_service_name_it" => $this->input->post('package_service_name_it'),
						"description_en" => $this->input->post('description_en'),
						"description_it" => $this->input->post('description_it'),
						"start_date" => $start_date,
						"end_date" => $end_date,
						"price" => $this->input->post('price'),
						"middle_price" => $middle_price,
						"total_places" => $this->input->post('total_places'),
						"places_available" => $this->input->post('places_available'),
						"reservation_same_day" => $this->input->post('reservation_same_day'),
						"terms_service_en" => $this->input->post('terms_service_en'),
						"terms_service_it" => $this->input->post('terms_service_it'),
						"book_confirm"=>$this->input->post('book_confirm'),
					];


					$this->load->library('upload');

					if($_FILES['package_image']['name']!='')
		            {
		                $configs['encrypt_name']    = TRUE;
		                $configs['upload_path']     = './uploads/package_image';
		                $configs['allowed_types']   = '*';
		                	
		                $this->upload->initialize($configs);
		                if(!$this->upload->do_upload('package_image'))
		        		{ 	
		        			$json = array("status" => 0,"message" => strip_tags($this->upload->display_errors()));
		        		}
		        		else
		    			{
		        			$packageimage = $this->upload->data('file_name');
		    			}	
		    		}
		    		else
		    		{
		    			$packageimage=NULL;
		    		}
				
					$data['package_image']= $packageimage;


					$this->general_obj->insert_data($data,'elb_package');
					$package_id = $this->db->insert_id();

					if($package_id > 0)
					{	
						$this->db->trans_start(); # Starting Transaction

						$this->db->select('service_type');
						$this->db->where('resort_id',$_POST['resort_id']);
						$this->db->group_by('service_type');
						$querys1 = $this->db->get('elb_package');
						$packagelist = $querys1->result_array();

						$packagedatas  =  array_column($packagelist, 'service_type');

						$package_service = implode(',',$packagedatas);
				
						$updatedata =array(
							'package_service'=>$package_service,
						);

						$where = array("resort_id" =>$_POST['resort_id']);
						$this->general_obj->update_data($updatedata,$where,'elb_resort');

		        		$this->db->trans_complete(); # Completing transaction

		        		if ($this->db->trans_status() === FALSE)  
		                {
		                    # Something went wrong.
		                    $this->db->trans_rollback();
		                    $json =  array("status" => 0,"message"=>"Package Added , But Package Service Not Updated");	       
		                } 
		                else 
		                {
		                	# Everything is Perfect. 
		                    # Committing data to the database.
		                    $this->db->trans_commit();

		                    $json =  array("status" => 1,"message"=>"Package Added Successfully");
		                }
					}
					else
					{
						$json = array("status" => 0,"message" => "Package Not Add , Please Try Again");
					}
				}				
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function package_list()
	{
		if ($this->input->server('REQUEST_METHOD') == 'POST')
		{
			$this->form_validation->set_rules('resort_id', 'resort_id', 'required');
			
			if ($this->form_validation->run() == FALSE) 
			{
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$todaydate = date('Y-m-d');
				
				$packages = $this->general_obj->get_where_with_order_by(array("resort_id"=>$_POST['resort_id'],'is_active'=>'1','is_delete'=>'0'),'created_at','asc','elb_package');	
				array_walk_recursive($packages,function(&$packages){$packages=strval($packages);});
				
				foreach ($packages as $key => $value3)
				{
					if($value3['package_image']!=null)
					{
						$package_image = base_url('uploads/package_image/').$value3['package_image'];
					}
					else
					{
						$package_image = '';
					}

					$sertype = $this->general_obj->get_where_single(array('service_id'=>$value3['service_type']),'elb_package_service');
					$ser_en = $sertype->service_name_en;
					$ser_it = $sertype->service_name_it;


					/*$package_available = $this->general_obj->get_where(array('book_date'=>$todaydate,'package_id'=>$value3['package_id'],'status'=>'booked'),'elb_booking_detail');*/

					$extrapackageinfo = $this->general_obj->get_where_single(array('is_active'=>'1','is_delete'=>'0','package_date'=>$todaydate,'package_id'=>$value3['package_id']),'elb_package_prices');


					if(!empty($extrapackageinfo))
					{
						$this->db->where(array('book_date'=>$todaydate,'package_id'=>$value3['package_id']));
						$this->db->where_in("status",array('booked','arrived','notshow'));
						$package_available = $this->db->get("elb_booking_detail")->result_array();

						if(!empty($package_available))
						{
							$packagesum = array_sum(array_column($package_available, 'package_qty'));
							$places_available = $extrapackageinfo->sheet_available - $packagesum;
							$fix_places_available = $extrapackageinfo->sheet_available;
						}
						else
						{	
							$packagesum = '0';
							$places_available = $extrapackageinfo->sheet_available;
							$fix_places_available = $extrapackageinfo->sheet_available;
						}
					}
					else
					{
						$this->db->where(array('book_date'=>$todaydate,'package_id'=>$value3['package_id']));
						$this->db->where_in("status",array('booked','arrived','notshow'));
						$package_available = $this->db->get("elb_booking_detail")->result_array();

						if(!empty($package_available))
						{
							$packagesum = array_sum(array_column($package_available, 'package_qty'));
							$places_available = $value3['places_available'] - $packagesum;
							$fix_places_available = $value3['places_available'];
						}
						else
						{	
							$packagesum = '0';
							$places_available = $value3['places_available'];
							$fix_places_available = $value3['places_available'];
						}
					}	


					$packagedata[]=array(
						'package_id'=>$value3['package_id'],
						'rent_type'=>$value3['rent_type'],
						'service_type'=>$value3['service_type'],
						'service_name_en'=>$ser_en,
						'service_name_it'=>$ser_it,
						'package_service_code'=>$value3['package_service_code'],
						'package_service_name_en'=>$value3['package_service_name_en'],
						'package_service_name_it'=>$value3['package_service_name_it'],
						'start_date'=>$value3['start_date'],
						'end_date'=>$value3['end_date'],
						'description_en'=>$value3['description_en'],
						'description_it'=>$value3['description_it'],
						'price'=>$value3['price'],
						'middle_price'=>$value3['middle_price'],
						'total_places'=>$value3['total_places'],
						'places_available'=>strval($fix_places_available),
						'available_sheet'=>strval($places_available),
						'no_of_reservation'=>strval($packagesum),
						'reservation_same_day'=>$value3['reservation_same_day'],
						'terms_service_it'=>$value3['terms_service_it'],
						'terms_service_en'=>$value3['terms_service_en'],
						'package_image'=>$package_image,
						'book_confirm'=>$value3['book_confirm'],
						'is_active'=>$value3['is_active'],
						'is_delete'=>$value3['is_delete'],
						'created_at'=>$value3['created_at'],

					);
				}	

				$json = array("status" => 1,"message" => "Package list","response" => !empty($packagedata) ? $packagedata : []);	
			}
		}else
		{
			$json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
		}

		echo json_encode($json);
	}


    function get_notification_count()
	{
		if ($this->input->server('REQUEST_METHOD') == 'POST')
		{
			$this->form_validation->set_rules('user_id', 'user_id', 'required');

			if ($this->form_validation->run() == FALSE) 
			{
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{
				$user_id = $this->input->post('user_id');
				
				$this->db->where(array("receiver_id" => $user_id,"notify_read" => "0"));
				$result1 = $this->db->get("elb_notification")->num_rows();

				$data['notify_count'] = strval($result1);
				
				$json = array("status" => 1,"message" => "Notification count","response"=>$data);
			}
		}else
		{
			$json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
		}

		echo json_encode($json);
	}


    function notification_list()
	{
		if ($this->input->server('REQUEST_METHOD') == 'POST')
		{
			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			
			if ($this->form_validation->run() == FALSE) 
			{
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$data=array(
					'notify_read'=>'1'
				);
				
				$user_id = $this->input->post('user_id');

                
				$this->general_obj->update_data($data,array("receiver_id" => $user_id,'notify_read'=>'0'),'elb_notification');


				$notification_list = $this->general_obj->get_where_with_order_by(array("receiver_id"=>$user_id,'is_delete'=>'0'),'created_at','DESC','elb_notification');	

				
				foreach ($notification_list as $key => $value)
				{
					$created_at = $this->general_obj->time_elapsed_string($value['created_at']);

					$notifydata[]=array(
						'notification_id'=>$value['notification_id'],
						'notification_type'=>$value['notification_type'],
						'receiver_id'=>$value['receiver_id'],
						'global_id'=>$value['global_id'],
						'message'=>$value['message'],
						'message_it'=>$value['message_it'],
						'created_at'=>$created_at,
						'is_delete'=>$value['is_delete'],
						'notify_read'=>$value['notify_read'],
					);
				}	

				$json = array("status" => 1,"message" => "Notification list","response" => !empty($notifydata) ? $notifydata : []);	
			}
		}else
		{
			$json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
		}

		echo json_encode($json);
	}


	function edit_package()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('package_id', 'package_id', 'required');
		    $this->form_validation->set_rules('rent_type', 'rent_type', 'required');
		    $this->form_validation->set_rules('service_type', 'service_type', 'required');
		   	$this->form_validation->set_rules('package_service_code', 'package_service_code', 'required');
		    $this->form_validation->set_rules('package_service_name_en', 'package_service_name_en', 'required');
		    $this->form_validation->set_rules('package_service_name_it', 'package_service_name_it', 'required');
		    $this->form_validation->set_rules('description_en', 'description_en', 'required');
		    $this->form_validation->set_rules('description_it', 'description_it', 'required');
		    $this->form_validation->set_rules('start_date', 'start_date', 'required');
		    $this->form_validation->set_rules('end_date', 'end_date', 'required');
		    $this->form_validation->set_rules('price', 'price', 'required');
		    
		    if($this->input->post('rent_type') == 'middle_or_daily')
			{
		    	$this->form_validation->set_rules('middle_price', 'middle_price', 'required');
		    }

		    $this->form_validation->set_rules('total_places', 'total_places', 'required');
		    $this->form_validation->set_rules('places_available', 'places_available', 'required');
		    $this->form_validation->set_rules('reservation_same_day', 'reservation_same_day', 'required');
		    $this->form_validation->set_rules('terms_service_it', 'terms_service_it', 'required');
		    $this->form_validation->set_rules('terms_service_en', 'terms_service_en', 'required');
		    $this->form_validation->set_rules('book_confirm', 'book_confirm', 'required');


		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				if($this->input->post('rent_type') == 'middle_or_daily')
				{
					$middle_price = $this->input->post('middle_price');
				}
				else
				{
					$middle_price = NULL ;
				}

				$start_date = date('Y-m-d',strtotime($this->input->post('start_date')));
				$end_date = date('Y-m-d',strtotime($this->input->post('end_date')));

				if($end_date < $start_date)
				{	
					$json =  array("status" => 0,"message"=>"End Date is not less then to Start Date");
				}
				else
				{
					$packageinfo = $this->general_obj->get_where_single(array('package_id'=>$_POST['package_id']),'elb_package');
					$image1 = $packageinfo->package_image;	

					$data=[
						"rent_type" => $this->input->post('rent_type'),
						"service_type" => $this->input->post('service_type'),
						"package_service_code" => $this->input->post('package_service_code'),
						"package_service_name_en" => $this->input->post('package_service_name_en'),
						"package_service_name_it" => $this->input->post('package_service_name_it'),
						"description_en" => $this->input->post('description_en'),
						"description_it" => $this->input->post('description_it'),
						"start_date" => $start_date,
						"end_date" => $end_date,
						"price" => $this->input->post('price'),
						"middle_price" => $middle_price,
						"total_places" => $this->input->post('total_places'),
						"places_available" => $this->input->post('places_available'),
						"reservation_same_day" => $this->input->post('reservation_same_day'),
						"terms_service_en" => $this->input->post('terms_service_en'),
						"terms_service_it" => $this->input->post('terms_service_it'),
						"book_confirm"=>$this->input->post('book_confirm'),
					];


					$this->load->library('upload');

					if($_FILES['package_image']['name']!='')
		            {
		                $configs['encrypt_name']    = TRUE;
		                $configs['upload_path']     = './uploads/package_image';
		                $configs['allowed_types']   = '*';
		                	
		                $this->upload->initialize($configs);
		                if(!$this->upload->do_upload('package_image'))
		        		{ 	
		        			$json = array("status" => 0,"message" => strip_tags($this->upload->display_errors()));
		        		}
		        		else
		    			{
		        			$packageimage = $this->upload->data('file_name');
		        			//unlink("./uploads/package_image/$image1");
		    			}	
		    		}
		    		else if($image1!=null)
		    		{
		    			$packageimage = $image1;
		    		}
		    		else
		    		{
		    			$packageimage=NULL;
		    		}
				
					$data['package_image']= $packageimage;


					$where = array("package_id" => $_POST['package_id']);
					$package_id = $this->general_obj->update_data($data,$where,'elb_package');

					if($package_id > 0)
					{	
						$this->db->trans_start(); # Starting Transaction

						$this->db->select('service_type');
						$this->db->where('resort_id',$packageinfo->resort_id);
						$this->db->group_by('service_type');
						$querys1 = $this->db->get('elb_package');
						$packagelist = $querys1->result_array();

						$packagedatas  =  array_column($packagelist, 'service_type');

						$package_service = implode(',',$packagedatas);
				
						$updatedata =array(
							'package_service'=>$package_service,
						);

						$where2 = array("resort_id" =>$packageinfo->resort_id);
						$this->general_obj->update_data($updatedata,$where2,'elb_resort');

		        		$this->db->trans_complete(); # Completing transaction

		        		if ($this->db->trans_status() === FALSE)  
		                {
		                    # Something went wrong.
		                    $this->db->trans_rollback();
		                    $json =  array("status" => 0,"message"=>"Package Updated , But Package Service Not Updated");	       
		                } 
		                else 
		                {
		                	# Everything is Perfect. 
		                    # Committing data to the database.
		                    $this->db->trans_commit();

		                    $json =  array("status" => 1,"message"=>"Package Updated Successfully");
		                }
					}
					else
					{
						$json = array("status" => 0,"message" => "Package Not Updated , Please Try Again");
					}
				}				
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function getDatesFromRange($start, $end, $format = 'Y-m-d')
    {
    	$array = array();
    	$interval = new DateInterval('P1D');

    	$realEnd = new DateTime($end);
    	$realEnd->add($interval);

    	$period = new DatePeriod(new DateTime($start), $interval, $realEnd);

    	foreach($period as $date) { 
        	$array[] = $date->format($format); 
    	}

    	return $array;
	}


    function package_detail_by_id()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('package_id', 'package_id', 'required');
			
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$todaydate = date('Y-m-d');

				$package_id = $_POST['package_id'];

				$packageinfo = $this->general_obj->get_where(array('package_id'=>$package_id,'is_active'=>'1','is_delete'=>'0'),'elb_package');
				array_walk_recursive($packageinfo,function(&$packageinfo){$packageinfo=strval($packageinfo);});
				
				if(!empty($packageinfo))
				{		
					foreach ($packageinfo as $key3 => $value3)
					{
						if($value3['package_image']!=null)
						{
							$package_image = base_url('uploads/package_image/').$value3['package_image'];
						}
						else
						{
							$package_image = '';
						}

						$sertype = $this->general_obj->get_where_single(array('service_id'=>$value3['service_type']),'elb_package_service');
						$ser_en = $sertype->service_name_en;
						$ser_it = $sertype->service_name_it;


						$Date1 = date('d-m-Y',strtotime($value3['start_date'])); 
						$Date2 = date('d-m-Y',strtotime($value3['end_date'])); 
						$datearray = array(); 
  
						// Use strtotime function 
						//$Variable1 = strtotime($Date1); 
						//$Variable2 = strtotime($Date2); 
  
						// Use for loop to store dates into array 
						// 86400 sec = 24 hrs = 60*60*24 = 1 day 
						/*for ($currentDate = $Variable1; $currentDate <= $Variable2; $currentDate += (86400)) { 
                                
							$Store = date('Y-m-d', $currentDate); 
							$datearray[] = $Store; 
						}*/
						$datearray = $this->getDatesFromRange($Date1, $Date2);


						foreach ($datearray as $keydata => $valuedata)
						{
							/*$seat_available = $this->general_obj->get_where(array('book_date'=>$valuedata,'package_id'=>$value3['package_id'],'status'=>'booked'),'elb_booking_detail');*/

							$extrapackageinfo = $this->general_obj->get_where_single(array('is_active'=>'1','is_delete'=>'0','package_date'=>$valuedata,'package_id'=>$value3['package_id']),'elb_package_prices');
							
							if(!empty($extrapackageinfo))
							{
								$this->db->where(array('book_date'=>$valuedata,'package_id'=>$value3['package_id']));
								$this->db->where_in("status",array('booked','arrived','notshow'));
								$seat_available = $this->db->get("elb_booking_detail")->result_array();

								if(!empty($seat_available))
								{
									$seatsum = array_sum(array_column($seat_available, 'package_qty'));
									
									if($extrapackageinfo->sheet_available > 0)
									{
										$seat_availables = $extrapackageinfo->sheet_available - $seatsum;
									}
									else
									{
										$seat_availables = $extrapackageinfo->sheet_available;
									}
								}
								else
								{	
									$seatsum = '0';
									$seat_availables = $extrapackageinfo->sheet_available;
								}

								$fix_places_availabless = $extrapackageinfo->sheet_available;
								$fix_fullprice = $extrapackageinfo->full_price;
								$fix_haffprice = $extrapackageinfo->half_price;
							}
							else
							{
								$this->db->where(array('book_date'=>$valuedata,'package_id'=>$value3['package_id']));
								$this->db->where_in("status",array('booked','arrived','notshow'));
								$seat_available = $this->db->get("elb_booking_detail")->result_array();

								if(!empty($seat_available))
								{
									$seatsum = array_sum(array_column($seat_available, 'package_qty'));
									
									if($value3['places_available'] > 0)
									{
										$seat_availables = $value3['places_available'] - $seatsum;
									}
									else
									{
										$seat_availables = $value3['places_available'];
									}
								}
								else
								{	$seatsum = '0';
									$seat_availables = $value3['places_available'];
								}

								$fix_places_availabless = $value3['places_available'];
								$fix_fullprice = $value3['price'];
								$fix_haffprice = $value3['middle_price'];
							}
						

							$datatat[] = array(
								'package_id'=>$value3['package_id'],
								'price'=>strval($fix_fullprice),
								'middle_price'=>strval($fix_haffprice),
								'total_place'=>strval($fix_places_availabless),
								'available'=>strval($seat_availables),
								'total_reservation'=>strval($seatsum),
								'date'=>$valuedata
							);
						} 


						/*$package_available = $this->general_obj->get_where(array('book_date'=>$todaydate,'package_id'=>$value3['package_id'],'status'=>'booked'),'elb_booking_detail');*/

						$extrapackageinfoss = $this->general_obj->get_where_single(array('is_active'=>'1','is_delete'=>'0','package_date'=>$todaydate,'package_id'=>$value3['package_id']),'elb_package_prices');

						if(!empty($extrapackageinfoss))
						{
							$this->db->where(array('book_date'=>$todaydate,'package_id'=>$value3['package_id']));
							$this->db->where_in("status",array('booked','arrived','notshow'));
							$package_available = $this->db->get("elb_booking_detail")->result_array();

							if(!empty($package_available))
							{
								$packagesum = array_sum(array_column($package_available, 'package_qty'));
								$places_available = $extrapackageinfoss->sheet_available - $packagesum;
								$fix_places_available = $extrapackageinfoss->sheet_available;
							}
							else
							{	
								$packagesum = '0';
								$places_available = $extrapackageinfoss->sheet_available;
								$fix_places_available = $extrapackageinfoss->sheet_available;
							}
						}
						else
						{
							$this->db->where(array('book_date'=>$todaydate,'package_id'=>$value3['package_id']));
							$this->db->where_in("status",array('booked','arrived','notshow'));
							$package_available = $this->db->get("elb_booking_detail")->result_array();

							if(!empty($package_available))
							{
								$packagesum = array_sum(array_column($package_available, 'package_qty'));
								$places_available = $value3['places_available'] - $packagesum;
								$fix_places_available = $value3['places_available'];
							}
							else
							{	
								$packagesum = '0';
								$places_available = $value3['places_available'];
								$fix_places_available = $value3['places_available'];
							}
						}	



						$packagedata=array(
							'package_id'=>$value3['package_id'],
							'rent_type'=>$value3['rent_type'],
							'service_type'=>$value3['service_type'],
							'service_name_en'=>$ser_en,
							'service_name_it'=>$ser_it,
							'package_service_code'=>$value3['package_service_code'],
							'package_service_name_en'=>$value3['package_service_name_en'],
							'package_service_name_it'=>$value3['package_service_name_it'],
							'start_date'=>$value3['start_date'],
							'end_date'=>$value3['end_date'],
							'description_en'=>$value3['description_en'],
							'description_it'=>$value3['description_it'],
							'price'=>$value3['price'],
							'middle_price'=>$value3['middle_price'],
							'total_places'=>$value3['total_places'],
							'places_available'=>strval($fix_places_available),
							'available_sheet'=>strval($places_available),
							'no_of_reservation'=>strval($packagesum),
							'reservation_same_day'=>$value3['reservation_same_day'],
							'terms_service_it'=>$value3['terms_service_it'],
							'terms_service_en'=>$value3['terms_service_en'],
							'package_image'=>$package_image,
							'book_confirm'=>$value3['book_confirm'],
							'is_active'=>$value3['is_active'],
							'is_delete'=>$value3['is_delete'],
							'created_at'=>$value3['created_at'],
							'date_array'=>$datatat
						);

					}													

					$data2_obj = (object)$packagedata;
					$json = array("status" => 1,"message" => "Package Detail","response" =>$data2_obj);

				}
				else
				{	
					$data2_obj = (object)[];
					$json = array("status" => 1,"message" => "Package Detail","response" =>$data2_obj);
				}
				
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function reservation_list_by_resort_id()
	{
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('resort_id', 'resort_id', 'required');
			$this->form_validation->set_rules('list_type', 'list_type', 'required');


		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$resort_id = $_POST['resort_id'];
				
				$today = date('Y-m-d');
				$tommorow = date("Y-m-d", strtotime("+1 day"));
				////  filter feild /////////

				if($_POST['from_date'])
				{
					$from_date = date('Y-m-d',strtotime($_POST['from_date']));
				}
				else
				{
					$from_date = '';
				}

				if($_POST['to_date'])
				{
					$to_date = date('Y-m-d',strtotime($_POST['to_date']));
				}
				else
				{
					$to_date = '';
				}



				if($_POST['list_type']=='all')
				{	
					if($from_date!=null || $to_date!=null )
					{
						if($to_date!=null)
				        {   
				            $this->db->where('from_date <=',$to_date);
				            $this->db->where('to_date >=',$from_date);             
				        }   
				        else
				        {
				            $this->db->where('from_date <=',$from_date);
				            $this->db->where('to_date >=',$from_date);
				        }
				        $this->db->where('to_date >',$today);
				        $this->db->where('to_date >',$tommorow);
				        $this->db->where('resort_id',$resort_id);
        				$query = $this->db->get('elb_booking');
        				$reservationlist = $query->result_array();
        			}
        			else
        			{	
        				//$this->db->where('from_date <=',$today);
			        	$this->db->where('to_date >',$today);
			        	$this->db->where('to_date >',$tommorow);
        				$this->db->where('resort_id',$resort_id);
        				$this->db->order_by('from_date','asc');
        				$query = $this->db->get('elb_booking');
        				$reservationlist = $query->result_array();
					}
				}
				else if($_POST['list_type']=='tomorrow')
				{
            		$this->db->where('from_date <=',$tommorow);
            		$this->db->where('to_date >=',$tommorow);
        			$this->db->where('resort_id',$resort_id);
        			$query = $this->db->get('elb_booking');
        			$reservationlist = $query->result_array();
				}
				else
				{
            		$this->db->where('from_date <=',$today);
            		$this->db->where('to_date >=',$today);
        			$this->db->where('resort_id',$resort_id);
        			$query = $this->db->get('elb_booking');
        			$reservationlist = $query->result_array();
				}
				

				if(!empty($reservationlist))
				{	
					foreach ($reservationlist as $key => $value)
					{	

						$userinfo = $this->general_obj->get_where_single(array('user_id'=>$value['user_id']),'elb_user'); 

						if($userinfo->profile_image!=null)
						{
							$profile_image = base_url('uploads/user_image/').$userinfo->profile_image;
						}
						else
						{
							$profile_image = base_url('uploads/user.png');
						}

						$bookdata = $this->general_obj->get_where(array('booking_id'=>$value['booking_id']),'elb_booking_detail');
						array_walk_recursive($bookdata,function(&$bookdata){$bookdata=strval($bookdata);}); 
						$package_qty = $bookdata[0]['package_qty'];

						if($value['package_id']=='0')
						{
							$packageinfo = $this->general_obj->get_where_single(array('booking_detail_id'=>$bookdata[0]['booking_detail_id']),'elb_booking_package');
							
							if($value['from_date']==$value['to_date'] || $value['to_date']=='')
							{
								$package_type = 'single';
							}
							else
							{
								$package_type = 'combo';
							}
						}
						else
						{
							$packageinfo = $this->general_obj->get_where_single(array('book_package_id'=>$bookdata[0]['book_package_id']),'elb_booking_package');
							

							if($value['from_date']==$value['to_date'] || $value['to_date']=='' )
							{
								$package_type = 'single';
							}
							else
							{
								$package_type = 'combo';
							}
						}

						$servicetypeinfo = $this->general_obj->get_where_single(array('service_id'=>$packageinfo->service_type),'elb_package_service');


						$data[]=array(
							'booking_id'=>$value['booking_id'],
							'user_id'=>$value['user_id'],
							'first_name'=>$userinfo->first_name,
							'surname'=>$userinfo->surname,
							'profile_image'=>$profile_image,
							'from_date'=>$value['from_date'],
							'to_date'=>$value['to_date'],
							'total_amount'=>$value['total_amount'],
							'created_at'=>$value['created_at'],
							'book_confirm'=>$value['book_confirm'],
							'status'=>$value['status'],
							'resort_check'=>$value['resort_check'],
							'package_qty'=>$package_qty,
							'arrive_time'=>$value['arrive_time'],
							'package_service_name_en'=>$packageinfo->package_service_name_en,
							'package_service_name_it'=>$packageinfo->package_service_name_it,
							'service_name_en'=>$servicetypeinfo->service_name_en,
							'service_name_it'=>$servicetypeinfo->service_name_it,
							'package_type'=>$package_type
						);	
					}

					$json = array("status" => 1,"message" => "Reservation List","response" =>$data);
				}
				else
				{
					$json = array("status" => 1,"message" => "Reservation List","response" =>$reservationlist);
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);							
	}


	function reservation_detail_by_id()
	{
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('booking_id', 'booking_id', 'required');


		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$booking_id = $_POST['booking_id'];
					
				$bookings = $this->general_obj->get_where_single(array('booking_id'=>$booking_id),'elb_booking');

				if(!empty($bookings))
				{	
					$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$bookings->resort_id),'elb_resort');

					
					$bookdata = $this->general_obj->get_where(array('booking_id'=>$booking_id),'elb_booking_detail');
					array_walk_recursive($bookdata,function(&$bookdata){$bookdata=strval($bookdata);});

					
					if($bookings->package_id=='0')
					{
						foreach ($bookdata as $key1 => $value1)
						{	

							$packageinfo = $this->general_obj->get_where_single(array('booking_detail_id'=>$value1['booking_detail_id']),'elb_booking_package');

							if($packageinfo->package_image!=null)
							{
								$package_image = base_url('uploads/package_image/').$packageinfo->package_image;
							}
							else
							{
								$package_image = '';
							}

							$packagedata[] = array(
								'package_id'=>$value1['package_id'],
								'rent_type'=>$packageinfo->rent_type,
								'service_type'=>$packageinfo->service_type,
								'package_service_name_en'=>$packageinfo->package_service_name_en,
								'package_service_name_it'=>$packageinfo->package_service_name_it,
								'package_image'=>$package_image,
								'book_date'=>$value1['book_date'],
								'package_qty'=>$value1['package_qty'],
								'boating_day'=>$value1['boating_day'],
								'price'=>$value1['price'],
								'total_price'=>$value1['total_price'],
							);
						}
					}
					else
					{	
						foreach ($bookdata as $key1 => $value1)
						{	
							$packageinfo = $this->general_obj->get_where_single(array('book_package_id'=>$value1['book_package_id']),'elb_booking_package');

							if($packageinfo->package_image!=null)
							{
								$package_image = base_url('uploads/package_image/').$packageinfo->package_image;
							}
							else
							{
								$package_image = '';
							}

							$packagedata[] = array(
								'package_id'=>$value1['package_id'],
								'rent_type'=>$packageinfo->rent_type,
								'service_type'=>$packageinfo->service_type,
								'package_service_name_en'=>$packageinfo->package_service_name_en,
								'package_service_name_it'=>$packageinfo->package_service_name_it,
								'package_image'=>$package_image,
								'book_date'=>$value1['book_date'],
								'package_qty'=>$value1['package_qty'],
								'boating_day'=>$value1['boating_day'],
								'price'=>$value1['price'],
								'total_price'=>$value1['total_price'],
							);
						}
					}


					$contactdatas = $this->general_obj->get_where(array('booking_id'=>$booking_id),'elb_booking_user');

					foreach ($contactdatas as $key2 => $value2)
					{
						$contactdata[] = array(
							'user_name'=>$value2['user_name'],
						);
					}

					$beachinfo = $this->general_obj->get_where_single(array('beach_id'=>$bookings->beach_id),'elb_beach');

					$userinfo = $this->general_obj->get_where_single(array('user_id'=>$bookings->user_id),'elb_user');

					if($userinfo->document_front_image!=null)
					{
						$document_front_image = base_url('uploads/document_file/').$userinfo->document_front_image;
					}
					else
					{
						$document_front_image = '';
					}

					if($userinfo->document_back_image!=null)
					{
						$document_back_image = base_url('uploads/document_file/').$userinfo->document_back_image;
					}
					else
					{
						$document_back_image = '';
					}	

					$refund = $this->general_obj->get_where_single(array('booking_id'=>$bookings->booking_id),'elb_booking_refund');
					
					if(!empty($bookings->qr_code))
					{
						$qr_code = base_url('uploads/qr_image/').$bookings->qr_code;
					}
					else
					{
						$qr_code = '';
					}

					$data= array(
						'booking_id'=>$bookings->booking_id,
						'user_id'=>$bookings->user_id,
						'first_name'=>!empty($userinfo->first_name) ? $userinfo->first_name : '',
						'surname'=>!empty($userinfo->surname) ? $userinfo->surname : '',
						'email'=>!empty($userinfo->email) ? $userinfo->email : '',
						'phone'=>!empty($userinfo->phone) ? $userinfo->phone : '',
						'upload_document'=>$userinfo->upload_document,
		    			'document_front_image'=>$document_front_image,
		    			'document_back_image'=>$document_back_image,
						'beach_id'=>$bookings->beach_id,
						'beach_name'=>$beachinfo->beach_name,
						'resort_id'=>$bookings->resort_id,
						'resort_name'=>!empty($resortinfo->resort_name) ? $resortinfo->resort_name : '',
						'resort_phone'=>!empty($resortinfo->phone) ? $resortinfo->phone : '',
						'resort_website'=>!empty($resortinfo->website) ? $resortinfo->website : '',
						'resort_latitude'=>!empty($resortinfo->latitude) ? $resortinfo->latitude : '',
						'resort_longitude'=>!empty($resortinfo->longitude) ? $resortinfo->longitude : '' ,
						'from_date'=>$bookings->from_date,
						'to_date'=>$bookings->to_date,
						'arrive_time'=>$bookings->arrive_time,
						'special_request'=>$bookings->special_request,
						'tax_amount'=>!empty($bookings->tax_amount) ? $bookings->tax_amount : '',
						'card_id'=>!empty($bookings->card_id) ? $bookings->card_id : '',
						'transaction_id'=>!empty($bookings->transaction_id) ? $bookings->transaction_id : '' ,
						'total_amount'=>$bookings->total_amount,
						'book_confirm'=>$bookings->book_confirm,
						'app_payment_mode'=>$bookings->app_payment_mode,
						'status'=>$bookings->status,
						'resort_check'=>$bookings->resort_check,
						'is_active'=>$bookings->is_active,
						'is_delete'=>$bookings->is_delete,
						'created_at'=>$bookings->created_at,
						'package_data'=>$packagedata,
						'contact_data'=>!empty($contactdata) ? $contactdata : [],
						//'qr_code'=>!empty($bookings->qr_code) ? $bookings->qr_code : '',
						'qr_code'=>$qr_code,
						'refund_status'=>!empty($refund) ? '1' : '0', 
						'refund_id'=>!empty($refund->ref_transaction_id) ? $refund->ref_transaction_id : '', 
						'refund_description'=>!empty($refund->description) ? $refund->description : '', 
						'refund_amount'=>!empty($refund->amount) ? $refund->amount : '', 
					);


					$json = array("status" => 1,"message" => "Reservation Detail","response" =>$data);
				
				}
				else
				{	
					$data2_obj = (object)[];
					$json = array("status" => 1,"message" => "Reservation Detail","response" =>$data2_obj);
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);							
	}


	function reservation_history()
	{
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('resort_id', 'resort_id', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$resort_id = $_POST['resort_id'];
				
				$today = date('Y-m-d');

				////  filter feild /////////

				if($_POST['from_date'])
				{
					$from_date = date('Y-m-d',strtotime($_POST['from_date']));
				}
				else
				{
					$from_date = '';
				}

				if($_POST['to_date'])
				{
					$to_date = date('Y-m-d',strtotime($_POST['to_date']));
				}
				else
				{
					$to_date = '';
				}


				if($from_date!=null || $to_date!=null )
				{
					if($to_date!=null)
			        {   
			            $this->db->where('from_date <=',$to_date);
			            $this->db->where('to_date >=',$from_date);             
			        }   
			        else
			        {
			            $this->db->where('from_date <=',$from_date);
			            $this->db->where('to_date >=',$from_date);
			        }

			        $this->db->where('from_date <',$today);
			        $this->db->where('to_date <',$today);
			        $this->db->where('resort_id',$resort_id);
    				$query = $this->db->get('elb_booking');
    				$reservationlist = $query->result_array();
    			}
    			else
    			{	
    				$this->db->where('from_date <',$today);
			        $this->db->where('to_date <',$today);
    				$this->db->where('resort_id',$resort_id);
    				$query = $this->db->get('elb_booking');
    				$reservationlist = $query->result_array();
				}
				

				if(!empty($reservationlist))
				{	
					foreach ($reservationlist as $key => $value)
					{	

						$userinfo = $this->general_obj->get_where_single(array('user_id'=>$value['user_id']),'elb_user'); 

						if($userinfo->profile_image!=null)
						{
							$profile_image = base_url('uploads/user_image/').$userinfo->profile_image;
						}
						else
						{
							$profile_image = base_url('uploads/user.png');
						}

						$bookdata = $this->general_obj->get_where(array('booking_id'=>$value['booking_id']),'elb_booking_detail');
						array_walk_recursive($bookdata,function(&$bookdata){$bookdata=strval($bookdata);}); 

						if($value['package_id']=='0')
						{
							$packageinfo = $this->general_obj->get_where_single(array('booking_detail_id'=>$bookdata[0]['booking_detail_id']),'elb_booking_package');
							
							if($value['from_date']==$value['to_date'] || $value['to_date']=='' )
							{
								$package_type = 'single';
							}
							else
							{
								$package_type = 'combo';
							}
						}
						else
						{
							$packageinfo = $this->general_obj->get_where_single(array('book_package_id'=>$bookdata[0]['book_package_id']),'elb_booking_package');
							
							if($value['from_date']==$value['to_date'] || $value['to_date']=='' )
							{
								$package_type = 'single';
							}
							else
							{
								$package_type = 'combo';
							}
						}

						
						$data[]=array(
							'booking_id'=>$value['booking_id'],
							'user_id'=>$value['user_id'],
							'first_name'=>$userinfo->first_name,
							'surname'=>$userinfo->surname,
							'profile_image'=>$profile_image,
							'from_date'=>$value['from_date'],
							'to_date'=>$value['to_date'],
							'total_amount'=>$value['total_amount'],
							'created_at'=>$value['created_at'],
							'book_confirm'=>$value['book_confirm'],
							'status'=>$value['status'],
							'package_service_name_en'=>$packageinfo->package_service_name_en,
							'package_service_name_it'=>$packageinfo->package_service_name_it,
							'package_type'=>$package_type
						);	
					}

					$json = array("status" => 1,"message" => "Reservation History List","response" =>$data);
				}
				else
				{
					$json = array("status" => 1,"message" => "Reservation History List","response" =>$reservationlist);
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);							
	}



	function user_checkdata()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('login_id', 'login_id', 'required');
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');	
			
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $login_id = $_POST['login_id'];
		        $user_id = $_POST['user_id'];
		        
		        $usercheck = $this->general_obj->get_where(array('user_id' =>$user_id,'is_active'=>'1','is_delete'=>'0','user_type'=>'resort'),'elb_user');
		        array_walk_recursive($usercheck,function(&$usercheck){$usercheck=strval($usercheck);});

              
				if(!empty($usercheck))  
				{	
					$login = $this->general_obj->get_where_single(array('login_id'=>$login_id),'elb_login');

					$checkresort_add = $this->general_obj->get_where(array('user_id'=>$usercheck[0]['user_id']),'elb_resort');

					if(!empty($checkresort_add))
					{
						$resortadd = '1';
						$resort_id = $checkresort_add[0]['resort_id'];

						$checkpackage_add = $this->general_obj->get_where(array('resort_id'=>$checkresort_add[0]['resort_id'],'is_active'=>'1','is_delete'=>'0'),'elb_package');
							
						if(!empty($checkpackage_add))
						{	
							$packageadd = '1';	
						}
						else
						{
							$packageadd = '0';
						}

					}
					else
					{
						$resortadd = '0';
						$resort_id ='';
						$packageadd = '0';
					}

					$logdata = array(
			    		'login_id'=>$login->login_id,
			    		'device_id'=>$login->device_id,
			    		'device_type'=>$login->device_type,
			    		'fcm_token'=>$login->fcm_token,
			    		'user_id'=>$usercheck[0]['user_id'],
			    		'resort_id'=>$resort_id,
			    		'login_type'=>$usercheck[0]['login_type'],
			    		'user_type'=>$usercheck[0]['user_type'],
			    		'first_name'=>$usercheck[0]['first_name'],
			    		'surname'=>$usercheck[0]['surname'],
		    			'email'=>$usercheck[0]['email'],
		    			'phone'=>$usercheck[0]['phone'],
		    			'email_otp'=>$usercheck[0]['email_otp'],	
		    			'email_verify'=>$usercheck[0]['email_verify'],
		    			'phone_verify'=>$usercheck[0]['phone_verify'],
		    			'is_active'=>$usercheck[0]['is_active'],
		    			'is_delete'=>$usercheck[0]['is_delete'],
		    			'created_at'=>$usercheck[0]['created_at'],
		    			'resort_add'=>$resortadd,
		    			'package_add'=>$packageadd

		    		);	

		    		$data2_obj = (object)$logdata;
			
					$json = array("status" => 1,"message" => "User Detail","response" => $data2_obj);	
				}
				else
				{   
					$json =  array("status" => 0,"message"=>"User Detail Not Found");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function package_delete_by_id()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('package_id', 'package_id', 'required');
		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $package_id = $_POST['package_id'];
		        
		        $data = array(
		        	'is_active'=>'0',
		        	'is_delete'=>'1'
		        );	

		        $upd = $this->general_obj->update_data($data,array('package_id'=>$package_id),'elb_package');
              
				if($upd > 0)  
				{	
					$json = array("status" => 1,"message" => "Package Deleted Successfully");	
				}
				else
				{   
					$json =  array("status" => 0,"message"=>"Package Not Deleted , Please Try Again");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function edit_resort_information()
	{ 
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('resort_id', 'resort_id', 'required');

		    
		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
		        $resort_id = $_POST['resort_id'];
		       	
		       	$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$resort_id),'elb_resort');

		       	$resorttimeget = $this->general_obj->get_where_single(array('resort_id'=>$resort_id),'elb_resort_time'); 
				$open_time = $resorttimeget->open_time;
				$close_time = $resorttimeget->close_time;


		       	$user_id = $resortinfo->user_id;
		        
		        $userinfo = $this->general_obj->get_where_single(array('user_id'=>$user_id),'elb_user');

		       	 	
		       	$email_check = $this->general_obj->get_where(array('user_id!='=>$user_id,'is_active'=>'1','is_delete'=>'0','email'=>$_POST['email'],'email!='=>NULL,'email!='=>'','user_type'=>'resort'),'elb_user');

				if(!empty($email_check))
				{
					$json =  array("status" => 0,"message"=>"Email Already Exists");
				}
				else
				{	
					$phone_check = $this->general_obj->get_where(array('user_id!='=>$user_id,'is_active'=>'1','is_delete'=>'0','phone'=>$_POST['phone'],'phone!='=>NULL,'phone!='=>'','user_type'=>'resort'),'elb_user');	
			       	
	       			if(!empty($phone_check))
					{	
						$json = array("status" => 0,"message" => "Phone Number Already Exists");
					}
	       			else
	       			{	

	       				$userdata=[
							'first_name'=>!empty($_POST['owner_name']) ? $_POST['owner_name'] : $resortinfo->owner_name,
							'surname'=>!empty($_POST['owner_surname']) ? $_POST['owner_surname'] : $resortinfo->owner_surname,
						];

						$this->general_obj->update_data($userdata,array('user_id'=>	$user_id),'elb_user');



	       				$data=[
							"beach_id" => !empty($_POST['beach_id']) ? $_POST['beach_id'] : $resortinfo->beach_id,
							"resort_code" => !empty($_POST['resort_code']) ? $_POST['resort_code'] : $resortinfo->resort_code,
							"resort_name" => !empty($_POST['resort_name']) ? $_POST['resort_name'] : $resortinfo->resort_name,
							"address" => !empty($_POST['address']) ? $_POST['address'] : $resortinfo->address,
							"city" => !empty($_POST['city']) ? $_POST['city'] : $resortinfo->city,
							"zipcode" => !empty($_POST['zipcode']) ? $_POST['zipcode'] : $resortinfo->zipcode,
							"description" => !empty($_POST['description']) ? $_POST['description'] : $resortinfo->description,
							"description_en" => !empty($_POST['description_en']) ? $_POST['description_en'] : $resortinfo->description_en,
							"resort_open_date" => !empty($_POST['resort_open_date']) ? $_POST['resort_open_date'] : $resortinfo->resort_open_date,
							"resort_close_date" => !empty($_POST['resort_close_date']) ? $_POST['resort_close_date'] : $resortinfo->resort_close_date,
							"email" => !empty($_POST['email']) ? $_POST['email'] : $resortinfo->email,
							"phone" => !empty($_POST['phone']) ? $_POST['phone'] : $resortinfo->phone,
							"services" => !empty($_POST['services']) ? $_POST['services'] : $resortinfo->services,
							"owner_name" => !empty($_POST['owner_name']) ? $_POST['owner_name'] : $resortinfo->owner_name,
							"owner_surname" => !empty($_POST['owner_surname']) ? $_POST['owner_surname'] : $resortinfo->owner_surname,
							"website" => !empty($_POST['website']) ? $_POST['website'] : $resortinfo->website,
							"latitude" => !empty($_POST['latitude']) ? $_POST['latitude'] : $resortinfo->latitude,
							"longitude" => !empty($_POST['longitude']) ? $_POST['longitude'] : $resortinfo->longitude,
							"company_name" => !empty($_POST['company_name']) ? $_POST['company_name'] : $resortinfo->company_name,
							"vat_number" => !empty($_POST['vat_number']) ? $_POST['vat_number'] : $resortinfo->vat_number,
							"bank_name" => !empty($_POST['bank_name']) ? $_POST['bank_name'] : $resortinfo->bank_name,
							"iban" => !empty($_POST['iban']) ? $_POST['iban'] : $resortinfo->iban,
							"sdi_code" => !empty($_POST['sdi_code']) ? $_POST['sdi_code'] : $resortinfo->sdi_code,
						];

				       	$upd = $this->general_obj->update_data($data,array("resort_id" => $resort_id),"elb_resort");

						if ($upd > 0) 
						{	
							$timedata=array(
                				'open_time'=>!empty($_POST['resort_open_time']) ? $_POST['resort_open_time'] : $open_time,
                				'close_time'=>!empty($_POST['resort_close_time']) ? $_POST['resort_close_time'] : $close_time,
                			);			
	               
                			$where1 = array("resort_id" => $resort_id);
	                		$this->general_obj->update_data($timedata,$where1,'elb_resort_time');


							$json = array("status" => 1,"message" => "Resort Info Updated Successfully");
						}
						else
						{
							$json = array("status" => 0,"message" => "Resort Info Not Updated , Please Try Again");
						}		
					}
				}
			}	
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }



    function add_contact_us()
	{
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			$this->form_validation->set_rules('contact_name', 'contact_name', 'required');
			$this->form_validation->set_rules('email', 'email', 'required');
			$this->form_validation->set_rules('description', 'description', 'required');


		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$userinfo = $this->general_obj->get_where_single(array('user_id'=>$_POST['user_id']),'elb_user');

				$data=array(
					'user_id'=>$_POST['user_id'],
					'user_type'=>$userinfo->user_type,
					'contact_name'=>$_POST['contact_name'],
					'email'=>$_POST['email'],
					'description'=>$_POST['description'],
				);

				$this->general_obj->insert_data($data,'elb_contactus');
				$conatct_id = $this->db->insert_id();

				if($conatct_id > 0)
				{	
					$json =  array("status" => 1,"message"=>"Conatct Send Successfully");	    	 
				}
				else
				{
					 $json = array("status" => 0,"message" => "Contact Not Send");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);							
	}


	function update_status_booking_id()
	{
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('booking_id', 'booking_id', 'required');
			$this->form_validation->set_rules('status', 'status', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$bookinginfo = $this->general_obj->get_where_single(array('booking_id'=>$_POST['booking_id']),'elb_booking');
				$bookfrom_date = $bookinginfo->from_date;
				$to_date = $bookinginfo->to_date;

				$app_payment_mode = $bookinginfo->app_payment_mode;

				$resort_id = $bookinginfo->resort_id;
				$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$resort_id),'elb_resort');
				$resortname = $resortinfo->resort_name;

				$bookdata = $this->general_obj->get_where(array('booking_id'=>$_POST['booking_id']),'elb_booking_detail');

				$packageinfo = $this->general_obj->get_where_single(array('booking_detail_id'=>$bookdata[0]['booking_detail_id']),'elb_booking_package');


				$userinfo = $this->general_obj->get_where_single(array('user_id'=>$bookinginfo->user_id),'elb_user');
				$sender_fullname = $userinfo->first_name.' '.$userinfo->surname; 

				if($_POST['status']=='booked')
				{	
					if($app_payment_mode=='online')	
					{
						///////   payment   ///////////////////////////
						$card_id = $bookinginfo->card_id;
						$grand_total = $bookinginfo->total_amount;

						$usercard = $this->general_obj->get_where_single(array('user_id'=>$bookinginfo->user_id),'elb_user_card');					
						$strip_customer_id = $usercard->strip_customer_id;

						$charges_url = 'https://api.stripe.com/v1/charges';
		        		$charges_headers = array('Authorization: Bearer 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');

		    			$charges_fields = array(
		        			"amount" => $grand_total * 100,
		        			"currency" => "EUR",
		        			"customer"=>$strip_customer_id,
		        			"source" => $card_id,
		        			"description" => "Beach booking payment"
		    			);

		    			$charges_ch = curl_init();
				        curl_setopt($charges_ch, CURLOPT_HTTPHEADER, $charges_headers);
				        curl_setopt($charges_ch, CURLOPT_URL, $charges_url);
				        curl_setopt($charges_ch, CURLOPT_POST, true);
				        curl_setopt($charges_ch, CURLOPT_POSTFIELDS, http_build_query($charges_fields));
				        curl_setopt($charges_ch, CURLOPT_RETURNTRANSFER, true);
				        curl_setopt($charges_ch, CURLOPT_SSL_VERIFYPEER, false);
				        $charges_output = curl_exec($charges_ch);
				        $charges_response = json_decode($charges_output);
				        curl_close($charges_ch);

				        if((array_key_exists("error",$charges_response)))
		        		{
		              		$json = array("status" => 0,"message" => "Payemnt Not Done Somthing Worng","response"=>$charges_response);
		        		}
						else
						{
							$data=array(
								'status'=>$_POST['status'],
								'transaction_id'=>$charges_response->id
							);

							$bookpacdata=array(
								'status'=>$_POST['status'],
							);

							$upd = $this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking');

							$this->general_obj->update_data($bookpacdata,array('booking_id'=>$_POST['booking_id']),'elb_booking_detail');

							if($upd > 0)
							{	
								$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$bookinginfo->resort_id),'elb_resort');
							
								$resortuser_id = $resortinfo->user_id;
								$bookinguserid =  $bookinginfo->user_id;

								//////////////// send notification /////////////////
							 
								$receiverfcm = $this->general_obj->get_where(array("user_id" => $bookinguserid),"elb_login");

								$notification_data = array("sender_id" => $resortuser_id,"receiver_id" => $bookinguserid,"global_id" => $_POST['booking_id'],"notification_type"=>'confirm_booking',"message"=>'Your booking from '.$bookfrom_date.' to '.$to_date.' is accepted.',"message_it"=>'La tua prenotazione dal '.$bookfrom_date.' al '.$to_date.' è accettata.');

								$this->general_obj->insert_data($notification_data,"elb_notification");

								$receiveruser = $this->general_obj->get_where_single(array("user_id" => $bookinguserid),"elb_user");
								$userlanguage = $receiveruser->language;

								if($userlanguage=='en')
								{
									$title = 'Confirmation Request - '.$resortname;
									//$message = 'Your booking from '.$bookfrom_date.' to '.$to_date.' is accepted.';
									$message = $bookdata[0]['package_qty'].' * '.$packageinfo->package_service_name_en.' ~ '.date('d M',strtotime($bookinginfo->from_date)).' ~ '.$sender_fullname;
									$type = "confirm_booking";
								}
								else
								{
									$title = 'Richiesta Conferma - '.$resortname;
									//$message = 'La tua prenotazione dal '.$bookfrom_date.' al '.$to_date.' è accettata.';
									$message = $bookdata[0]['package_qty'].' * '.$packageinfo->package_service_name_it.' ~ '.date('d M',strtotime($bookinginfo->from_date)).' ~ '.$sender_fullname;
									$type = "confirm_booking";
								}
							
								$fcm_token = array();

								foreach ($receiverfcm as $key => $value)
								{
									array_push($fcm_token,$value['fcm_token']);
								}

								$this->db->where("receiver_id",$bookinguserid);
								$this->db->where("notify_read","0");
								$count = $this->db->get("elb_notification")->num_rows();

								$this->send_notification($title,$message,$fcm_token,$type,$count,$_POST['booking_id']);
							
								/////////////////////////////////////////////////////////////////


								$json =  array("status" => 1,"message"=>"Status Updated Successfully");	    	 
							}
							else
							{
								$json = array("status" => 0,"message" => "Status Not Updated");
							}
						}
					}
					else
					{
						$data=array(
							'status'=>$_POST['status'],
							'transaction_id'=>NULL
						);

						$bookpacdata=array(
							'status'=>$_POST['status'],
						);

						$upd = $this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking');

						$this->general_obj->update_data($bookpacdata,array('booking_id'=>$_POST['booking_id']),'elb_booking_detail');

						if($upd > 0)
						{	
							$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$bookinginfo->resort_id),'elb_resort');
						
							$resortuser_id = $resortinfo->user_id;
							$bookinguserid =  $bookinginfo->user_id;

							//////////////// send notification /////////////////
						 
							$receiverfcm = $this->general_obj->get_where(array("user_id" => $bookinguserid),"elb_login");

							$notification_data = array("sender_id" => $resortuser_id,"receiver_id" => $bookinguserid,"global_id" => $_POST['booking_id'],"notification_type"=>'confirm_booking',"message"=>'Your booking from '.$bookfrom_date.' to '.$to_date.' is accepted.',"message_it"=>'La tua prenotazione dal '.$bookfrom_date.' al '.$to_date.' è accettata.');

							$this->general_obj->insert_data($notification_data,"elb_notification");

							$receiveruser = $this->general_obj->get_where_single(array("user_id" => $bookinguserid),"elb_user");
							$userlanguage = $receiveruser->language;

							if($userlanguage=='en')
							{
								$title = 'Confirmation Request - '.$resortname;
								//$message = 'Your booking from '.$bookfrom_date.' to '.$to_date.' is accepted.';
								$message = $bookdata[0]['package_qty'].' * '.$packageinfo->package_service_name_en.' ~ '.date('d M',strtotime($bookinginfo->from_date)).' ~ '.$sender_fullname;
								$type = "confirm_booking";
							}
							else
							{
								$title = 'Richiesta Conferma - '.$resortname;
								//$message = 'La tua prenotazione dal '.$bookfrom_date.' al '.$to_date.' è accettata.';
								$message = $bookdata[0]['package_qty'].' * '.$packageinfo->package_service_name_it.' ~ '.date('d M',strtotime($bookinginfo->from_date)).' ~ '.$sender_fullname;
								$type = "confirm_booking";
							}
						
							$fcm_token = array();

							foreach ($receiverfcm as $key => $value)
							{
								array_push($fcm_token,$value['fcm_token']);
							}

							$this->db->where("receiver_id",$bookinguserid);
							$this->db->where("notify_read","0");
							$count = $this->db->get("elb_notification")->num_rows();

							$this->send_notification($title,$message,$fcm_token,$type,$count,$_POST['booking_id']);
						
							/////////////////////////////////////////////////////////////////


							$json =  array("status" => 1,"message"=>"Status Updated Successfully");	    	 
						}
						else
						{
							$json = array("status" => 0,"message" => "Status Not Updated");
						}
					}

				}
				else if($_POST['status']=='reject')
				{
					$data=array(
						'status'=>$_POST['status'],
					);

					$upd = $this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking');

					$this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking_detail');

					if($upd > 0)
					{	
						$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$bookinginfo->resort_id),'elb_resort');
						
						$resortuser_id = $resortinfo->user_id;
						$bookinguserid =  $bookinginfo->user_id;

						//////////////// send notification /////////////////
						 
						$receiverfcm = $this->general_obj->get_where(array("user_id" => $bookinguserid),"elb_login");

						$notification_data = array("sender_id" => $resortuser_id,"receiver_id" => $bookinguserid,"global_id" => $_POST['booking_id'],"notification_type"=>'reject_booking',"message"=>'Your booking from '.$bookfrom_date.' to '.$to_date.' is rejected.',"message_it"=>'La tua prenotazione dal '.$bookfrom_date.' al '.$to_date.' è rifiutata.');

						$this->general_obj->insert_data($notification_data,"elb_notification");

						$receiveruser = $this->general_obj->get_where_single(array("user_id" => $bookinguserid),"elb_user");
						$userlanguage = $receiveruser->language;

						if($userlanguage=='en')
						{
							$title = 'Reservation Canceled - '.$resortname;
							//$message = 'Your booking from '.$bookfrom_date.' to '.$to_date.' is rejected.';
							$message = $bookdata[0]['package_qty'].' * '.$packageinfo->package_service_name_en.' ~ '.date('d M',strtotime($bookinginfo->from_date)).' ~ '.$sender_fullname;
							$type = "reject_booking";
						}
						else
						{
							$title = 'Prenotazione Annullata - '.$resortname;
							//$message = 'La tua prenotazione dal '.$bookfrom_date.' al '.$to_date.' è rifiutata.';
							$message = $bookdata[0]['package_qty'].' * '.$packageinfo->package_service_name_en.' ~ '.date('d M',strtotime($bookinginfo->from_date)).' ~ '.$sender_fullname;
							$type = "reject_booking";
						}
						
						$fcm_token = array();

						foreach ($receiverfcm as $key => $value)
						{
							array_push($fcm_token,$value['fcm_token']);
						}

						$this->db->where("receiver_id",$bookinguserid);
						$this->db->where("notify_read","0");
						$count = $this->db->get("elb_notification")->num_rows();

						$this->send_notification($title,$message,$fcm_token,$type,$count,$_POST['booking_id']);
						
						/////////////////////////////////////////////////////////////////


						$json =  array("status" => 1,"message"=>"Status Updated Successfully");	    	 
					}
					else
					{
						$json = array("status" => 0,"message" => "Status Not Updated");
					}
				}
				else if($_POST['status']=='arrived')
				{
					$data=array(
						'status'=>$_POST['status'],
					);

					$upd = $this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking');

					$this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking_detail');

					if($upd > 0)
					{	
						$json =  array("status" => 1,"message"=>"Status Updated Successfully");	    	 
					}
					else
					{
						$json = array("status" => 0,"message" => "Status Not Updated");
					}
				}
				else if($_POST['status']=='notshow')
				{
					$data=array(
						'status'=>$_POST['status'],
					);

					$upd = $this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking');

					$this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking_detail');

					if($upd > 0)
					{	
						$json =  array("status" => 1,"message"=>"Status Updated Successfully");	    	 
					}
					else
					{
						$json = array("status" => 0,"message" => "Status Not Updated");
					}
				}
				else
				{
					$json = array("status" => 0,"message" => "Status Not Valid");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);							
	}



    function update_user_language()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
		    $this->form_validation->set_rules('user_id', 'user_id', 'required');
		    $this->form_validation->set_rules('language', 'language', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				if($_POST['language']=='en' || $_POST['language']=='it')
				{	
					$data=[
						"language" => $_POST['language'],
					];

					$where = array("user_id" => $_POST['user_id']);
					$upd = $this->general_obj->update_data($data,$where,'elb_user');

					if($upd > 0)
					{	
						$json =  array("status" => 1,"message"=>"Language Updated Successfully");
					}
					else
					{
						$json = array("status" => 0,"message" => "Language Not Updated , Please Try Again");
					}
				}
				else
				{
					$json =  array("status" => 0,"message"=>"Language Not Valid");
				}				
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }


    function earning_history()
	{	
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('resort_id', 'resort_id', 'required');

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$resort_id = $_POST['resort_id'];

				if($_POST['from_date'])
				{
					$from_date = date('Y-m-d',strtotime($_POST['from_date']));
				}
				else
				{
					$from_date = '';
				}

				if($_POST['to_date'])
				{
					$to_date = date('Y-m-d',strtotime($_POST['to_date']));
				}
				else
				{
					$to_date = '';
				}


				if($from_date!=null || $to_date!=null )
				{
					if($to_date!=null)
			        {   
			            $this->db->where('from_date <=',$to_date);
			            $this->db->where('to_date >=',$from_date);             
			        }   
			        else
			        {
			            $this->db->where('from_date <=',$from_date);
			            $this->db->where('to_date >=',$from_date);
			        }
			        $this->db->where('resort_id',$resort_id);
					$this->db->where_in("status",array('booked','arrived','notshow'));
					$this->db->order_by('booking_id','DESC');
					$query = $this->db->get('elb_booking');
					$earninglist = $query->result_array();
    			}
    			else
    			{	
    				$this->db->where('resort_id',$resort_id);
					$this->db->where_in("status",array('booked','arrived','notshow'));
					$this->db->order_by('booking_id','DESC');
					$query = $this->db->get('elb_booking');
					$earninglist = $query->result_array();
				}
				

				if(!empty($earninglist))
				{	
					foreach ($earninglist as $key => $value)
					{	
						$earning_amount = $value['total_amount'] - $value['tax_amount'];


						$userinfo = $this->general_obj->get_where_single(array('user_id'=>$value['user_id']),'elb_user'); 

						if($userinfo->profile_image!=null)
						{
							$profile_image = base_url('uploads/user_image/').$userinfo->profile_image;
						}
						else
						{
							$profile_image = base_url('uploads/user.png');
						}

						$bookdata = $this->general_obj->get_where(array('booking_id'=>$value['booking_id']),'elb_booking_detail');
						array_walk_recursive($bookdata,function(&$bookdata){$bookdata=strval($bookdata);}); 
						$package_qty = $bookdata[0]['package_qty'];

						if($value['package_id']=='0')
						{
							$packageinfo = $this->general_obj->get_where_single(array('booking_detail_id'=>$bookdata[0]['booking_detail_id']),'elb_booking_package');
							
							if($value['from_date']==$value['to_date'] || $value['to_date']=='')
							{
								$package_type = 'single';
							}
							else
							{
								$package_type = 'combo';
							}
						}
						else
						{
							$packageinfo = $this->general_obj->get_where_single(array('book_package_id'=>$bookdata[0]['book_package_id']),'elb_booking_package');
							

							if($value['from_date']==$value['to_date'] || $value['to_date']=='' )
							{
								$package_type = 'single';
							}
							else
							{
								$package_type = 'combo';
							}
						}

						$servicetypeinfo = $this->general_obj->get_where_single(array('service_id'=>$packageinfo->service_type),'elb_package_service');


						$data[]=array(
							'booking_id'=>$value['booking_id'],
							'user_id'=>$value['user_id'],
							'first_name'=>!empty($userinfo->first_name) ? $userinfo->first_name : '',
							'surname'=>!empty($userinfo->surname) ? $userinfo->surname : '',
							'profile_image'=>$profile_image,
							'from_date'=>$value['from_date'],
							'to_date'=>$value['to_date'],
							'tax_amount'=>!empty($value['tax_amount']) ? $value['tax_amount'] : '',
							'total_amount'=>$value['total_amount'],
							'created_at'=>$value['created_at'],
							'book_confirm'=>$value['book_confirm'],
							'status'=>$value['status'],
							'package_qty'=>$package_qty,
							'arrive_time'=>$value['arrive_time'],
							'package_service_name_en'=>$packageinfo->package_service_name_en,
							'package_service_name_it'=>$packageinfo->package_service_name_it,
							'service_name_en'=>$servicetypeinfo->service_name_en,
							'service_name_it'=>$servicetypeinfo->service_name_it,
							'package_type'=>$package_type,
							'earning_amount'=>strval($earning_amount),
						);	
					}

					$totalearning = array_sum(array_column($data, 'earning_amount'));

					$response = array(
						'total_earning'=>strval($totalearning),
						'earning_list'=>$data,
					);

					$json = array("status" => 1,"message" => "Earning History List","response" =>$response);
				}
				else
				{
					$response = array(
						'total_earning'=>'0',
						'earning_list'=>[],
					);

					$json = array("status" => 1,"message" => "Earning History List","response" =>$response);
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);							
	}
    
    
	/*function update_package_by_id1()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{	
			$this->form_validation->set_rules('type', 'type', 'required');
		    
			if($_POST['type']=='default')
			{
		    	$this->form_validation->set_rules('package_id', 'package_id', 'required');
		    	$this->form_validation->set_rules('start_date', 'start_date', 'required');
		    	//$this->form_validation->set_rules('end_date', 'end_date', 'required');
		    }
		    else
		    {	
		    	$this->form_validation->set_rules('package_id', 'package_id', 'required');
		    	$this->form_validation->set_rules('start_date', 'start_date', 'required');
		    	//$this->form_validation->set_rules('end_date', 'end_date', 'required');
		    	$this->form_validation->set_rules('price', 'price', 'required');
		    	$this->form_validation->set_rules('places_available', 'places_available', 'required');
		    }


		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	

				if(empty($_POST['end_date']))
				{	
					$date1 = date('Y-m-d',strtotime($_POST['start_date']));
					
					$datearray = array();

					array_push($datearray,$date1);

				}
				else
				{
					$Date1 = date('d-m-Y',strtotime($_POST['start_date'])); 
					$Date2 = date('d-m-Y',strtotime($_POST['end_date'])); 
					$datearray = array(); 
  
					// Use strtotime function 
					$Variable1 = strtotime($Date1); 
					$Variable2 = strtotime($Date2); 
	  
					// Use for loop to store dates into array 
					// 86400 sec = 24 hrs = 60*60*24 = 1 day 
					for ($currentDate = $Variable1; $currentDate <= $Variable2; $currentDate += (86400)) { 
	                                
							$Store = date('Y-m-d', $currentDate); 
							$datearray[] = $Store; 
					} 
				}


				$packageinfo = $this->general_obj->get_where_single(array('package_id'=>$_POST['package_id']),'elb_package');


				if($_POST['type']=='default')
				{	
					$this->db->trans_start(); # Starting Transaction

					foreach ($datearray as $keydata => $valuedata)
					{	
						$data=[
							"is_active" =>'0',
							"is_delete" => '1',
						];

						$where = array("package_id" => $_POST['package_id'],'package_date'=>$valuedata,'is_active'=>'1','is_delete'=>'0');
						$package_id = $this->general_obj->update_data($data,$where,'elb_package_prices');
					}

					$this->db->trans_complete(); # Completing transaction

            		if ($this->db->trans_status() === FALSE)  
            		{
	                    # Something went wrong.
	                    $this->db->trans_rollback();
	                    $json =  array("status" => 0,"message"=>"Default Not Set Somthing Wrong , Please Try Again");	
                
            		} 
            		else 
            		{
	                    # Everything is Perfect. 
	                    # Committing data to the database.
	                    $this->db->trans_commit();

	                    $json =  array("status" => 1,"message"=>"Default Set Successfully");	   
	                }	
				}
				else if($_POST['type']=='custome')
				{	
					$this->db->trans_start(); # Starting Transaction

					foreach ($datearray as $keydata => $valuedata)
					{	
						if($valuedata < $packageinfo->start_date || $valuedata > $packageinfo->end_date)
						{	
							$json =  array("status" => 0,"message"=>$valuedata." Date defalut package wise not select");
							echo json_encode($json);
							exit;
						}
						else
						{	
							if($this->input->post('places_available') > $packageinfo->total_places)
							{
								$json =  array("status" => 0,"message"=>"Available sheet Select less then to total place");
								echo json_encode($json);
								exit;
							}
							else
							{
								if($packageinfo->rent_type == 'middle_or_daily')
								{
									$middle_price = $this->input->post('middle_price');
								}
								else
								{
									$middle_price = NULL ;
								}

								$data=[
									"package_id" =>$_POST['package_id'],
									"package_date" => $valuedata,
									"full_price" => $this->input->post('price'),
									"half_price" => $middle_price,
									"sheet_available" => $this->input->post('places_available'),
								];

								$paccheck = $this->general_obj->get_where_single(array("package_id" => $_POST['package_id'],'package_date'=>$valuedata,'is_active'=>'1','is_delete'=>'0'),'elb_package_prices');

								if(!empty($paccheck))
								{
									$where = array("ex_package_id" => $paccheck->ex_package_id);
									$this->general_obj->update_data($data,$where,'elb_package_prices');
								}
								else
								{
									$this->general_obj->insert_data($data,'elb_package_prices');
								}
							}
						}			
					}

					$this->db->trans_complete(); # Completing transaction

            		if ($this->db->trans_status() === FALSE)  
            		{
	                    # Something went wrong.
	                    $this->db->trans_rollback();
	                    $json =  array("status" => 0,"message"=>"Package Data Not Updated Somthing Wrong , Please Try Again");	
                
            		} 
            		else 
            		{
	                    # Everything is Perfect. 
	                    # Committing data to the database.
	                    $this->db->trans_commit();

	                    $json =  array("status" => 1,"message"=>"Package Data Updated Successfully");	   
	                }	
	                
				}
				else
				{
					$json =  array("status" => 0,"message"=>"Type Not Valid");
				}	
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }*/



    function update_package_by_id()
    {
    	$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{	
		    $this->form_validation->set_rules('package_id', 'package_id', 'required');
		    $this->form_validation->set_rules('package_data', 'package_data', 'required');
		    

		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$package_data = $_POST['package_data'];
				$packagedata = json_decode($package_data);


				$packageinfo = $this->general_obj->get_where_single(array('package_id'=>$_POST['package_id']),'elb_package');
				
				$resortinfo = $this->general_obj->get_where_single(array('resort_id'=>$packageinfo->resort_id),'elb_resort');

				$userinfo = $this->general_obj->get_where_single(array('user_id'=>$resortinfo->user_id),'elb_user');
				$lng = $userinfo->language;


				$this->db->trans_start(); # Starting Transaction

				for($i = 0; $i < count($packagedata); $i++)
 				{	
 					//$date = date('Y-m-d',strtotime($packagedata[$i]->date));
			        //$price = $packagedata[$i]->price;
			        //$middle_price = $packagedata[$i]->middle_price;
			        //$places_available = $packagedata[$i]->places_available;

 					$dates = date('Y-m-d',strtotime($packagedata[$i]->date));
					$packagedate_data = $this->general_obj->get_where_single(array('package_id'=>$_POST['package_id'],'package_date'=>$dates,'is_active'=>'1','is_delete'=>'0'),'elb_package_prices');

 					if(!empty($packagedate_data))
 					{
 						$date = date('Y-m-d',strtotime($packagedata[$i]->date));
				        
 						if($packagedata[$i]->price=='0')
 						{
 							$price = '0';
 						}
 						else
 						{
 							$price = !empty($packagedata[$i]->price) ? $packagedata[$i]->price : $packagedate_data->full_price ;
 						}

				        
				        if($packagedata[$i]->middle_price=='0')
				        {
				        	$middle_price = '0';
				        }
				        else
				        {	
				        	$middle_price = !empty($packagedata[$i]->middle_price) ? $packagedata[$i]->middle_price : $packagedate_data->half_price ;
				        }


				        if($packagedata[$i]->places_available=='0')
				        {
				        	$places_available = '0' ;
 						}
 						else
 						{
 							$places_available = !empty($packagedata[$i]->places_available) ? $packagedata[$i]->places_available : $packagedate_data->sheet_available ;
 						}
 					}
 					else
 					{	
 						$date = date('Y-m-d',strtotime($packagedata[$i]->date));
 						
 						if($packagedata[$i]->price=='0')
 						{
 							$price = '0';
 						}
 						else
 						{
 							$price = !empty($packagedata[$i]->price) ? $packagedata[$i]->price : $packageinfo->price ;
 						}

				        
				        if($packagedata[$i]->middle_price=='0')
				        {
				        	$middle_price = '0';
				        }
				        else
				        {	
				        	$middle_price = !empty($packagedata[$i]->middle_price) ? $packagedata[$i]->middle_price : $packageinfo->middle_price ;
				        }


				        if($packagedata[$i]->places_available=='0')
				        {
				        	$places_available = '0' ;
 						}
 						else
 						{
 							$places_available = !empty($packagedata[$i]->places_available) ? $packagedata[$i]->places_available : $packageinfo->places_available ;
 						}
	        
				    }
 						
	
					if($date < $packageinfo->start_date || $date > $packageinfo->end_date)
					{	
						$json =  array("status" => 0,"message"=>$date." Date defalut package wise not select");
						echo json_encode($json);
						exit;
					}
					else
					{	
						if($places_available > $packageinfo->total_places)
						{
							$json =  array("status" => 0,"message"=>"Available sheet Select less then to total place");
							echo json_encode($json);
							exit;
						}
						else
						{
							if($packageinfo->rent_type == 'middle_or_daily')
							{
								$middleprice = $middle_price;
							}
							else
							{
								$middleprice = NULL ;
							}

							$data=[
								"package_id" =>$_POST['package_id'],
								"package_date" => $date,
								"full_price" => $price,
								"half_price" => $middleprice,
								"sheet_available" => $places_available,
							];

							
							$paccheck = $this->general_obj->get_where_single(array("package_id" => $_POST['package_id'],'package_date'=>$date,'is_active'=>'1','is_delete'=>'0'),'elb_package_prices');

							if(!empty($paccheck))
							{
								$where = array("ex_package_id" => $paccheck->ex_package_id);
								$this->general_obj->update_data($data,$where,'elb_package_prices');
							}
							else
							{
								$this->general_obj->insert_data($data,'elb_package_prices');
							}
						}			
					}
				}

				$this->db->trans_complete(); # Completing transaction

        		if ($this->db->trans_status() === FALSE)  
        		{
                    # Something went wrong.
                    $this->db->trans_rollback();
                    $json =  array("status" => 0,"message"=>"Package Data Not Updated Somthing Wrong , Please Try Again");	
            
        		} 
        		else 
        		{
                    # Everything is Perfect. 
                    # Committing data to the database.
                    $this->db->trans_commit();

                    if($lng=='en')
                    {
                    	$json =  array("status" => 1,"message"=>"Package Data Updated Successfully");	   
                	}
                	else
                	{
                		$json =  array("status" => 1,"message"=>"Informazioni correttamente aggiornate");
                	}
                }	
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);
    }



    function booking_check_by_booking_id()
	{
		$method = $_SERVER['REQUEST_METHOD']; 
		if($method == 'POST')
		{
			$this->form_validation->set_rules('booking_id', 'booking_id', 'required');


		    if ($this->form_validation->run() == FALSE) {
				$error = implode(",", $this->form_validation->error_array());
				$error = explode(",", $error);
				$json = array("status" => 0,"message" =>  $error[0]);
			}
			else
			{	
				$bookinginfo = $this->general_obj->get_where_single(array('booking_id'=>$_POST['booking_id']),'elb_booking');

				if($bookinginfo->resort_check=='0')
				{
					$data=array(
						'resort_check'=>'1',
						
					);

					$upd = $this->general_obj->update_data($data,array('booking_id'=>$_POST['booking_id']),'elb_booking');
					
					if($upd > 0)
					{	
						$json =  array("status" => 1,"message"=>"Booking checked Successfully");	    	 
					}
					else
					{
						 $json = array("status" => 0,"message" => "Booking Not checked , Please Try Again");
					}
				}
				else
				{
					$json =  array("status" => 1,"message"=>"Booking checked Successfully");
				}
			}
	    }
	    else
	    { 
		    $json = array("status" => 0,"message" => "Request Method Cannot Be Accepted");
	    }
	    echo json_encode($json);							
	}





}
