<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #673ab7;
}

input:focus + .slider {
  box-shadow: 0 0 1px #673ab7;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}

.work-experience .info label {
    color: #000000;
    font-size: 13px;
    letter-spacing: 1px;
}
</style>


<!--  BEGIN CONTENT AREA  -->
<div id="content" class="main-content">
    <nav class="breadcrumb-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">Beach</a></li>
            <li class="breadcrumb-item"><a href="<?php echo base_url('admin/Beaches/beach_type');?>">List Beach Type</a></li>
            <li class="breadcrumb-item active" aria-current="page"><span>Add Beach Type</span></li>
        </ol>
    </nav>    


    <div class="layout-px-spacing">
                
        <div class="row layout-top-spacing">
        
            <div class="col-xl-12 col-lg-12 col-md-12 layout-spacing">
               
                <form autocomplete="off" method="post" class="section work-experience passform" enctype='multipart/form-data' name="beachtypeform1" id="beachtypeform1" >
                   
                    <div class="info">
                        <h5 class="">Add Beach Type</h5>
                        <div class="row">
                            <div class="col-md-11 mx-auto">

                                <div class="work-section">
                                    
                                    	
                                    	<div class="col-md-12">
                                    
                                            <div class="form-group">
                                                <label for="degree2">Type Name (EN)</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                <input type="text" class="form-control mb-4" id="type_name" name="type_name" required placeholder="Enter Type Name" >
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                    
                                            <div class="form-group">
                                                <label for="degree2">Type Name (IT)</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                <input type="text" class="form-control mb-4" id="type_name" name="type_name_it" required placeholder="Enter Type Name" >
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                 <label for="l31">Type Enable & Disable</label>
                                                 <br>
                                                  <label class="switch">
                                                      <input name="is_active" type="checkbox" id="is_active" value="1" checked >
                                                      <span class="slider round"></span>
                                                 </label>
                                              </div>
                                        </div>

                                        <div class="col-lg-12 text-center">
                                            <div class="ajax-load1 text-center" style="display:none;">
                                                <img src="<?php echo base_url('uploads/loader.gif');?>">
                                            </div>
                                            
                                            <div id="alert_message"></div>
                                                  
                                        <hr>
                                        <div class="form-actions">
                                          <button type="submit" id="checkfields" class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>

    </div>
    <div class="footer-wrapper">
        <div class="footer-section f-section-1">
            <p class="">Copyright © 2020 , All rights reserved.</p>
        </div>
    </div>
</div>
<!--  END CONTENT AREA  -->



<script src="<?php echo base_url('assets/') ?>jquery.min.js"></script>




<script>
$(document).ready(function (){    

    var frm = $('#beachtypeform1');
    frm.submit(function(e){
        e.preventDefault();

        $(".ajax-load1").show();
        $('#alert_message').html('');

        var formData = new FormData($(this)[0]);
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url().'admin/Beaches/add_save_beachetype'?>',
            data: formData,
            async: true,
            cache: false,
            contentType: false,
            processData: false,
            success: function(data)
            {   
                $(".ajax-load1").hide();

                var res = JSON.parse(data);

                status = res.status;
                message = res.message; 
                
                if(status=='success')
                {
                    swal({
                    title: 'Type Created successfully!',
                    type: 'success',
                    showCancelButton: false,
                    confirmButtonText: 'Done',
                    }).then((result) => {
                    if (result.value) {
                      location.href = "<?php echo base_url('admin/Beaches/beach_type') ?>";
                    }
                    
                    })  
                }
                else
                {
                    $('#alert_message').html('<div class="text-center alert alert-danger">'+message+'</div>');
                }
            }
        });
    });

});
</script>