<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #673ab7;
}

input:focus + .slider {
  box-shadow: 0 0 1px #673ab7;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}

.work-experience .info label {
    color: #000000;
    font-size: 13px;
    letter-spacing: 1px;
}
</style>


<!--  BEGIN CONTENT AREA  -->
<div id="content" class="main-content">
    <nav class="breadcrumb-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo base_url('admin/Beaches');?>">Beach</a></li>
            <li class="breadcrumb-item"><a href="<?php echo base_url('admin/Beaches/webcam/').$beach_id ;?>">List Beach Webcam</a></li>
            <li class="breadcrumb-item active" aria-current="page"><span>Edit Beach Webcam</span></li>
        </ol>
    </nav>    


    <div class="layout-px-spacing">
                
        <div class="row layout-top-spacing">
        
            <div class="col-xl-12 col-lg-12 col-md-12 layout-spacing">
               
                <form autocomplete="off" method="post" class="section work-experience passform" enctype='multipart/form-data' name="webform1" id="webform1" >
                   
					<input type="hidden" class="form-control mb-4"  name="beach_id" required value="<?php echo $beach_id ; ?>" >
					<input type="hidden" class="form-control mb-4"  name="webcam_id" required value="<?php echo $webcam_id ; ?>" >
					
                    <div class="info">
                        <h5 class="">Edit Beach Webcam</h5>
                        <div class="row">
                            <div class="col-md-11 mx-auto">

                                <div class="work-section">
                                   
                                    	
                                    	<div class="row">
											<div class="col-md-12">	
                                    	<hr>
                                        <br>
										
                                            <div class="form-group">
                                                <label for="degree2">Webcam Name</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                <input type="text" class="form-control mb-4" id="webcam_name" name="webcam_name" required placeholder="Enter Webcam Name" value="<?php echo $webcam->webcam_name ; ?>">
                                            </div>
                                        </div>
											<div class="col-md-12">	
                                            <div class="form-group">
                                                <label for="degree2">Webcam Link</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                <input type="text" class="form-control mb-4" id="webcam_link" name="webcam_link" required placeholder="Enter Webcam Link" value="<?php echo $webcam->webcam_link ; ?>">
                                            </div>
                                        </div>
									</div>
									
                          				<div class="row">
                                        	<div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="degree3">Webcam Location Latitude</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                    <input type="text" class="filterme form-control mb-4" id="latitude" name="latitude" required placeholder="Enter Latitude" value="<?php echo $webcam->latitude ; ?>">

                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="degree3">Webcam Location Longitude</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                    <input type="text" class="filterme form-control mb-4" id="longitude" name="longitude" required placeholder="Enter Longitude" value="<?php echo $webcam->longitude ; ?>">

                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                 <label for="l31">Webcam Enable & Disable</label>
                                                 <br>
                                                  <label class="switch">
                                                      <input name="is_active" type="checkbox" id="is_active" value="1" <?php if($webcam->is_active=='1'){ echo 'checked' ; } ?> >
                                                      <span class="slider round"></span>
                                                 </label>
                                              </div>
                                        </div>

                                        <div class="col-lg-12 text-center">
                                            <div class="ajax-load1 text-center" style="display:none;">
                                                <img src="<?php echo base_url('uploads/loader.gif');?>">
                                            </div>
                                            
                                            <div id="alert_message"></div>
                                                  
                                        <hr>
                                        <div class="form-actions">
                                          <button type="submit" id="checkfields" class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>

    </div>
    <div class="footer-wrapper">
        <div class="footer-section f-section-1">
            <p class="">Copyright © 2020 , All rights reserved.</p>
        </div>
    </div>
</div>
<!--  END CONTENT AREA  -->



<script src="<?php echo base_url('assets/') ?>jquery.min.js"></script>

<script>

$('.filterme').keypress(function(eve) {
  if ((eve.which != 46 || $(this).val().indexOf('.') != -1) && (eve.which < 48 || eve.which > 57) || (eve.which == 46 && $(this).caret().start == 0)) {
    eve.preventDefault();
  }

  // this part is when left part of number is deleted and leaves a . in the leftmost position. For example, 33.25, then 33 is deleted
  $('.filterme').keyup(function(eve) {
    if ($(this).val().indexOf('.') == 0) {
      $(this).val($(this).val().substring(1));
    }
  });
});
</script> 

<script>
$(document).ready(function (){    

    var frm = $('#webform1');
    frm.submit(function(e){
        e.preventDefault();

        $(".ajax-load1").show();
        $('#alert_message').html('');

        var formData = new FormData($(this)[0]);
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url().'admin/Beaches/edit_save_webcam'?>',
            data: formData,
            async: true,
            cache: false,
            contentType: false,
            processData: false,
            success: function(data)
            {   
                $(".ajax-load1").hide();

                var res = JSON.parse(data);

                status = res.status;
                message = res.message; 
                
                if(status=='success')
                {
                    swal({
                    title: 'Beach Webcam Updated successfully!',
                    type: 'success',
                    showCancelButton: false,
                    confirmButtonText: 'Done',
                    }).then((result) => {
                    if (result.value) {
                      location.href = "<?php echo base_url('admin/Beaches/webcam/').$beach_id ?>";
                    }
                    
                    })  
                }
                else
                {
                    $('#alert_message').html('<div class="text-center alert alert-danger">'+message+'</div>');
                }
            }
        });
    });

});
</script>