<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #673ab7;
}

input:focus + .slider {
  box-shadow: 0 0 1px #673ab7;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}

.work-experience .info label {
    color: #000000;
    font-size: 13px;
    letter-spacing: 1px;
}
</style>


<!--  BEGIN CONTENT AREA  -->
<div id="content" class="main-content">
    <nav class="breadcrumb-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">Promotions</a></li>
            <li class="breadcrumb-item"><a href="<?php echo base_url('admin/Promotions');?>">List Promotions</a></li>
            <li class="breadcrumb-item active" aria-current="page"><span>Add Promotions</span></li>
        </ol>
    </nav>    


    <div class="layout-px-spacing">
                
        <div class="row layout-top-spacing">
        
            <div class="col-xl-12 col-lg-12 col-md-12 layout-spacing">
               
                <form autocomplete="off" method="post" class="section work-experience passform" enctype='multipart/form-data' name="beachform1" id="beachform1" >
                   
                    <div class="info">
                        <h5 class="">Add Promotions</h5>
                        <div class="row">
                            <div class="col-md-11 mx-auto">

                                <div class="work-section">
                                   
                                    	

                                         <div class="col-md-12">
                                            <div class="row">
                                                <div class="col-md-4">
                                                     <div class="form-group">
                                                        <label for="degree3">Promo Type</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <select class="form-control basic" name="promo_type" id="promo_type" required >
                                                            <option value="" selected disabled>Select Type</option>
                                                            <option value="predefined">Predefined</option> 
                                                            <option value="keydiscount">Keydiscount</option>                                                                                              
                                                        </select>

                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                     <div class="form-group">
                                                        <label for="degree3">Promo Usage</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <select class="form-control basic" name="promo_usage" id="promo_usage" required >
                                                            <option value="" selected disabled>Select Type</option>
                                                            <option value="unlimited">Unlimited</option> 
                                                            <option value="limited">Limited</option>                                                                                              
                                                        </select>

                                                    </div>
                                                </div>

                                                <div class="col-md-4" id="numberusage" style="display:none;">
                                                     <div class="form-group">
                                                        <label for="degree3">Number of Promo Usage</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <input type="text" class="form-control mb-4 filterme" id="usage_number" name="usage_number"  placeholder="Number of Promo Usage" required>

                                                    </div>
                                                </div>

                                            	<div class="col-md-4" id="promoname" >
                                                    <div class="form-group">
                                                        <label for="degree3">Promo Code</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <input type="text" class="form-control mb-4" id="promo_name" name="promo_name"  placeholder="Enter Promo Code" pattern="^\S+$" title="No spaces are allowed in the promo code">

                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-4" id="resort1" style="display:none;">
                                                     <div class="form-group">
                                                        <label for="degree3">Resort</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <select class="form-control basic" name="resort_id" id="resort_id"  >
                                                            <option value="" selected disabled>Select Resort</option>
                                                               <?php foreach ($resorts as $rkey => $rvalue) { ?>
                                                                <option value="<?php echo $rvalue['resort_id']; ?>" ><?php echo $rvalue['resort_name']; ?></option>
                                                               <?php }?>                                                                                          
                                                        </select>

                                                    </div>
                                                </div>
                                                <div class="col-md-4" id="package1" style="display:none;">
                                                     <div class="form-group">
                                                        <label for="degree3">Package</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <select class="form-control basic" name="package_id" id="package_id"  >
                                                            
                                                                                                                                                                 
                                                        </select>

                                                    </div>
                                                </div>
                                                <div class="col-md-4" id="generatepromo" style="display:none;">
                                                     <div class="form-group">
                                                        <label for="degree3">Promo Generate</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <select class="form-control basic" name="promo_generate" id="promo_generate"  >
                                                            <option value="" selected disabled>Select</option>
                                                             <option value="system_generate" >System Generated</option> 
                                                            <option value="manual" >Manual</option>                                                                                              
                                                        </select>

                                                    </div>
                                                </div>

                                                <div class="col-md-4" id="numberpromo" style="display:none;">
                                                     <div class="form-group">
                                                        <label for="degree3">Number of Promo Generate</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <input type="text" class="form-control mb-4 filterme" id="number_promo" name="number_promo"  placeholder="Number of Promo Generate" required>

                                                    </div>
                                                </div>
                                              
                                                <div class="col-md-4">
                                                     <div class="form-group">
                                                        <label for="degree3">Discount Type</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <select class="form-control basic" name="discount_type" id="discount_type" required >
                                                            <option value="" selected disabled>Select Type</option>
                                                            <option value="Flat" >Flat</option> 
                                                            <option value="Percentage" >Percentage</option>                                                                                              
                                                        </select>

                                                    </div>
                                                </div>
                                                 <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label for="degree3">Discount Amount</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <input type="text" class="form-control mb-4 filterme" id="discount_amount" name="discount_amount"  placeholder="Enter Amount" required>

                                                    </div>
                                                </div>
                                                <div class="col-md-4" id="maxdisamount"  style="display:none;">
                                                    <div class="form-group">
                                                        <label for="degree3">Maximum Discount Amount</label>&nbsp;&nbsp;<span style="color:red;">(optional)</span>
                                                        <input type="text" class="form-control mb-4 filterme" id="max_discount_amount" name="max_discount_amount"  placeholder="Enter Maximum Discount Amount" value="0" >

                                                    </div>
                                                </div> 
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label for="degree3">Start Date</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                        <input type="date" class="form-control mb-4" id="start_date" name="start_date"  placeholder="Enter Start Date" required>

                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label for="degree3">End Date</label>
                                                        <input type="date" class="form-control mb-4" id="end_date" name="end_date"  placeholder="Enter End Date" >

                                                    </div>
                                                </div>
                                                 <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="degree2">Description ( EN )</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                            <textarea class="form-control" placeholder="Enter Description" rows="5" id="description"  name="description_en" required ></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="degree2">Description ( IT )</label>&nbsp;&nbsp;<span style="color:red;">*</span>
                                                            <textarea class="form-control" placeholder="Enter Description" rows="5" id="description"  name="description_it" required ></textarea>
                                                        </div>
                                                    </div>
                                            </div>
                                        </div>



                                       

										                

                                        <div class="col-lg-12 text-center">
                                            <div class="ajax-load1 text-center" style="display:none;">
                                                <img src="<?php echo base_url('uploads/loader.gif');?>">
                                            </div>
                                            
                                            <div id="alert_message"></div>
                                                  
                                        <hr>
                                        <div class="form-actions">
                                          <button type="submit" id="checkfields" class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>

    </div>
    <div class="footer-wrapper">
        <div class="footer-section f-section-1">
            <p class="">Copyright © 2020 , All rights reserved.</p>
        </div>
    </div>
</div>
<!--  END CONTENT AREA  -->



<script src="<?php echo base_url('assets/') ?>jquery.min.js"></script>

<script>

$('.filterme').keypress(function(eve) {
  if ((eve.which != 46 || $(this).val().indexOf('.') != -1) && (eve.which < 48 || eve.which > 57) || (eve.which == 46 && $(this).caret().start == 0)) {
    eve.preventDefault();
  }

  // this part is when left part of number is deleted and leaves a . in the leftmost position. For example, 33.25, then 33 is deleted
  $('.filterme').keyup(function(eve) {
    if ($(this).val().indexOf('.') == 0) {
      $(this).val($(this).val().substring(1));
    }
  });
});
</script> 


<script>
$(document).ready(function (){    

     $('#promo_type').change(function() {
                if ($(this).val() === 'predefined') {
                    $('#resort1').show();
                    $('#package1').show();
                    $('#resort_id').attr('required', true);
                    $('#package_id').attr('required', true);
                    $('#generatepromo').hide();
                    $('#promo_generate').removeAttr('required');
                    $('#numberpromo').hide();
                    $('#number_promo').removeAttr('required');
                    
                  
                }
                else if ($(this).val() === 'keydiscount') {
                    $('#generatepromo').show();
                     $('#promo_generate').attr('required', true);
                     
                    $('#resort1').hide();
                    $('#package1').hide();
                  
                    
                     $('#resort_id').removeAttr('required');
                     $('#package_id').removeAttr('required');

                }
                 else {
                    $('#resort1').hide();
                    $('#package1').hide();
                     $('#generatepromo').hide();
                     $('#resort_id').removeAttr('required');
                     $('#package_id').removeAttr('required');
                     $('#promo_generate').removeAttr('required');
                     $('#numberpromo').hide();
                    $('#number_promo').removeAttr('required');
                    
                }
            });

     $('#promo_generate').change(function() {
                if ($(this).val() === 'system_generate') {
                    
                    $('#numberpromo').show();
                     $('#number_promo').attr('required', true);
                    $('#promoname').hide();
                    $('#promo_name').removeAttr('required');
                    
                     
                }
                 else {
                    $('#promoname').show();
                    $('#promo_name').attr('required', true);
                    $('#numberpromo').hide();
                    $('#number_promo').removeAttr('required');
                   
                }
            });



      $('#resort_id').on('change', function() {
            var resort_id = $(this).val();
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url('admin/Promotions/get_package');?>',
                data: {
                    resort_id: resort_id
                },
                success: function(data) {
                    var jsonData = JSON.parse(data);
            
               // parse the JSON data
                    $('#package_id').html('<option value="" selected disabled>Select Package</option>');
                    $.each(jsonData, function(index, value) {
                     
                        $('#package_id').append('<option value="' + value.package_id + '" >' + value.package_service_name_en + '</option>');
                    });
                }
            });
        });

      

        $('#discount_type').change(function() {
                if ($(this).val() === 'Percentage') {
                  $('#maxdisamount').show();
                  
                }
                 else {
                    $('#maxdisamount').hide();
                  
                }
            });

        $('#promo_usage').change(function() {
                if ($(this).val() === 'limited') {
                  $('#numberusage').show();
                  $('#usage_number').attr('required', true);
                }
                 else {
                    $('#numberusage').hide();
                    $('#usage_number').removeAttr('required');
                }
            });

    
    

    var frm = $('#beachform1');
    frm.submit(function(e){
        e.preventDefault();

        $(".ajax-load1").show();
        $('#alert_message').html('');

        var formData = new FormData($(this)[0]);
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url().'admin/Promotions/add_save_promo'?>',
            data: formData,
            async: true,
            cache: false,
            contentType: false,
            processData: false,
            success: function(data)
            {   
                $(".ajax-load1").hide();

                var res = JSON.parse(data);

                status = res.status;
                message = res.message; 
                
                if(status=='success')
                {
                    swal({
                    title: 'Promo Created successfully!',
                    type: 'success',
                    showCancelButton: false,
                    confirmButtonText: 'Done',
                    }).then((result) => {
                    if (result.value) {
                      location.href = "<?php echo base_url('admin/Promotions') ?>";
                    }
                    
                    })  
                }
                else
                {
                    $('#alert_message').html('<div class="text-center alert alert-danger">'+message+'</div>');
                }
            }
        });
    });

});
</script>