<!DOCTYPE HTML>
<html lang="en">
<head>
    <title>Elba Login</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <link rel="stylesheet" href="<?php echo base_url('assets/frontend/css/login_style.css');?>">

    <link rel="icon" type="image/x-icon" href="<?php echo base_url('assets/frontend/favicon.png');?>"/>

</head>
<body>
    <section class="ftco-section">
        <div class="container">

            <div class="row justify-content-center">
                 <input class="form-control" type="hidden" id="email_otp" >
                 <input class="form-control" type="hidden" id="user_id" >
                <div class="col-md-6 col-lg-6" style="top: 68px;display: block;" id="emailforgot">
                    <form  method="post" class="passform content" enctype='multipart/form-data' name="resetform" id="resetform" >
                        <div class="login-wrap p-4 p-md-8">
                            <center><img src="<?php echo base_url('assets/frontend/img/logo.png'); ?>" style="width: 25%;"></center>
                            <br />
                            <h4 class="text-center mb-4">Forgot Password</h4>
                            <p>Enter your email and click the button. You’ll receive a otp in your email. Please use that and change the old password for a new one.</p>

                            <div class="form-group label-floating">
                                <label class="control-label">Your Email</label>
                                <input class="form-control" required name="email" type="email" placeholder="Enter Email" >
                            </div>

                            <div id="alert_message1"></div> 
          
                            <div class="col-lg-12 text-center">
                              <div class="ajax-load2 text-center" style="display: none;">
                                  <img src="<?php echo base_url('uploads/loader.gif');?>">
                              </div>
                            </div>
                    
                            <hr>
                            <div class="form-group">
                                <center><button type="submit" class="btn btn-primary  p-3 px-5">Send</button></center>
                            </div>
                    
                        </div>
                  </form>
            </div>

            <div class="col-md-6 col-lg-6" style="top: 68px;display: none" id="otpverify" >
                    <form  method="post" class="passform content" enctype='multipart/form-data' name="verifyform" id="verifyform" >
                        <div class="login-wrap p-4 p-md-8">
                            <center><img src="<?php echo base_url('assets/frontend/img/logo.png'); ?>" style="width: 25%;"></center>
                            <br />
                            <h4 class="text-center mb-4">Verify Otp</h4>
                            <p class="text-center">Enter Your email send OTP and Reset You Password</p>

                            <div class="form-group label-floating">
                                <label class="control-label">OTP</label>
                                <input class="form-control" required name="otp" id="otp" type="text" maxlength="6" placeholder="Enter 6 digit OTP" >
                            </div>

                            <div id="alert_message2"></div> 
          
                            <div class="col-lg-12 text-center">
                              <div class="ajax-load3 text-center" style="display: none;">
                                  <img src="<?php echo base_url('uploads/loader.gif');?>">
                              </div>
                            </div>
                    
                            <hr>
                            <div class="form-group">
                                <center><button type="submit" class="btn btn-primary  p-3 px-5">Send</button></center>
                            </div>
                    
                        </div>
                  </form>
            </div>


            <div class="col-md-6 col-lg-6" style="top: 68px;display: none" id="resetpassword" >
                    <form  method="post" class="passform content" enctype='multipart/form-data' name="resetpassform" id="resetpassform" >
                      <input class="form-control" name="dataid" type="hidden" id="reset_user_id" >
                        <div class="login-wrap p-4 p-md-8">
                            <center><img src="<?php echo base_url('assets/frontend/img/logo.png'); ?>" style="width: 25%;"></center>
                            <br />
                            <h4 class="text-center mb-4">Reset Your Password</h4>

                            <div class="form-group label-floating">
                                <label class="control-label">New Password</label>
                                <input class="form-control" required name="new_password" type="password" placeholder="Enter New Password" >
                            </div>

                            <div class="form-group label-floating">
                                <label class="control-label">Confirm Password</label>
                                <input class="form-control" required name="conf_password" type="password" placeholder="Enter Confirm Password " >
                            </div>

                            <div id="alert_message4"></div> 
          
                            <div class="col-lg-12 text-center">
                              <div class="ajax-load4 text-center" style="display: none;">
                                  <img src="<?php echo base_url('uploads/loader.gif');?>">
                              </div>
                            </div>
                    
                            <hr>
                            <div class="form-group">
                                <center><button type="submit" class="btn btn-primary  p-3 px-5">Send</button></center>
                            </div>
                    
                        </div>
                  </form>
            </div>

        </div>
    </div>
</section>


<script src="<?php echo base_url('assets/') ?>jquery.min.js"></script>

<script>
$(document).ready(function()
{

    var frm = $('#resetform');
    frm.submit(function(e){
        e.preventDefault();

        
          $("#alert_message1").html('');
          $(".ajax-load2").show();

          var formData = new FormData($(this)[0]);
          $.ajax({
              type: 'POST',
              url: '<?php echo base_url().'Login/send_reset_password'?>',
              data: formData,
              async: true,
              cache: false,
              contentType: false,
              processData: false,
              success: function(data)
              {   
                  //alert(data);
                  $(".ajax-load2").hide();
                  
                  var res = JSON.parse(data);

                  status = res.status;
                  message = res.message;
                  user_id = res.user_id; 
                  email = res.email;  
                  email_otp = res.email_otp;  

                  if(status=='1')
                  {
                      $('#alert_message1').html('<div class="text-center alert alert-success">'+message+'</div>');
                      $('#email_otp').val(email_otp);
                      $('#user_id').val(user_id);
                      $('#emailforgot').hide();
                      $('#otpverify').show();

                  }
                  else
                  {
                      $('#alert_message1').html('<div class="text-center alert alert-danger">'+message+'</div>');
                      $('#emailforgot').show();
                      $('#otpverify').hide();
                  }
              }
        });
    });


    var frm = $('#verifyform');
    frm.submit(function(e){
        e.preventDefault();

        
          $("#alert_message2").html('');
          $(".ajax-load3").show();
          var emilotp = $('#email_otp').val();
          var id = $('#user_id').val();
          var otp = $('#otp').val();

          
          if(emilotp==otp)
          {   
              $(".ajax-load3").hide();   
              $('#reset_user_id').val(id); 
              $('#otpverify').hide();
              $('#resetpassword').show();
          }
          else
          { 
             $(".ajax-load3").hide(); 
             $('#alert_message2').html('<div class="text-center alert alert-danger">OTP not same,please try again.</div>');
             $('#otpverify').show();
             $('#resetpassword').hide();
          }  

    });


    var frm = $('#resetpassform');
    frm.submit(function(e){
        e.preventDefault();

        
          $("#alert_message4").html('');
          $(".ajax-load4").show();

          var formData = new FormData($(this)[0]);
          $.ajax({
              type: 'POST',
              url: '<?php echo base_url().'Login/password_reset'?>',
              data: formData,
              async: true,
              cache: false,
              contentType: false,
              processData: false,
              success: function(data)
              {   
                  //alert(data);
                  $(".ajax-load4").hide();
                  
                  var res = JSON.parse(data);

                  status = res.status;
                  message = res.message;

                  if(status=='1')
                  {
                      $('#alert_message4').html('<div class="text-center alert alert-success">'+message+'</div>');

                      setInterval(function(){
                        location.href='<?php echo base_url('Login');?>';
                      }, 3000);
                  }
                  else
                  {
                      $('#alert_message4').html('<div class="text-center alert alert-danger">'+message+'</div>');
                  }
                  
              }
        });
    });

    
});

</script>




</body>
</html>
<!-- 0000FF -->
