<style>
  :root {
  --card-line-height: 1.2em;
  --card-padding: 1em;
  --card-radius: 0.5em;
  --color-green: #558309;
  --color-gray: #e2ebf6;
  --color-dark-gray: #c4d1e1;
  --radio-border-width: 2px;
  --radio-size: 1.5em;
}



.grid {
  display: grid;
  grid-gap: var(--card-padding);
  margin: 0 auto;
  max-width: 60em;
  padding: 0;
 
  @media (min-width: 42em) {
    grid-template-columns: repeat(3, 1fr);
  }
}

.card {
  background-color: #fff;
  border-radius: var(--card-radius);
  position: relative;
  
  &:hover {
    box-shadow: 5px 5px 10px rgba(0, 0, 0, 0.15);
  }
}

.radio {
  font-size: inherit;
  margin: 0;
  position: absolute;
  right: calc(var(--card-padding) + var(--radio-border-width));
  top: calc(var(--card-padding) + var(--radio-border-width));
}


.plan-details {
  border: var(--radio-border-width) solid var(--color-gray);
  border-radius: var(--card-radius);
  cursor: pointer;
  display: flex;
  flex-direction: column;
  padding: var(--card-padding);
  transition: border-color 0.2s ease-out;
}

.card:hover .plan-details {
  border-color: var(--color-dark-gray);
}

.radio:checked ~ .plan-details {
  border-color: var(--color-green);
}

.radio:focus ~ .plan-details {
  box-shadow: 0 0 0 2px var(--color-dark-gray);
}

.radio:disabled ~ .plan-details {
  color: var(--color-dark-gray);
  cursor: default;
}

.radio:disabled ~ .plan-details .plan-type {
  color: var(--color-dark-gray);
}

.card:hover .radio:disabled ~ .plan-details {
  border-color: var(--color-gray);
  box-shadow: none;
}

.card:hover .radio:disabled {
    border-color: var(--color-gray);
  }

.plan-type {
  color: var(--color-green);
  font-size: 1.5rem;
  font-weight: bold;
  line-height: 1em;
}

.plan-cost {
  font-size: 2.5rem;
  font-weight: bold;
  padding: 0.5rem 0;
}

.slash {
  font-weight: normal;
}

.plan-cycle {
  font-size: 2rem;
  font-variant: none;
  border-bottom: none;
  cursor: inherit;
  text-decoration: none;
}

.hidden-visually {
  border: 0;
  clip: rect(0, 0, 0, 0);
  height: 1px;
  margin: -1px;
  overflow: hidden;
  padding: 0;
  position: absolute;
  white-space: nowrap;
  width: 1px;
}
</style> 



 <!--  wrapper  -->
            <div id="wrapper">
                <!-- content-->
                <div class="content">
                    <div class="breadcrumbs-fs fl-wrap">
                        <div class="container">
                            <div class="breadcrumbs fl-wrap"><a href="#">Home</a><span>Booking Page</span></div>
                        </div>
                    </div>
                    <section class="middle-padding gre y-blue-bg">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-2"></div>
                                <div class="col-md-8 text-center">
                                    <div class="bookiing-form-wrap">
                                        <ul id="progressbar">
                                            <li>Add Payment Card</li>
                                        </ul>
                                        <!--   list-single-main-item -->
                                        <div class="list-single-main-item fl-wrap hidden-section tr-sec">
                                            <div class="profile-edit-container">
                                                <div class="custom-form">

                                                    <form autocomplete="off" method="post" class="passform" enctype='multipart/form-data' name="passeditform2" id="passeditform2">
                                                       

                                                        <fieldset class="fl-wrap book_mdf">
                                                            <div class="list-single-main-item-title fl-wrap">
                                                                <h3>Payment method</h3>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-12">
                                                                    <label>Card Number <i class="filterme fal fa-credit-card-front"></i></label>
                                                                    <input type="text" required name="card_number" placeholder="xxxx-xxxx-xxxx-xxxx" maxlength="16" /> 
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-4">
                                                                    <label>Expiry Month<i class="filterme fal fa-calendar"></i></label>
                                                                    <input type="text" required placeholder="MM" maxlength="2" name="expiry_month"/>                                                  
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label>Expiry Year<i class="filterme fal fa-calendar"></i></label>
                                                                    <input type="text" required placeholder="YYYY" maxlength="4" name="expiry_year" />                                                  
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <label>CVV / CVC *<i class="filterme fal fa-credit-card"></i></label>
                                                                    <input type="password" required placeholder="***" maxlength="3" name="cvc_code" /> 
                                                                </div>
                                                            </div>

                                                         
                                                            
                                                            <span class="fw-separator"></span>


                                                            <div class="ajax-load2" style="display:none;">
                                                                <img src="<?php echo base_url('uploads/loader.gif');?>">
                                                            </div>
                                                            <div class="text-center" id="alt_message"></div>
                                                            <br><br>
                                                            <button  type="submit" class="action-button btn color2-bg no-shdow-btn">
                                                                Save
                                                                <i class="fal fa-angle-right"></i>
                                                            </button>                                               
                                                        </fieldset>
                                                        
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--   list-single-main-item end -->
                                    </div>
                                </div>
                                <div class="col-md-2"></div>
                                
                            </div>
                            <div class="row">
                                <div class="col-md-2"></div>
                                <div class="col-md-8 text-center">
                                    <div class="bookiing-form-wrap">
                                        <ul id="progressbar">
                                            <li>Select Payment Card List</li>
                                        </ul>
                                        <!--   list-single-main-item -->
                                        <div class="list-single-main-item fl-wrap hidden-section tr-sec">
                                            <div class="profile-edit-container">
                                                <div class="custom-form">
                                                    <form id="cityform1">
                                                       

                                                       <div id="cartdetail"></div>

                                                      <div class="col-md-12" id='emptycart' style="display: none;">
                                                          <h4>No Any Card</h4>
                                                      </div>

                                                      <div class="col-lg-12 text-center" id="nxtbtn" style="display: none;">
                                                        <br></br>
                                                         <button type="submit" class="btn-md header-search-button" style="background-color: #3AACED;">Next</button>
                                                      </div>
                                                                                      
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--   list-single-main-item end -->
                                    </div>
                                </div>
                                <div class="col-md-2"></div>
                            </div>
                        </div>
                    </section>
                    <!-- section end -->
                </div>
                <!-- content end-->
            </div>
            <!--wrapper end -->



<script src="<?php echo base_url('assets/') ?>jquery.min.js"></script>


<script>

$(document).ready(function()
{
    cardlist();


  function cardlist()
  {
      var action = 'fetch_card_list';


      $.ajax({
          url:"<?php echo base_url('Packages/fetch_card_list') ;?>",
          method:"POST",
          data:{
              action:action,
          },
          cache: false,
          success:function(datas)
          {   
            var res = JSON.parse(datas);

             status = res.output ; 
                

              if(status=='no')
              {
                $('#emptycart').show();
                $('#cartdetail').html('');
                $('#nxtbtn').hide();
              } 
              else
              { 
                $('#emptycart').hide();
                $('#cartdetail').html(status);
                $('#nxtbtn').show();
              }
          }   
      })  
  }


  var frm = $('#passeditform2');
    frm.submit(function(e){
        e.preventDefault();

        $("#alt_message").html('');
        $(".ajax-load2").show();

        var formData = new FormData($(this)[0]);
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url().'Packages/add_user_card'?>',
            data: formData,
            async: true,
            cache: false,
            contentType: false,
            processData: false,
            success: function(datas)
            {   


                $(".ajax-load2").hide();

                var res = JSON.parse(datas);
                    
                status = res.status ; 
                message = res.message ; 
                 
                if(status==0)
                {
                     $('#alt_message').html('<div class="text-center" style="color:red;">'+message+'</div>');
                }
                else
                {   
                     $('#alt_message').html('<div class="text-center" style="color:green;>'+message+'</div>');
                      $('#passeditform2')[0].reset();
                     cardlist();
                    
                }

            }
        });
    });


    var frm = $('#cityform1');
    frm.submit(function(e){
        e.preventDefault();


          var formData = new FormData($(this)[0]);
          $.ajax({
              type: 'POST',
              url: '<?php echo base_url().'Packages/session_card_data'?>',
              data: formData,
              async: true,
              cache: false,
              contentType: false,
              processData: false,
              success: function(data)
              {   
                  location.href = "<?php echo base_url('Booking'); ?>";   
              }
          });
    });




});

</script> 